/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.formplugin.web.apilink.list;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.mvc.list.ListView;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.apilink.IAPILinkConfigDomainService;
import kd.hdtc.hrdi.formplugin.web.common.list.CommonListPlugin;

public class APILinkConfigListPlugin
extends CommonListPlugin {
    private final IAPILinkConfigDomainService domainService = (IAPILinkConfigDomainService)ServiceFactory.getService(IAPILinkConfigDomainService.class);
    private final String SELECT_DATA_TIP = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"APILinkConfigListPlugin_0", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]);
    private final String SELECT_DATA_ONE_TIP = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6d4b\u8bd5\u7684\u6570\u636e\u3002", (String)"APILinkConfigListPlugin_1", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]);
    private final String SUCCESS_TIP = ResManager.loadKDString((String)"\u6d4b\u8bd5\u6210\u529f", (String)"APILinkConfigListPlugin_2", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]);

    public APILinkConfigListPlugin() {
        this.HIDE_FIELD_SET.add("enable");
        this.HIDE_FIELD_SET.add("issyspreset");
        this.HIDE_FIELD_SET.add("description");
        this.HIDE_FIELD_SET.add("index");
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "testconn": {
                this.doTest();
                break;
            }
            case "networkcheck": {
                this.showNetworkCheckPage();
                break;
            }
        }
    }

    private void showNetworkCheckPage() {
        List<Long> selectedPkIdList = this.getSelectedPkId();
        String msg = this.validateBeforeTest(selectedPkIdList);
        if (StringUtils.isNotEmpty((String)msg)) {
            this.getView().showErrorNotification(msg);
            return;
        }
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("hrdi_networkcheck");
        parameters.setCustomParam("id", (Object)selectedPkIdList.get(0));
        parameters.setHasRight(true);
        this.getView().showForm(parameters);
    }

    private void doTest() {
        List<Long> selectedPkIdList = this.getSelectedPkId();
        String msg = this.validateBeforeTest(selectedPkIdList);
        if (StringUtils.isNotEmpty((String)msg)) {
            this.getView().showErrorNotification(msg);
            return;
        }
        String result = this.domainService.test(selectedPkIdList.get(0));
        if ("success".equals(result)) {
            this.getView().showSuccessNotification(this.SUCCESS_TIP);
        } else {
            this.getView().showErrorNotification(result);
        }
        this.getView().invokeOperation("refresh");
    }

    private String validateBeforeTest(List<Long> selectedPkIdList) {
        if (CollectionUtils.isEmpty(selectedPkIdList)) {
            return this.SELECT_DATA_TIP;
        }
        if (selectedPkIdList.size() > 1) {
            return this.SELECT_DATA_ONE_TIP;
        }
        return null;
    }

    private List<Long> getSelectedPkId() {
        ListSelectedRowCollection selectedRowCollection = ((ListView)this.getView()).getSelectedRows();
        return selectedRowCollection.stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toList());
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List fastFilterList = args.getCommonFilterColumns();
        fastFilterList.removeIf(column -> "enable".equals(column.getFieldName()));
        List schemeFilterColumnList = args.getSchemeFilterColumns();
        schemeFilterColumnList.removeIf(column -> this.HIDE_FIELD_SET.contains(column.getFieldName()));
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List listColumnList = args.getListColumns();
        listColumnList.removeIf(column -> this.HIDE_FIELD_SET.contains(column.getListFieldKey()));
    }
}

