/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.formplugin.web.blacklist.form;

import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.formplugin.web.HDTCDataBaseEdit;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.config.IHRDIBaseConfigDomainService;
import kd.hdtc.hrdi.common.adaptor.utils.EntityFieldToComboItemUtil;

public class BizIntFieldBlackListEditPlugin
extends HDTCDataBaseEdit {
    private final IHRDIBaseConfigDomainService domainService = (IHRDIBaseConfigDomainService)ServiceFactory.getService(IHRDIBaseConfigDomainService.class);

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        String blackList = this.domainService.queryBaseConfigValueByNumber("int.field.global.blacklist");
        this.getPageCache().put("blackList", blackList);
        String entityId = this.getModel().getDataEntity().getString("entityobj.id");
        this.initReferenceFieldItems(entityId);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propertyName = args.getProperty().getName();
        if ("entityobj".equals(propertyName)) {
            this.setReferenceFieldItems(args);
        }
    }

    private void setReferenceFieldItems(PropertyChangedArgs args) {
        DynamicObject bizObj = (DynamicObject)args.getChangeSet()[0].getNewValue();
        if (bizObj == null) {
            ComboEdit comboEdit = (ComboEdit)this.getControl("fieldselect");
            comboEdit.setComboItems(null);
            return;
        }
        String entityId = bizObj.getString("id");
        this.initReferenceFieldItems(entityId);
        this.getModel().setValue("fieldselect", null);
    }

    private void initReferenceFieldItems(String entityId) {
        if (StringUtils.isEmpty((String)entityId)) {
            return;
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl("fieldselect");
        List comboItems = EntityFieldToComboItemUtil.getEntityItems((String)entityId, (boolean)false);
        if (CollectionUtils.isEmpty((Collection)comboItems)) {
            return;
        }
        this.blackListHandle(comboItems);
        comboEdit.setComboItems(comboItems);
    }

    private void blackListHandle(List<ComboItem> comboItems) {
        String blackList = this.getPageCache().get("blackList");
        String[] split = blackList.split(",");
        Set blackFieldSet = Arrays.stream(split).collect(Collectors.toSet());
        comboItems.removeIf(comboItem -> blackFieldSet.contains(comboItem.getValue()));
    }
}

