/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.formplugin.web.common.form;

import java.util.ArrayList;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hdtc.hrdbs.formplugin.web.HDTCDataBaseEdit;
import kd.hdtc.hrdi.business.application.service.middle.IMidTableConfigApplicationService;
import kd.hdtc.hrdi.business.common.ServiceFactory;

public class IntSourceClearEditPlugin
extends HDTCDataBaseEdit {
    private final IMidTableConfigApplicationService applicationService = (IMidTableConfigApplicationService)ServiceFactory.getService(IMidTableConfigApplicationService.class);

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (!this.checkPerm(args)) {
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        DynamicObjectCollection entityObjects = this.getModel().getDataEntity().getDynamicObjectCollection("entityobj");
        ArrayList entityList = new ArrayList(10);
        entityObjects.forEach(dyn -> entityList.add(dyn.getString("fbasedataid_id")));
        this.applicationService.clearByEntityObj(entityList);
    }

    private boolean checkPerm(BeforeDoOperationEventArgs beforeDoOperationEventArgs) {
        long userId = RequestContext.get().getCurrUserId();
        boolean adminUser = PermissionServiceHelper.isAdminUser((long)userId);
        if (!adminUser) {
            String entityName = this.getView().getFormShowParameter().getFormName();
            String operateName = ((FormOperate)beforeDoOperationEventArgs.getSource()).getOperateName().getLocaleValue();
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff0c\u60a8\u6ca1\u6709\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u6743\u9650\u3002", (String)"CommonPermListPlugin_0", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]), entityName, operateName));
            return false;
        }
        return true;
    }
}

