/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.formplugin.web.intgovern.form;

import java.util.Arrays;
import java.util.EventObject;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.lang.Lang;
import kd.bos.mvc.list.ListView;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.BackgroundTaskSubscriber;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.formplugin.web.HDTCDataBaseEdit;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.datamapping.IDataMappingRecordDomainService;
import kd.hdtc.hrdi.business.task.datamapping.DataMappingTask;
import kd.hdtc.hrdi.business.task.datamapping.DataMappingTaskClick;
import kd.hdtc.hrdi.common.util.HRDICacheUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class DataMappingProgressEditPlugin
extends HDTCDataBaseEdit
implements ProgresssListener {
    private static final String PROGRESS_CACHE_KEY = "progressCacheKey";
    private static final String JOB_FORM_INFO = "JobFormInfo";
    private IDataMappingRecordDomainService dataMappingRecordDomainService = (IDataMappingRecordDomainService)ServiceFactory.getService(IDataMappingRecordDomainService.class);

    public void registerListener(EventObject eventObject) {
        ProgressBar progressBar = (ProgressBar)this.getControl("progress");
        progressBar.addProgressListener((ProgresssListener)this);
        Button button = (Button)this.getControl("btnok");
        button.addClickListener((ClickListener)this);
    }

    public void afterBindData(EventObject eventObject) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"btncancel", "resultpanel"});
        ProgressBar bar = (ProgressBar)this.getView().getControl("progress");
        bar.start();
        String taskId = this.getTaskId();
        if (HRStringUtils.isNotEmpty((String)taskId)) {
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            int progress = taskInfo.getProgress();
            if (progress >= 100) {
                progress = 99;
            }
            bar.setPercent(progress);
        } else {
            this.setBackRunBtnEnable(Boolean.FALSE);
        }
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        if (StringUtils.equalsIgnoreCase((String)"btnok", (String)source.getKey())) {
            this.closeForm();
            this.doTranBackground();
        }
    }

    public void onProgress(ProgressEvent progressEvent) {
        String taskId = this.getTaskId();
        if (HRStringUtils.isEmpty((String)taskId)) {
            this.dispatchTask();
            this.setBackRunBtnEnable(Boolean.TRUE);
            return;
        }
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        if (taskInfo.isTaskEnd()) {
            String batchNumber = this.getBatchNumber();
            this.stopProgressByCache(progressEvent);
            HRDICacheUtils.remove((String)PROGRESS_CACHE_KEY);
            this.setLabelForResultData(batchNumber);
        } else {
            progressEvent.setProgress(taskInfo.getProgress());
        }
    }

    private void stopProgressByCache(ProgressEvent evt) {
        evt.setProgress(100);
        this.stopBar();
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        parentView.updateView();
        if (parentView instanceof ListView) {
            ((ListView)parentView).clearSelection();
        }
        this.getView().sendFormAction(parentView);
    }

    private void setLabelForResultData(String batchNumber) {
        this.getView().setVisible(Boolean.TRUE, new String[]{"resultpanel", "btncancel"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"progresspanel", "btnok"});
        long successCount = 0L;
        long failCount = 0L;
        long ignoreCount = 0L;
        Object[] dynamicObjects = this.dataMappingRecordDomainService.queryDataMappingRecord(batchNumber);
        if (ArrayUtils.isNotEmpty((Object[])dynamicObjects)) {
            successCount = Arrays.stream(dynamicObjects).map(dynamicObject -> dynamicObject.getInt("successcount")).reduce(Integer::sum).orElse(0).intValue();
            failCount = Arrays.stream(dynamicObjects).map(dynamicObject -> dynamicObject.getInt("failcount")).reduce(Integer::sum).orElse(0).intValue();
            ignoreCount = Arrays.stream(dynamicObjects).map(dynamicObject -> dynamicObject.getInt("ignorecount")).reduce(Integer::sum).orElse(0).intValue();
        }
        ((Label)this.getView().getControl("successnum")).setText(String.valueOf(successCount));
        ((Label)this.getView().getControl("failnum")).setText(String.valueOf(failCount));
        ((Label)this.getView().getControl("ignorenum")).setText(String.valueOf(ignoreCount));
    }

    private void stopBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl("progress");
        bar.stop();
    }

    private String getBatchNumber() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object batchNumber = customParams.get("batchnumber");
        if (batchNumber != null) {
            return String.valueOf(batchNumber);
        }
        String progressCacheValue = (String)HRDICacheUtils.get((String)PROGRESS_CACHE_KEY, String.class);
        if (progressCacheValue != null) {
            Map params = (Map)SerializationUtils.fromJsonString((String)progressCacheValue, Map.class);
            return String.valueOf(params.get("batchnumber"));
        }
        return null;
    }

    private void doTranBackground() {
        String taskId = this.getTaskId();
        if (HRStringUtils.isEmpty((String)taskId)) {
            return;
        }
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        if (taskInfo.isTaskEnd()) {
            return;
        }
        if (!TaskClientProxy.isExistTask((String)taskId)) {
            JobFormInfo jobFormInfo = this.getJobFormInfo();
            if (jobFormInfo == null || StringUtils.isEmpty((String)taskInfo.getId())) {
                return;
            }
            TaskClientProxy.addTask((IFormView)this.getView(), (JobFormInfo)jobFormInfo, (TaskInfo)taskInfo);
            BackgroundTaskSubscriber subscriber = new BackgroundTaskSubscriber(RequestContext.get(), jobFormInfo, taskId);
            ThreadPools.executeOnce((String)"datamappingtask-background-monitor", (Runnable)subscriber);
        }
    }

    private void closeForm() {
        TaskClientProxy.setProgressPageId((String)this.getTaskId(), (String)"");
        this.getView().close();
    }

    private void dispatchTask() {
        JobFormInfo jobFormInfo = this.dispatch(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u6620\u5c04\u5173\u7cfb\u540c\u6b65", (String)"DataMappingTask_1", (String)"hdtc-hrdi-business", (Object[])new Object[0]), this.getView().getFormShowParameter().getCustomParams());
        if (HRStringUtils.isEmpty((String)jobFormInfo.getJobInfo().getAppId())) {
            jobFormInfo.getJobInfo().setAppId(this.getView().getFormShowParameter().getServiceAppId());
        }
        String taskId = ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
        this.setTaskId(taskId);
        this.insertCache(jobFormInfo, taskId);
    }

    private void insertCache(JobFormInfo jobFormInfo, String taskId) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.put(JOB_FORM_INFO, SerializationUtils.toJsonString((Object)jobFormInfo));
        customParams.put("taskId", taskId);
        HRDICacheUtils.put((String)PROGRESS_CACHE_KEY, (Object)SerializationUtils.toJsonString((Object)customParams));
    }

    private JobFormInfo getJobFormInfo() {
        String params = (String)HRDICacheUtils.get((String)PROGRESS_CACHE_KEY, String.class);
        if (!HRStringUtils.isEmpty((String)params)) {
            Map customParams = (Map)SerializationUtils.fromJsonString((String)params, Map.class);
            String str = customParams.get(JOB_FORM_INFO).toString();
            if (HRStringUtils.isEmpty((String)str)) {
                return null;
            }
            return (JobFormInfo)SerializationUtils.fromJsonString((String)str, JobFormInfo.class);
        }
        return null;
    }

    private JobFormInfo dispatch(String name, Map<String, Object> customParamMap) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setAppId("hrdi");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(UserServiceHelper.getCurrentUserId());
        jobInfo.setName(name);
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname(DataMappingTask.class.getName());
        jobInfo.setParams(customParamMap);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCaption(name);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setCanStop(true);
        jobFormInfo.setClickClassName(DataMappingTaskClick.class.getName());
        jobFormInfo.setRootPageId(this.getView().getFormShowParameter().getRootPageId());
        jobFormInfo.setParentPageId(this.getView().getParentView().getPageId());
        return jobFormInfo;
    }

    private void setTaskId(String taskId) {
        this.getPageCache().put("taskId", taskId);
    }

    private String getTaskId() {
        if (this.getView().getFormShowParameter().getCustomParams().containsKey("taskId")) {
            return (String)this.getView().getFormShowParameter().getCustomParam("taskId");
        }
        return this.getPageCache().get("taskId");
    }

    private void setBackRunBtnEnable(Boolean isEnable) {
        this.getView().setEnable(isEnable, new String[]{"btnok"});
    }
}

