/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.formplugin.web.intgovern.form;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.form.control.Label;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.monitor.IIntLogDomainService;
import kd.hdtc.hrdi.business.task.intlog.IntLogTask;
import kd.hdtc.hrdi.business.task.intlog.IntLogTaskClick;
import kd.hdtc.hrdi.common.util.HRDICacheUtils;
import kd.hdtc.hrdi.formplugin.web.intgovern.form.ProgressEditPlugin;
import kd.hr.hbp.common.util.HRStringUtils;

public class IntLogProgressEditPlugin
extends ProgressEditPlugin {
    private static final String CACHE_KEY = "int_log_cache_key";
    private static final String DEFAULT_PROPERTIES = "id, parent, intsource, operatestatus";
    private final IIntLogDomainService intLogDomainService = (IIntLogDomainService)ServiceFactory.getService(IIntLogDomainService.class);

    @Override
    protected void dispatchTask() {
        String name = ResManager.loadKDString((String)"\u96c6\u6210\u65e5\u5fd7\u91cd\u8bd5", (String)"IntLogProgressEditPlugin_1", (String)"hdtc-hrdi-business", (Object[])new Object[0]);
        JobFormInfo jobFormInfo = this.dispatch(name, this.getView().getFormShowParameter().getCustomParams(), IntLogTask.class.getName(), IntLogTaskClick.class.getName());
        if (HRStringUtils.isEmpty((String)jobFormInfo.getJobInfo().getAppId())) {
            jobFormInfo.getJobInfo().setAppId(this.getView().getFormShowParameter().getServiceAppId());
        }
        String taskId = ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
        this.setTaskId(taskId);
        this.insertCache(jobFormInfo, taskId, CACHE_KEY);
    }

    @Override
    protected void calculateResult() {
        HRDICacheUtils.remove((String)CACHE_KEY);
        this.getView().setVisible(Boolean.TRUE, new String[]{"btncancel", "resultpanel"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"progresspanel", "btnok"});
        Object intLogIds = this.getView().getFormShowParameter().getCustomParam("intLogIds");
        long successCount = this.getHandleCount(intLogIds);
        ((Label)this.getView().getControl("successall")).setText(String.valueOf(successCount));
        this.getView().setEnable(Boolean.TRUE, new String[]{"btncancel"});
    }

    @Override
    protected void tranBackGround() {
        this.doTranBackground(CACHE_KEY, "IntLogProgress-background-monitor");
    }

    private int getHandleCount(Object intLogIds) {
        if (intLogIds == null) {
            return 0;
        }
        List ids = (List)intLogIds;
        DynamicObject[] intLogList = this.intLogDomainService.query(DEFAULT_PROPERTIES, ids.toArray());
        HashSet parentIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet childIntLogs = Sets.newHashSetWithExpectedSize((int)intLogList.length);
        Arrays.stream(intLogList).forEach(intLog -> {
            DynamicObject parent = intLog.getDynamicObject("parent");
            if (parent == null) {
                parentIds.add(intLog.getLong("id"));
            } else {
                childIntLogs.add(intLog.getLong("id"));
            }
        });
        Object[] dynamicObjects = this.intLogDomainService.queryListByParentIdList(new ArrayList(parentIds));
        if (ArrayUtils.isNotEmpty((Object[])dynamicObjects)) {
            Stream.of(dynamicObjects).forEach(intLog -> {
                if (!childIntLogs.contains(intLog.getLong("id"))) {
                    childIntLogs.add(intLog.getLong("id"));
                }
            });
        }
        return childIntLogs.size();
    }
}

