/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.formplugin.web.intgovern.form;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.OperationType;
import kd.bos.entity.operate.OperationTypeCache;
import kd.bos.entity.operate.OperationTypes;
import kd.bos.form.IFormView;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.DesignMeta;
import kd.bos.metadata.entity.operation.OperationTypeLoader;
import kd.bos.metadata.form.DesignFormMeta;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.hdtc.hrdbs.common.util.StringUtils;

public class IntOperationTypeSelectEditPlugin
extends AbstractFormPlugin
implements ClickListener,
RowClickEventListener {
    private final String[] entityOpParams = new String[]{"fvalidruledes", "fservice", "fserviceplugin", "fservicedesc"};

    public void initialize() {
        Button btn = (Button)this.getView().getControl("btnok");
        btn.addClickListener((ClickListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("EntryEntity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject eventObject) {
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam("entityid");
        if (StringUtils.isEmpty((String)entityId)) {
            return;
        }
        DesignMeta designMeta = (DesignMeta)BusinessDataReader.read((Object)entityId, (IDataEntityType)OrmUtils.getDataEntityType(DesignFormMeta.class), (Boolean)false);
        String modelType = designMeta.getModelType();
        if (modelType.startsWith("ParameterFormModel")) {
            modelType = "DynamicFormModel";
        }
        String entityNumber = designMeta.getNumber();
        ArrayList<String> appNumbers = new ArrayList<String>(10);
        String bizAppId = designMeta.getBizappId();
        if (StringUtils.isNotBlank((CharSequence[])new CharSequence[]{bizAppId})) {
            this.getParentAppNumbers(bizAppId, appNumbers);
        }
        OperationTypes opTypes = OperationTypeLoader.loadAll((String)modelType, appNumbers, (String)entityNumber);
        opTypes.getOpTypes().sort(Comparator.comparingLong(OperationType::getSeq));
        int rowCount = this.getModel().getEntryRowCount("entryentity");
        if (rowCount < opTypes.getOpTypes().size()) {
            this.getModel().batchCreateNewEntryRow("entryentity", opTypes.getOpTypes().size() - rowCount);
        }
        for (int i = 0; i < opTypes.getOpTypes().size(); ++i) {
            OperationType opType = (OperationType)opTypes.getOpTypes().get(i);
            this.getModel().setValue("fid", (Object)opType.getSeq(), i);
            this.getModel().setValue("ftype", (Object)opType.getId(), i);
            this.getModel().setValue("fname", (Object)opType.getName().toString(), i);
            this.getModel().setValue("fcode", (Object)(opType.getDesc() == null ? opType.getName().toString() : opType.getDesc().toString()), i);
        }
    }

    private void getParentAppNumbers(String bizAppId, List<String> appNumbers) {
        DynamicObject appDynamicObject = BizAppServiceHelp.getParentIdAndNumberByAppId((String)bizAppId);
        if (appDynamicObject != null) {
            String number = appDynamicObject.getString("number");
            if (StringUtils.isNotBlank((CharSequence[])new CharSequence[]{number})) {
                appNumbers.add(number);
            }
            String parentId = appDynamicObject.getString("parentid");
            if (StringUtils.isNotBlank((CharSequence[])new CharSequence[]{parentId})) {
                this.getParentAppNumbers(parentId, appNumbers);
            }
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key.equalsIgnoreCase("btnok")) {
            this.returnDataToParent();
        }
    }

    private void returnDataToParent() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("entryentity");
        int rowKey = grid.getEntryState().getFocusRow();
        IDataModel model = this.getModel();
        if (rowKey >= 0) {
            HashMap op = Maps.newHashMapWithExpectedSize((int)3);
            op.put("FCode", model.getValue("ftype", rowKey));
            op.put("FName", model.getValue("fname", rowKey));
            op.put("FType", model.getValue("ftype", rowKey));
            IFormView parentFormView = this.getView().getParentView();
            String operateName = (String)op.get("FCode");
            if (operateName != null) {
                parentFormView.setVisible(Boolean.valueOf(OperationTypeCache.isEntityOperation((String)operateName)), this.entityOpParams);
            }
            this.getView().returnDataToParent((Object)op);
            this.getView().close();
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u64cd\u4f5c", (String)"OperationTypeSelectPlugin_0", (String)"bos-designer-plugin", (Object[])new Object[0]));
        }
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        this.returnDataToParent();
        this.getView().close();
    }
}

