/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.formplugin.web.intgovern.form;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrdbs.common.pojo.OperationResultInfo;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.JsonUtils;
import kd.hdtc.hrdbs.common.util.OperationResultUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.formplugin.web.HDTCDataBaseEdit;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.intgovern.IIntRelationDomainService;
import kd.hdtc.hrdi.business.domain.intgovern.IIntSourceDomainService;
import kd.hdtc.hrdi.business.domain.intgovern.IIntSourceSysDomainService;
import kd.hdtc.hrdi.business.domain.intgovern.IntegratedConfDomainService;
import kd.hdtc.hrdi.common.exception.HRDIBizException;
import kd.hdtc.hrdi.common.intgovern.constants.IntRelationConstants;
import kd.hdtc.hrdi.common.pojo.GuideAddRelationField;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class IntRelationBatchAddFormPlugin
extends HDTCDataBaseEdit
implements BeforeF7SelectListener {
    private static final Log LOG = LogFactory.getLog(IntRelationBatchAddFormPlugin.class);
    private final IIntSourceDomainService iIntSourceDomainService = (IIntSourceDomainService)ServiceFactory.getService(IIntSourceDomainService.class);
    private final IIntSourceSysDomainService iIntSourceSysDomainService = (IIntSourceSysDomainService)ServiceFactory.getService(IIntSourceSysDomainService.class);
    private final IntegratedConfDomainService integratedConfDomainService = (IntegratedConfDomainService)ServiceFactory.getService(IntegratedConfDomainService.class);
    private final IIntRelationDomainService iIntRelationDomainService = (IIntRelationDomainService)ServiceFactory.getService(IIntRelationDomainService.class);
    private final String relationSaveErrorMsg = ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u5b9e\u4f53\u201c%1$s\u201d\u7684\u5b9e\u65f6\u96c6\u6210\u914d\u7f6e\uff0c\u5426\u5219\u65e0\u6cd5\u8fdb\u884c\u5411\u5916\u96c6\u6210\u3002", (String)"IntRelationBatchAddFormPlugin_1", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]);
    private final String relationSaveTipMsg = ResManager.loadKDString((String)"\u5b58\u5728\u8b66\u544a\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u6267\u884c\uff1f", (String)"IntRelationBatchAddFormPlugin_2", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]);

    public void registerListener(EventObject eventObject) {
        BasedataEdit outInteSource;
        BasedataEdit inInteSource;
        BasedataEdit outIntScm;
        super.registerListener(eventObject);
        BasedataEdit inIntScm = (BasedataEdit)this.getView().getControl("in_intscm");
        if (inIntScm != null) {
            inIntScm.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((outIntScm = (BasedataEdit)this.getView().getControl("out_intscm")) != null) {
            outIntScm.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((inInteSource = (BasedataEdit)this.getView().getControl("in_intsource")) != null) {
            inInteSource.setF7BatchFill(false);
        }
        if ((outInteSource = (BasedataEdit)this.getView().getControl("out_intsource")) != null) {
            outInteSource.setF7BatchFill(false);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if ("batch_add".equals(afterDoOperationEventArgs.getOperateKey()) && afterDoOperationEventArgs.getOperationResult() != null) {
            String message = afterDoOperationEventArgs.getOperationResult().getMessage();
            if (StringUtils.isNotEmpty((String)message)) {
                OperationResultInfo operationResultInfo = OperationResultUtils.getOperationResultInfo((String)message);
                if (operationResultInfo != null) {
                    String title = ResManager.loadKDString((String)"\u6279\u91cf\u65b0\u589e\u5931\u8d25", (String)"IntRelationBatchAddFormPlugin_0", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]);
                    FormShowParameter resultPageParameter = OperationResultUtils.getShowOperationResultPageParameter((String)title, (List)operationResultInfo.getErrorMsgList());
                    this.getView().showForm(resultPageParameter);
                }
            } else {
                this.getView().close();
            }
        } else {
            this.addSourceSysToEntry();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"batch_add")) {
            boolean sign;
            if (this.getView().getPageCache().get("intsource") != null) {
                this.getView().getPageCache().remove("intsource");
                return;
            }
            GuideAddRelationField guideAddRelationField = this.getGuideAddRelationField();
            if (null == guideAddRelationField) {
                args.setCancel(true);
                return;
            }
            if (guideAddRelationField.getIsIn().booleanValue()) {
                DynamicObjectCollection inEntryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("in_entryentity");
                sign = this.checkIntMode(inEntryEntity, "in_intsource");
            } else {
                DynamicObjectCollection outEntryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("out_entryentity");
                sign = this.checkIntMode(outEntryEntity, "out_intsource");
            }
            if (sign) {
                args.setCancel(true);
            }
        }
    }

    private boolean checkIntMode(DynamicObjectCollection entry, String source) {
        boolean sign = false;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < entry.size(); ++i) {
            DynamicObject dyn = (DynamicObject)entry.get(i);
            DynamicObject intSource = dyn.getDynamicObject(source);
            Object entityId = intSource.getDynamicObject("entityobj").getPkValue();
            String entityName = intSource.getDynamicObject("entityobj").getString("name");
            DynamicObject intConfDyn = this.integratedConfDomainService.queryConf(entityId);
            String intDirection = dyn.getString(this.getPrefix() + "intdirection");
            String intMode = dyn.getString(this.getPrefix() + "intmode");
            if (!"2".equals(intMode) || !"2".equals(intDirection) || !HRObjectUtils.isEmpty((Object)intConfDyn)) continue;
            sb.append((Object)entityName);
            if (i < entry.size() - 1) {
                sb.append(",");
            }
            sign = true;
        }
        if (sign) {
            this.getView().showConfirm(this.relationSaveTipMsg, String.format(Locale.ROOT, this.relationSaveErrorMsg, sb.toString()), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("intsource", (IFormPlugin)this));
            return true;
        }
        return false;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (HRStringUtils.equals((String)messageBoxClosedEvent.getCallBackId(), (String)"intsource") && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.getView().getPageCache().put("intsource", "true");
            this.getView().invokeOperation("batch_add");
        }
    }

    private void addSourceSysToEntry() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        GuideAddRelationField guideAddRelationField = this.getGuideAddRelationField();
        ImmutableList.of((Object)"in_", (Object)"out_").forEach(prefix -> {
            DynamicObjectCollection inEntryEntity = dataEntity.getDynamicObjectCollection(prefix + "entryentity");
            inEntryEntity.stream().forEach(it -> it.set(prefix + "sourcesys" + "_id", (Object)this.getSourceSysId(guideAddRelationField)));
        });
    }

    private Long getSourceSysId(GuideAddRelationField guideAddRelationField) {
        return guideAddRelationField.getIsIn() != false ? guideAddRelationField.getInSourceSysId() : guideAddRelationField.getOutSourceSysId();
    }

    private String getPrefix() {
        return this.isIn() ? "in_" : "out_";
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        String prefix = this.getPrefix();
        int row = beforeF7SelectEvent.getRow();
        DynamicObjectCollection entryCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection(prefix + "entryentity");
        if (!CollectionUtils.isEmpty((Collection)entryCollection)) {
            DynamicObject entry = (DynamicObject)entryCollection.get(row);
            if (StringUtils.equals((String)fieldKey, (String)(prefix + "intscm"))) {
                String intMode = entry.getString(prefix + "intmode");
                ArrayList initModeList = Lists.newArrayListWithCapacity((int)16);
                String intType = entry.getString(prefix + "inttype");
                if (intType.equals("isc_data_copy_trigger") || intType.equals("isc_service_flow")) {
                    List<Object> intScmIdList;
                    QFilter initModeFilter;
                    if (intType.equals("isc_data_copy_trigger")) {
                        initModeList.add("auto");
                        if (!"1".equals(intMode)) {
                            initModeList.add("manual");
                        }
                        initModeFilter = new QFilter("trigger_type", "in", (Object)initModeList);
                        intScmIdList = this.getIntScmIdList(prefix, entryCollection, "isc_data_copy_trigger");
                    } else {
                        initModeList.add("TIMER");
                        if (!"1".equals(intMode)) {
                            initModeList.add("MANUAL");
                        }
                        initModeFilter = new QFilter("init_mode", "in", (Object)initModeList);
                        intScmIdList = this.getIntScmIdList(prefix, entryCollection, "isc_service_flow");
                    }
                    DynamicObject intScm = ((DynamicObject)entryCollection.get(row)).getDynamicObject(prefix + "intscm");
                    if (intScm != null) {
                        intScmIdList.remove(intScm.get("id"));
                    }
                    QFilter intScmFilter = new QFilter("id", "not in", intScmIdList);
                    beforeF7SelectEvent.addCustomQFilter(intScmFilter);
                    beforeF7SelectEvent.addCustomQFilter(initModeFilter);
                } else {
                    ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                    listShowParameter.setFormId("hrdi_external_api_f7");
                }
            }
        }
    }

    private List<Object> getIntScmIdList(String prefix, DynamicObjectCollection entryCollection, String intType) {
        List intScmIdList = this.iIntRelationDomainService.queryAllEnableIntScmIdList(null, intType);
        entryCollection.stream().filter(dd -> intType.equals(dd.getString(prefix + "inttype"))).forEach(dx -> {
            DynamicObject intScm = dx.getDynamicObject(prefix + "intscm");
            if (intScm != null) {
                intScmIdList.add(intScm.get("id"));
            }
        });
        return intScmIdList;
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        String prefix;
        String propertyName = propertyChangedArgs.getProperty().getName();
        if (propertyName.equals((prefix = this.getPrefix()) + "intsource")) {
            this.resetNameAndNumber(propertyChangedArgs, this.isIn(), prefix);
        } else if (propertyName.equals(prefix + "intmode")) {
            this.onIntModeChange(propertyChangedArgs);
        } else if (propertyName.equals(prefix + "inttype")) {
            this.onIntTypeChange(propertyChangedArgs);
        }
    }

    private void onIntTypeChange(PropertyChangedArgs propertyChangedArgs) {
        ChangeData changeData = propertyChangedArgs.getChangeSet()[0];
        String newIntType = (String)changeData.getNewValue();
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex(this.getPrefix() + "entryentity");
        this.getView().setEnable(Boolean.valueOf(true), entryCurrentRowIndex, new String[]{this.getPrefix() + "intscm"});
        if ("open_apiservice".equals(newIntType)) {
            this.getView().setEnable(Boolean.valueOf(false), entryCurrentRowIndex, new String[]{this.getPrefix() + "intscm"});
            this.getView().getModel().setValue(this.getPrefix() + "intscm", (Object)IntRelationConstants.BASE_DATA_API_ID);
        }
    }

    private void onIntModeChange(PropertyChangedArgs propertyChangedArgs) {
        ChangeData changeData = propertyChangedArgs.getChangeSet()[0];
        String newIntMode = (String)changeData.getNewValue();
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex(this.getPrefix() + "entryentity");
        if ("2".equals(newIntMode)) {
            this.getModel().setValue(this.getPrefix() + "realintmode", (Object)"1", entryCurrentRowIndex);
        }
    }

    private void resetNameAndNumber(PropertyChangedArgs propertyChangedArgs, boolean inOrOut, String prefix) {
        ChangeData changeData = propertyChangedArgs.getChangeSet()[0];
        DynamicObject entry = changeData.getDataEntity();
        if (entry != null) {
            String currentOldName;
            String oldName;
            DynamicObject oldIntSource = (DynamicObject)changeData.getOldValue();
            DynamicObject sourceSys = entry.getDynamicObject(prefix + "sourcesys");
            String oldNumber = this.iIntSourceDomainService.getIntRelationNumber(inOrOut, oldIntSource, sourceSys);
            String currentOldNumber = entry.getString(prefix + "number");
            DynamicObject newIntSource = (DynamicObject)changeData.getNewValue();
            if (oldNumber.equals(currentOldNumber) || StringUtils.isEmpty((String)oldNumber) || StringUtils.isEmpty((String)currentOldNumber)) {
                String newNumber = this.iIntSourceDomainService.getIntRelationNumber(inOrOut, newIntSource, sourceSys);
                entry.set(prefix + "number", (Object)newNumber);
            }
            if ((oldName = this.iIntSourceDomainService.getIntRelationName(inOrOut, oldIntSource, sourceSys)).equals(currentOldName = entry.getString(prefix + "name")) || StringUtils.isEmpty((String)oldName) || StringUtils.isEmpty((String)currentOldName)) {
                String newName = this.iIntSourceDomainService.getIntRelationName(inOrOut, newIntSource, sourceSys);
                entry.set(prefix + "name", (Object)newName);
            }
            this.getView().updateView(prefix + "entryentity");
        }
    }

    public void beforeBindData(EventObject eventObject) {
        Long sourceSysId;
        String prefix;
        super.beforeBindData(eventObject);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        GuideAddRelationField guideAddRelationField = this.getGuideAddRelationField();
        if (Objects.isNull(guideAddRelationField)) {
            return;
        }
        Map intSourceIdIntSourceMap = this.iIntSourceDomainService.queryByIds(guideAddRelationField.getIntSourceIdList());
        if (guideAddRelationField.getIsIn().booleanValue()) {
            prefix = "in_";
            sourceSysId = guideAddRelationField.getInSourceSysId();
        } else {
            prefix = "out_";
            sourceSysId = guideAddRelationField.getOutSourceSysId();
        }
        DynamicObject sourceSys = this.iIntSourceSysDomainService.queryById(sourceSysId);
        DynamicObjectCollection inEntryEntity = dataEntity.getDynamicObjectCollection(prefix + "entryentity");
        int idx = 0;
        for (Long intSourceId : guideAddRelationField.getIntSourceIdList()) {
            DynamicObject inEntry = inEntryEntity.addNew();
            this.setEntryValue(guideAddRelationField.getIsIn(), prefix, intSourceIdIntSourceMap, sourceSys, intSourceId, inEntry);
            this.getView().setEnable(Boolean.FALSE, idx, new String[]{prefix + "realintmode", this.getPrefix() + "msgpublisher"});
            ++idx;
        }
        this.getModel().setValue("in_or_out", (Object)guideAddRelationField.getIsIn());
        this.getModel().setValue("sourcesys", (Object)sourceSysId);
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
    }

    private GuideAddRelationField getGuideAddRelationField() {
        Object guideAddRelationFieldInfoStr = this.getView().getFormShowParameter().getCustomParam("guideAddRelationFieldInfo");
        if (guideAddRelationFieldInfoStr == null) {
            LOG.error("IntRelationBatchAddFormPlugin.beforeBindData guideAddRelationFieldInfoStr is empty");
            return null;
        }
        try {
            return (GuideAddRelationField)JsonUtils.cast((String)guideAddRelationFieldInfoStr.toString(), GuideAddRelationField.class);
        }
        catch (IOException e) {
            LOG.error("IntRelationBatchAddFormPlugin.beforeBindData JsonUtils.cast error:", (Throwable)e);
            throw new HRDIBizException(e.getMessage());
        }
    }

    public void afterAddRow(AfterAddRowEventArgs afterAddRowEventArgs) {
        String prefix = this.getPrefix();
        DynamicObjectCollection entryCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection(prefix + "entryentity");
        this.getModel().setValue(prefix + "sourcesys", this.getModel().getDataEntity().get("sourcesys"), entryCollection.size() - 1);
    }

    private boolean isIn() {
        return this.getModel().getDataEntity().getBoolean("in_or_out");
    }

    private void setEntryValue(boolean inOrOut, String prefix, Map<Long, DynamicObject> intSourceIdIntSourceMap, DynamicObject sourceSys, Long intSourceId, DynamicObject inEntry) {
        DynamicObject intSource = intSourceIdIntSourceMap.get(intSourceId);
        String number = this.iIntSourceDomainService.getIntRelationNumber(inOrOut, intSource, sourceSys);
        inEntry.set(prefix + "number", (Object)number);
        String name = this.iIntSourceDomainService.getIntRelationName(inOrOut, intSource, sourceSys);
        inEntry.set(prefix + "name", (Object)name);
        if (inOrOut) {
            inEntry.set(prefix + "intdirection", (Object)1);
        } else {
            inEntry.set(prefix + "intdirection", (Object)2);
        }
        inEntry.set(prefix + "intsource", (Object)intSource);
        inEntry.set(prefix + "sourcesys", (Object)sourceSys);
        inEntry.set(prefix + "intmode", (Object)1);
        inEntry.set(prefix + "inttype", (Object)"isc_service_flow");
    }
}

