/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.formplugin.web.intgovern.form;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.formplugin.web.HDTCDataBaseEdit;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.intgovern.IIntEntityCategoryDomainService;
import kd.hdtc.hrdi.business.domain.intgovern.IIntRelationDomainService;
import kd.hdtc.hrdi.business.domain.intgovern.IIntSourceDomainService;
import kd.hdtc.hrdi.business.domain.intgovern.IntegratedConfDomainService;
import kd.hdtc.hrdi.common.enums.BizCategoryEnum;
import kd.hdtc.hrdi.common.intgovern.constants.IntRelationConstants;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class IntRelationEditPlugin
extends HDTCDataBaseEdit
implements BeforeF7SelectListener {
    private final IIntSourceDomainService iIntSourceDomainService = (IIntSourceDomainService)ServiceFactory.getService(IIntSourceDomainService.class);
    private final IIntRelationDomainService iIntRelationDomainService = (IIntRelationDomainService)ServiceFactory.getService(IIntRelationDomainService.class);
    private final IntegratedConfDomainService integratedConfDomainService = (IntegratedConfDomainService)ServiceFactory.getService(IntegratedConfDomainService.class);
    private final IIntEntityCategoryDomainService categoryDomainService = (IIntEntityCategoryDomainService)ServiceFactory.getService(IIntEntityCategoryDomainService.class);
    private final String relationSaveErrorMsg = ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u5b9e\u4f53\u201c%1$s\u201d\u7684\u5b9e\u65f6\u96c6\u6210\u914d\u7f6e\uff0c\u5426\u5219\u65e0\u6cd5\u8fdb\u884c\u5411\u5916\u96c6\u6210\u3002", (String)"IntRelationEditPlugin_0", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]);
    private final String relationSaveTipMsg = ResManager.loadKDString((String)"\u5b58\u5728\u8b66\u544a\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u6267\u884c\uff1f", (String)"IntRelationEditPlugin_1", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]);
    private final String sourceSys = ResManager.loadKDString((String)"\u6765\u6e90\u7cfb\u7edf", (String)"IntRelationEditPlugin_2", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]);
    private final String targetSys = ResManager.loadKDString((String)"\u76ee\u6807\u7cfb\u7edf", (String)"IntRelationEditPlugin_3", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]);
    private static final String ENTITY_CATEGORY = "entity_catetory";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BasedataEdit fieldEdit = (BasedataEdit)this.getView().getControl("intscm");
        fieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        String indMode = this.getModel().getDataEntity().getString("intmode");
        String intDirection = this.getModel().getDataEntity().getString("intdirection");
        String dbIntType = this.getModel().getDataEntity().getString("inttype");
        this.getPageCache().put("inttype", dbIntType);
        this.setIntTypeItemList(intDirection, indMode);
        this.setSourceSysCaption(intDirection);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"save")) {
            if (this.getView().getPageCache().get("intsource") != null) {
                this.getView().getPageCache().remove("intsource");
                return;
            }
            DynamicObject intSource = (DynamicObject)this.getModel().getValue("intsource");
            Object entityId = intSource.getDynamicObject("entityobj").getPkValue();
            String entityName = intSource.getDynamicObject("entityobj").getString("name");
            DynamicObject intConfDyn = this.integratedConfDomainService.queryConf(entityId);
            String intDirection = this.getModel().getDataEntity().getString("intdirection");
            String intMode = this.getModel().getDataEntity().getString("intmode");
            if ("2".equals(intMode) && "2".equals(intDirection) && HRObjectUtils.isEmpty((Object)intConfDyn)) {
                this.getView().showConfirm(this.relationSaveTipMsg, String.format(Locale.ROOT, this.relationSaveErrorMsg, entityName), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("intsource", (IFormPlugin)this));
                args.setCancel(true);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (HRStringUtils.equals((String)messageBoxClosedEvent.getCallBackId(), (String)"intsource") && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.getView().getPageCache().put("intsource", "true");
            this.getView().invokeOperation("save");
        }
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        String propertyName;
        switch (propertyName = propertyChangedArgs.getProperty().getName()) {
            case "intsource": {
                this.onIntSourceChange(propertyChangedArgs);
                break;
            }
            case "sourcesys": {
                this.onSourceSysChange(propertyChangedArgs);
                break;
            }
            case "intdirection": {
                this.onIntDirectionChange(propertyChangedArgs);
                break;
            }
            case "intmode": {
                this.onIntModeChange(propertyChangedArgs);
                break;
            }
            case "inttype": {
                this.onIntTypeChange(propertyChangedArgs);
                break;
            }
        }
    }

    private void onIntTypeChange(PropertyChangedArgs propertyChangedArgs) {
        ChangeData changeData = propertyChangedArgs.getChangeSet()[0];
        String newIntType = (String)changeData.getNewValue();
        if ("open_apiservice".equals(newIntType)) {
            this.getView().getModel().setValue("intscm", (Object)IntRelationConstants.BASE_DATA_API_ID);
        }
    }

    private void onIntModeChange(PropertyChangedArgs propertyChangedArgs) {
        ChangeData changeData = propertyChangedArgs.getChangeSet()[0];
        String newIntMode = (String)changeData.getNewValue();
        String intDirection = this.getModel().getDataEntity().getString("intdirection");
        if ("1".equals(newIntMode)) {
            this.getModel().setValue("realintmode", null);
            this.getModel().setValue("msgpublisher", null);
        } else {
            this.getModel().setValue("realintmode", (Object)"1");
        }
        this.getModel().setValue("intscm", null);
        this.getView().updateView("intscm");
        this.setIntTypeItemList(intDirection, newIntMode);
        this.setIntTypeAndScm(intDirection, newIntMode);
    }

    private void setIntTypeItemList(String intDirection, String intMode) {
        ComboEdit comboEdit = (ComboEdit)this.getControl("inttype");
        List comboItemList = ((ItemClassTypeProp)comboEdit.getProperty()).getComboItems();
        HashSet<String> excloudValueSet = new HashSet<String>(16);
        String dbIntType = this.getPageCache().get("inttype");
        if (!"isc_apic_for_external_api".equals(dbIntType)) {
            excloudValueSet.add("isc_apic_for_external_api");
        }
        if ("2".equals(intMode) && "2".equals(intDirection)) {
            excloudValueSet.add("isc_data_copy_trigger");
            if (!BizCategoryEnum.BASE_DATA.getCode().equals(this.getCategory())) {
                excloudValueSet.add("open_apiservice");
            }
        } else {
            excloudValueSet.add("open_apiservice");
        }
        List<ComboItem> itemList = this.getComboItems(comboItemList, excloudValueSet);
        comboEdit.setComboItems(itemList);
    }

    private void setIntTypeAndScm(String intDirection, String intMode) {
        String defaultValue = null;
        if ("2".equals(intMode) && "2".equals(intDirection)) {
            defaultValue = !BizCategoryEnum.BASE_DATA.getCode().equals(this.getCategory()) ? "isc_service_flow" : "open_apiservice";
        }
        if (StringUtils.isNotEmpty(defaultValue)) {
            this.getView().getModel().setValue("inttype", defaultValue);
        }
        if ("open_apiservice".equals(defaultValue)) {
            this.getView().getModel().setValue("intscm", (Object)IntRelationConstants.BASE_DATA_API_ID);
        }
    }

    private String getCategory() {
        String category = this.getPageCache().get(ENTITY_CATEGORY);
        if (StringUtils.isNotEmpty((String)category)) {
            return category;
        }
        DynamicObject intSource = this.getModel().getDataEntity().getDynamicObject("intsource");
        if (intSource == null) {
            return null;
        }
        String bizEntity = intSource.getString("entityobj.id");
        BizCategoryEnum categoryEnum = this.categoryDomainService.getCategoryByEntityNumber(bizEntity);
        this.getPageCache().put(ENTITY_CATEGORY, categoryEnum.getCode());
        return categoryEnum.getCode();
    }

    private void clearCategoryCache() {
        this.getPageCache().put(ENTITY_CATEGORY, null);
    }

    private List<ComboItem> getComboItems(List<ValueMapItem> comboItemList, Set<String> excloudValueSet) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(10);
        comboItemList.forEach(dy -> {
            if (!excloudValueSet.contains(dy.getValue())) {
                ComboItem comboItem = new ComboItem();
                comboItem.setCaption(dy.getName());
                comboItem.setValue(dy.getValue());
                items.add(comboItem);
            }
        });
        return items;
    }

    private void onIntDirectionChange(PropertyChangedArgs propertyChangedArgs) {
        ChangeData changeData = propertyChangedArgs.getChangeSet()[0];
        String oldIntDirection = (String)changeData.getOldValue();
        String newIntDirection = (String)changeData.getNewValue();
        this.setSourceSysCaption(newIntDirection);
        this.getView().updateView("sourcesys");
        this.setIntMode(newIntDirection);
        boolean oldIisIn = "1".equals(oldIntDirection);
        boolean newIisIn = "1".equals(newIntDirection);
        String newIntMode = this.getModel().getDataEntity().getString("intmode");
        DynamicObject sourceSys = this.getModel().getDataEntity().getDynamicObject("sourcesys");
        DynamicObject intSourceDyn = this.getModel().getDataEntity().getDynamicObject("intsource");
        this.resetNumberOnIntSourceChange(oldIisIn, newIisIn, intSourceDyn, sourceSys);
        this.resetNameOnIntSourceChange(oldIisIn, newIisIn, intSourceDyn, sourceSys);
        this.setIntTypeItemList(newIntDirection, newIntMode);
        this.setIntTypeAndScm(newIntDirection, newIntMode);
        this.getModel().setValue("inttype", null);
        this.getModel().setValue("intscm", null);
    }

    private void setSourceSysCaption(String intDirection) {
        String caption = this.sourceSys;
        if ("2".equals(intDirection)) {
            caption = this.targetSys;
        }
        BasedataEdit edit = (BasedataEdit)this.getView().getControl("sourcesys");
        edit.setCaption(new LocaleString(caption));
    }

    private void setIntMode(String intDirection) {
        if ("1".equals(intDirection)) {
            this.getView().getModel().setValue("intmode", (Object)"1");
        }
    }

    private void onIntSourceChange(PropertyChangedArgs propertyChangedArgs) {
        ChangeData changeData = propertyChangedArgs.getChangeSet()[0];
        DynamicObject oldIntSource = (DynamicObject)changeData.getOldValue();
        DynamicObject newIntSource = (DynamicObject)changeData.getNewValue();
        String intDirection = this.getModel().getDataEntity().getString("intdirection");
        String intMode = this.getModel().getDataEntity().getString("intmode");
        DynamicObject sourceSys = this.getModel().getDataEntity().getDynamicObject("sourcesys");
        boolean isIn = "1".equals(intDirection);
        this.resetNumberOnIntSourceChange(isIn, oldIntSource, newIntSource, sourceSys);
        this.resetNameOnIntSourceChange(isIn, oldIntSource, newIntSource, sourceSys);
        this.clearCategoryCache();
        this.setIntTypeItemList(intDirection, intMode);
        this.setIntTypeAndScm(intDirection, intMode);
    }

    private void resetNumberOnIntSourceChange(boolean isIn, DynamicObject oldIntSource, DynamicObject newIntSource, DynamicObject sourceSys) {
        String oldNumber = this.iIntSourceDomainService.getIntRelationNumber(isIn, oldIntSource, sourceSys);
        String currentOldNumber = this.getModel().getDataEntity().getString("number");
        if (StringUtils.isEmpty((String)oldNumber) || oldNumber.equals(currentOldNumber)) {
            String newNumber = this.iIntSourceDomainService.getIntRelationNumber(isIn, newIntSource, sourceSys);
            this.getModel().setValue("number", (Object)newNumber);
        }
    }

    private void resetNumberOnIntSourceChange(boolean oldIsIn, boolean newIsIn, DynamicObject intSource, DynamicObject sourceSys) {
        String currentOldNumber;
        String oldNumber = this.iIntSourceDomainService.getIntRelationNumber(oldIsIn, intSource, sourceSys);
        if (oldNumber.equals(currentOldNumber = this.getModel().getDataEntity().getString("number"))) {
            String newNumber = this.iIntSourceDomainService.getIntRelationNumber(newIsIn, intSource, sourceSys);
            this.getModel().setValue("number", (Object)newNumber);
        }
    }

    private void resetNameOnIntSourceChange(boolean oldIsIn, boolean newIsIn, DynamicObject intSource, DynamicObject sourceSys) {
        String currentOldName;
        String oldName = this.iIntSourceDomainService.getIntRelationName(oldIsIn, intSource, sourceSys);
        if (oldName.equals(currentOldName = this.getModel().getDataEntity(true).getString("name"))) {
            String newName = this.iIntSourceDomainService.getIntRelationName(newIsIn, intSource, sourceSys);
            this.getModel().setValue("name", (Object)newName);
        }
    }

    private void resetNameOnIntSourceChange(boolean isIn, DynamicObject oldIntSource, DynamicObject newIntSource, DynamicObject sourceSys) {
        String oldName = this.iIntSourceDomainService.getIntRelationName(isIn, oldIntSource, sourceSys);
        String currentOldName = this.getModel().getDataEntity(true).getString("name");
        if (StringUtils.isEmpty((String)oldName) || oldName.equals(currentOldName)) {
            String newName = this.iIntSourceDomainService.getIntRelationName(isIn, newIntSource, sourceSys);
            this.getModel().setValue("name", (Object)newName);
        }
    }

    private void onSourceSysChange(PropertyChangedArgs propertyChangedArgs) {
        ChangeData changeData = propertyChangedArgs.getChangeSet()[0];
        DynamicObject oldSourceSys = (DynamicObject)changeData.getOldValue();
        DynamicObject newSourceSys = (DynamicObject)changeData.getNewValue();
        String intDirection = this.getModel().getDataEntity(true).getString("intdirection");
        DynamicObject intSource = this.getModel().getDataEntity(true).getDynamicObject("intsource");
        boolean isIn = "1".equals(intDirection);
        this.resetNumberOnSourceSysChange(isIn, intSource, oldSourceSys, newSourceSys);
        this.resetNameOnSourceSysChange(isIn, intSource, oldSourceSys, newSourceSys);
    }

    private void resetNumberOnSourceSysChange(boolean isIn, DynamicObject intSource, DynamicObject oldSourceSys, DynamicObject newSourceSys) {
        String oldNumber = this.iIntSourceDomainService.getIntRelationNumber(isIn, intSource, oldSourceSys);
        String currentOldNumber = this.getModel().getDataEntity(true).getString("number");
        if (StringUtils.isEmpty((String)currentOldNumber) || oldNumber.equals(currentOldNumber)) {
            String newNumber = this.iIntSourceDomainService.getIntRelationNumber(isIn, intSource, newSourceSys);
            this.getModel().setValue("number", (Object)newNumber);
        }
    }

    private void resetNameOnSourceSysChange(boolean isIn, DynamicObject intSource, DynamicObject oldSourceSys, DynamicObject newSourceSys) {
        String oldName = this.iIntSourceDomainService.getIntRelationName(isIn, intSource, oldSourceSys);
        String currentOldName = this.getModel().getDataEntity(true).getString("name");
        if (StringUtils.isEmpty((String)currentOldName) || oldName.equals(currentOldName)) {
            String newName = this.iIntSourceDomainService.getIntRelationName(isIn, intSource, newSourceSys);
            this.getModel().setValue("name", (Object)newName);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        if (StringUtils.equals((String)fieldKey, (String)"intscm")) {
            String intMode = this.getModel().getDataEntity().getString("intmode");
            ArrayList initModeList = Lists.newArrayListWithCapacity((int)16);
            String intType = this.getModel().getDataEntity().getString("inttype");
            QFilter intModeFilter = null;
            List intScmIdList = new ArrayList(16);
            if (intType.equals("isc_data_copy_trigger")) {
                initModeList.add("auto");
                if (!"1".equals(intMode)) {
                    initModeList.add("manual");
                }
                intModeFilter = new QFilter("trigger_type", "in", (Object)initModeList);
                intScmIdList = this.iIntRelationDomainService.queryAllEnableIntScmIdList(null, "isc_data_copy_trigger");
            } else if (intType.equals("isc_service_flow")) {
                initModeList.add("TIMER");
                if (!"1".equals(intMode)) {
                    initModeList.add("MANUAL");
                }
                intModeFilter = new QFilter("init_mode", "in", (Object)initModeList);
                intScmIdList = this.iIntRelationDomainService.queryAllEnableIntScmIdList(null, "isc_service_flow");
            } else {
                ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                listShowParameter.setFormId("hrdi_external_api_f7");
            }
            DynamicObject intScm = this.getModel().getDataEntity().getDynamicObject("intscm");
            if (intScm != null) {
                intScmIdList.remove(intScm.get("id"));
            }
            QFilter intScmFilter = new QFilter("id", "not in", intScmIdList);
            beforeF7SelectEvent.addCustomQFilter(intScmFilter);
            beforeF7SelectEvent.addCustomQFilter(intModeFilter);
        }
    }
}

