/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.formplugin.web.intgovern.form;

import java.util.Collections;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.DefaultEntityOperate;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrdbs.common.constants.QFilterConstants;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.middle.entity.IMidTableConfigEntityService;
import kd.hdtc.hrdi.formplugin.web.common.form.AbstractBaseDataEditPlugin;
import kd.hr.hbp.common.util.HRStringUtils;

public class IntSourceEditPlugin
extends AbstractBaseDataEditPlugin
implements BeforeF7SelectListener {
    private final IMidTableConfigEntityService iMidTableConfigEntityService = (IMidTableConfigEntityService)ServiceFactory.getService(IMidTableConfigEntityService.class);

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BasedataEdit fieldEdit = (BasedataEdit)this.getView().getControl("midtableconfig");
        fieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit entityObjEdit = (BasedataEdit)this.getControl("entityobj");
        entityObjEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String entityObjId;
        super.beforeF7Select(beforeF7SelectEvent);
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        if (StringUtils.equals((String)fieldKey, (String)"midtableconfig") && StringUtils.isNotEmpty((String)(entityObjId = this.getModel().getDataEntity(true).getString("entityobj.id")))) {
            QFilter entityObjIdFilter = new QFilter("entityobj.id", "in", (Object)entityObjId);
            beforeF7SelectEvent.addCustomQFilter(entityObjIdFilter);
        }
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        String propertyName;
        switch (propertyName = propertyChangedArgs.getProperty().getName()) {
            case "midtableconfig": {
                this.onMidTableConfigChange(propertyChangedArgs);
                break;
            }
            case "entityobj": {
                this.onEntityObjChange(propertyChangedArgs);
                break;
            }
        }
    }

    private void onMidTableConfigChange(PropertyChangedArgs propertyChangedArgs) {
        DynamicObject midTableConfig = (DynamicObject)propertyChangedArgs.getChangeSet()[0].getNewValue();
        if (midTableConfig != null) {
            String name;
            String number = this.getModel().getDataEntity().getString("number");
            if (HRStringUtils.isEmpty((String)number)) {
                String midConfigNumber = midTableConfig.getString("number");
                this.getModel().setValue("number", (Object)midConfigNumber);
            }
            if (HRStringUtils.isEmpty((String)(name = this.getModel().getDataEntity().getString("name")))) {
                String midConfigName = midTableConfig.getString("name");
                this.getModel().setValue("name", (Object)midConfigName);
            }
            DynamicObject entityObj = midTableConfig.getDynamicObject("entityobj");
            this.getModel().setValue("entityobj", (Object)entityObj);
        }
    }

    private void onEntityObjChange(PropertyChangedArgs propertyChangedArgs) {
        DynamicObject entityObj = (DynamicObject)propertyChangedArgs.getChangeSet()[0].getNewValue();
        String number = this.getModel().getDataEntity().getString("number");
        String name = this.getModel().getDataEntity().getString("name");
        if (entityObj != null) {
            String queryFields = String.join((CharSequence)",", "id", "number", "name", "entityobj", "midentitynumber");
            QFilter entityFilter = new QFilter("entityobj", "in", Collections.singleton(entityObj.getString("id")));
            DynamicObject midTableDyn = this.iMidTableConfigEntityService.queryOne(queryFields, new QFilter[]{QFilterConstants.Q_ENABLE, entityFilter});
            this.getModel().setValue("midtableconfig", (Object)midTableDyn);
            if (HRStringUtils.isEmpty((String)number)) {
                if (midTableDyn != null) {
                    this.getModel().setValue("number", (Object)midTableDyn.getString("number"));
                } else {
                    this.getModel().setValue("number", (Object)entityObj.getString("number"));
                }
            }
            if (HRStringUtils.isEmpty((String)name)) {
                if (midTableDyn != null) {
                    this.getModel().setValue("name", (Object)midTableDyn.getString("name"));
                } else {
                    this.getModel().setValue("name", (Object)entityObj.getString("name"));
                }
            }
            this.getView().updateView();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs beforeDoOperationEventArgs) {
        DynamicObject entityObj;
        super.beforeDoOperation(beforeDoOperationEventArgs);
        if ("save".equals(((DefaultEntityOperate)beforeDoOperationEventArgs.getSource()).getOperateKey()) && (entityObj = this.getModel().getDataEntity().getDynamicObject("entityobj")) != null) {
            this.getModel().setValue("bizapp", (Object)entityObj.getDynamicObject("bizappid"));
        }
    }
}

