/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.formplugin.web.intgovern.form;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.hdtc.hrdbs.common.util.ConvertUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdi.common.intgovern.constants.IntegratedConfConstants;
import kd.hdtc.hrdi.formplugin.web.common.form.AbstractBaseDataEditPlugin;
import kd.hr.hbp.common.util.HRStringUtils;

public class IntegratedConfEditPlugin
extends AbstractBaseDataEditPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        TextEdit textEdit = (TextEdit)this.getView().getControl("bizop");
        textEdit.addButtonClickListener((ClickListener)this);
        BasedataEdit entityEdit = (BasedataEdit)this.getView().getControl("entityobj");
        entityEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        if (StringUtils.equals((String)fieldKey, (String)"entityobj")) {
            FormShowParameter formShowParameter = beforeF7SelectEvent.getFormShowParameter();
            String title = ResManager.loadKDString((String)"\u5b9e\u4f53\u5bf9\u8c61", (String)"IntegratedConfEditPlugin_2", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]);
            formShowParameter.setCaption(title);
        }
    }

    private void entityTypeHandle() {
        if (OperationStatus.VIEW.getValue() == this.getView().getFormShowParameter().getStatus().getValue()) {
            return;
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl("entitytype");
        List valueMapItemList = ((ComboProp)comboEdit.getProperty()).getComboItems();
        ArrayList<ComboItem> itemList = new ArrayList<ComboItem>(10);
        for (ValueMapItem valueMapItem : valueMapItemList) {
            if (StringUtils.equals((String)"1", (String)valueMapItem.getValue())) continue;
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(valueMapItem.getName());
            comboItem.setValue(valueMapItem.getValue());
            itemList.add(comboItem);
        }
        comboEdit.setComboItems(itemList);
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.entityTypeHandle();
        String entityType = ConvertUtils.toString((Object)this.getModel().getValue("entitytype"));
        if (HRStringUtils.equals((String)entityType, (String)"1") || HRStringUtils.equals((String)entityType, (String)"2")) {
            ((FieldEdit)this.getView().getControl("bizop")).setMustInput(false);
            ((FieldEdit)this.getView().getControl("bizmessage")).setMustInput(true);
        } else {
            ((FieldEdit)this.getView().getControl("bizmessage")).setMustInput(false);
            ((FieldEdit)this.getView().getControl("bizop")).setMustInput(true);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("bizop".equalsIgnoreCase(key) && this.checkEmpty()) {
            this.selectOperate();
        }
    }

    private boolean checkEmpty() {
        if (this.getModel().getValue("entityobj") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b9e\u4f53\u5bf9\u8c61\u3002", (String)"IntegratedConfEditPlugin_0", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void selectOperate() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("hrdi_bizoplist");
        formShowParameter.setCustomParam("entityid", (Object)this.getModel().getDataEntity().getString("entityobj.id"));
        formShowParameter.setCustomParam("bizop", this.getModel().getValue("bizop"));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bizop"));
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        super.closedCallBack(evt);
        if (evt.getReturnData() != null && "bizop".equalsIgnoreCase(actionId = evt.getActionId())) {
            ArrayList returnData = (ArrayList)evt.getReturnData();
            this.getModel().setValue("bizop", (Object)String.join((CharSequence)",", returnData));
        }
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        String propertyName = propertyChangedArgs.getProperty().getName();
        if (HRStringUtils.equals((String)propertyName, (String)"entityobj")) {
            DynamicObject entityObject = (DynamicObject)this.getModel().getValue("entityobj");
            if (null == entityObject) {
                this.getModel().setValue("number", null);
                this.getModel().setValue("name", null);
            } else {
                this.getModel().setValue("number", (Object)entityObject.getString("number"));
                this.getModel().setValue("name", (Object)entityObject.getString("name"));
            }
        } else if (HRStringUtils.equals((String)propertyName, (String)"inttype")) {
            String integratedType = ConvertUtils.toString((Object)this.getModel().getValue("inttype"));
            if (HRStringUtils.equals((String)integratedType, (String)"1")) {
                ((TextEdit)this.getView().getControl("bizop")).setMustInput(false);
                ((MulBasedataEdit)this.getView().getControl("bizmessage")).setMustInput(true);
                this.getModel().setValue("bizop", null);
            } else {
                ((MulBasedataEdit)this.getView().getControl("bizmessage")).setMustInput(false);
                ((TextEdit)this.getView().getControl("bizop")).setMustInput(true);
                this.getModel().setValue("bizmessage", null);
            }
        } else if (HRStringUtils.equals((String)propertyName, (String)"entitytype")) {
            this.doEntityTypeChange();
        }
    }

    private void doEntityTypeChange() {
        String entityType = ConvertUtils.toString((Object)this.getModel().getValue("entitytype"));
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"bizmessage"});
        this.getModel().setValue("bizmessage", null);
        String intType = "1";
        switch (entityType) {
            case "1": {
                break;
            }
            case "2": {
                this.getModel().setValue("bizmessage", (Object)IntegratedConfConstants.PERSON_MSG_PUBLISH_SET.toArray());
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"bizmessage"});
                break;
            }
            case "3": {
                intType = "2";
                break;
            }
        }
        this.getModel().setValue("inttype", (Object)intType);
    }
}

