/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.formplugin.web.intgovern.form;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.inte.api.EnabledLang;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.ConvertUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.formplugin.web.HDTCDataBaseEdit;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.intgovern.IWhiteListOfOpDomainService;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class IntegratedOperationListEditPlugin
extends HDTCDataBaseEdit
implements RowClickEventListener {
    private final IWhiteListOfOpDomainService IWhiteListOfOpDomainService = (IWhiteListOfOpDomainService)ServiceFactory.getService(IWhiteListOfOpDomainService.class);
    private static final List<String> DO_NOTHING_LIST = Arrays.asList("assign_new", "bdctrlchange", "confirmchange", "confirmchangenoaudit", "his_delete", "his_disable", "individuation", "namehistory", "namehistoryview", "orgpermchange", "tbl_assign_import");
    private final List<Integer> selectRowList = new ArrayList<Integer>(16);

    public void initialize() {
        Button btn = (Button)this.getView().getControl("btnok");
        btn.addClickListener((ClickListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject eventObject) {
        String entityId = (String)this.getView().getFormShowParameter().getCustomParams().get("entityid");
        List dataEntityOperateList = EntityMetadataCache.getDataEntityOperate((String)entityId);
        if (dataEntityOperateList.size() > 0) {
            EnabledLang userLang = InteServiceHelper.getUserLang((Long)RequestContext.get().getCurrUserId());
            Object[] allWhiteListOp = this.IWhiteListOfOpDomainService.getAllWhiteListOp();
            if (HRArrayUtils.isEmpty((Object[])allWhiteListOp)) {
                return;
            }
            Set numberSet = Arrays.stream(allWhiteListOp).map(it -> it.getString("optype")).collect(Collectors.toSet());
            IDataModel model = this.getModel();
            List opList = dataEntityOperateList.stream().filter(it -> numberSet.contains((String)it.get("type"))).collect(Collectors.toList());
            int[] rowKeys = model.batchCreateNewEntryRow("entryentity", opList.size());
            int index = 0;
            Set<String> selectOpSet = this.getSelectOp();
            for (Map op : opList) {
                String opKey = (String)op.get("key");
                if (selectOpSet.contains(opKey)) {
                    this.selectRowList.add(index);
                }
                model.setValue("ftype", op.get("type"), rowKeys[index]);
                model.setValue("fcode", op.get("key"), rowKeys[index]);
                model.setValue("fname", (Object)this.getLocalString((Map)op.get("name"), userLang), rowKeys[index++]);
            }
        }
        this.getView().updateView("entryentity");
    }

    private String getLocalString(Map<String, String> multiLanMap, EnabledLang userLang) {
        String localStr = multiLanMap.get(userLang.getNumber());
        if (StringUtils.isEmpty((String)localStr)) {
            localStr = multiLanMap.get("AF");
        }
        return localStr;
    }

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        int[] selectRows = new int[this.selectRowList.size()];
        int index = 0;
        for (int row : this.selectRowList) {
            selectRows[index++] = row;
        }
        grid.selectRows(selectRows, 0);
    }

    private Set<String> getSelectOp() {
        HashSet<String> selectOpSet = new HashSet<String>(16);
        String bizSelectOp = (String)this.getView().getFormShowParameter().getCustomParams().get("bizop");
        if (StringUtils.isNotEmpty((String)bizSelectOp)) {
            String[] selectOps;
            for (String selectOp : selectOps = bizSelectOp.split(",")) {
                if (selectOp.lastIndexOf("!") < 0) continue;
                selectOpSet.add(selectOp.substring(0, selectOp.lastIndexOf("!")));
            }
        }
        return selectOpSet;
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (key.equalsIgnoreCase("btnok")) {
            this.returnDataToParent();
        }
    }

    private void returnDataToParent() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("entryentity");
        int[] rowKeys = grid.getEntryState().getSelectedRows();
        if (ObjectUtils.isEmpty((Object)rowKeys)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u64cd\u4f5c", (String)"IntegratedOperationListEditPlugin_0", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]));
            return;
        }
        IDataModel model = this.getModel();
        ArrayList<String> opList = new ArrayList<String>(10);
        ArrayList<String> errList = new ArrayList<String>(10);
        ArrayList<String> adList = new ArrayList<String>(10);
        for (int rowKey : rowKeys) {
            String code = ConvertUtils.toString((Object)model.getValue("fcode", rowKey));
            String type = ConvertUtils.toString((Object)model.getValue("ftype", rowKey));
            if (HRStringUtils.equals((String)type, (String)"donothing")) {
                if (DO_NOTHING_LIST.contains(code)) {
                    opList.add(String.join((CharSequence)"!", ConvertUtils.toString((Object)model.getValue("fcode", rowKey)), ConvertUtils.toString((Object)model.getValue("fname", rowKey))));
                    continue;
                }
                errList.add(ConvertUtils.toString((Object)model.getValue("fcode", rowKey)));
                adList.add(String.join((CharSequence)"!", ConvertUtils.toString((Object)model.getValue("fcode", rowKey)), ConvertUtils.toString((Object)model.getValue("fname", rowKey))));
                continue;
            }
            opList.add(String.join((CharSequence)"!", ConvertUtils.toString((Object)model.getValue("fcode", rowKey)), ConvertUtils.toString((Object)model.getValue("fname", rowKey))));
        }
        if (CollectionUtils.isNotEmpty(errList)) {
            this.getView().showConfirm(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u76ee\u524d\u4e0d\u652f\u6301\u64cd\u4f5c\uff08%1$s\uff09\u7684\u5b9e\u65f6\u96c6\u6210\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5df2\u4e8c\u5f00\u6269\u5c55\u652f\u6301\uff1f", (String)"IntegratedOperationListEditPlugin_1", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", errList)), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("btnok", (IFormPlugin)this));
            this.getView().getPageCache().put("opList", JSON.toJSONString(opList));
            this.getView().getPageCache().put("errList", JSON.toJSONString(adList));
            this.getView().sendFormAction(this.getView());
            return;
        }
        this.getView().returnDataToParent(opList);
        this.getView().close();
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (HRStringUtils.equals((String)messageBoxClosedEvent.getCallBackId(), (String)"btnok")) {
            List opList = JSON.parseArray((String)this.getView().getPageCache().get("opList"), String.class);
            List errList = JSON.parseArray((String)this.getView().getPageCache().get("errList"), String.class);
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                opList.addAll(errList);
            }
            this.getView().returnDataToParent((Object)opList);
            this.getView().close();
        }
    }
}

