/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.formplugin.web.intgovern.form;

import java.util.EventObject;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.lang.Lang;
import kd.bos.mvc.list.ListView;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.BackgroundTaskSubscriber;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.formplugin.web.HDTCDataBaseEdit;
import kd.hdtc.hrdi.common.util.HRDICacheUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class ProgressEditPlugin
extends HDTCDataBaseEdit
implements ProgresssListener {
    public void registerListener(EventObject eventObject) {
        ProgressBar progressBar = (ProgressBar)this.getControl("progress");
        progressBar.addProgressListener((ProgresssListener)this);
        Button button = (Button)this.getControl("btnok");
        button.addClickListener((ClickListener)this);
    }

    public void afterBindData(EventObject eventObject) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"btncancel", "resultpanel"});
        ProgressBar progressBar = (ProgressBar)this.getControl("progress");
        progressBar.start();
        String taskId = this.getTaskId();
        if (HRStringUtils.isNotEmpty((String)taskId)) {
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            int progress = taskInfo.getProgress();
            if (progress >= 100) {
                progress = 99;
            }
            progressBar.setPercent(progress);
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"btnok"});
        }
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        if (StringUtils.equalsIgnoreCase((String)"btnok", (String)source.getKey())) {
            TaskClientProxy.setProgressPageId((String)this.getTaskId(), (String)"");
            this.getView().close();
            this.tranBackGround();
        }
    }

    public void onProgress(ProgressEvent progressEvent) {
        String taskId = this.getTaskId();
        if (HRStringUtils.isEmpty((String)taskId)) {
            this.dispatchTask();
            this.getView().setEnable(Boolean.TRUE, new String[]{"btnok"});
            return;
        }
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        if (taskInfo.isTaskEnd()) {
            this.stopProgress(progressEvent);
            this.calculateResult();
        } else {
            progressEvent.setProgress(taskInfo.getProgress());
        }
    }

    protected void dispatchTask() {
    }

    protected void calculateResult() {
    }

    protected void tranBackGround() {
    }

    public void insertCache(JobFormInfo jobFormInfo, String taskId, String cacheKey) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.put("JobFormInfo", SerializationUtils.toJsonString((Object)jobFormInfo));
        customParams.put("taskId", taskId);
        HRDICacheUtils.put((String)cacheKey, (Object)SerializationUtils.toJsonString((Object)customParams));
    }

    public JobFormInfo dispatch(String name, Map<String, Object> customParamMap, String taskClassName, String clickClassName) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setAppId("hrdi");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(UserServiceHelper.getCurrentUserId());
        jobInfo.setName(name);
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname(taskClassName);
        jobInfo.setParams(customParamMap);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCaption(name);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setCanStop(true);
        jobFormInfo.setClickClassName(clickClassName);
        jobFormInfo.setRootPageId(this.getView().getFormShowParameter().getRootPageId());
        jobFormInfo.setParentPageId(this.getView().getParentView().getPageId());
        return jobFormInfo;
    }

    public void doTranBackground(String cacheKey, String name) {
        String taskId = this.getTaskId();
        if (HRStringUtils.isEmpty((String)taskId)) {
            return;
        }
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        if (taskInfo.isTaskEnd()) {
            return;
        }
        if (!TaskClientProxy.isExistTask((String)taskId)) {
            JobFormInfo jobFormInfo = this.getJobFormInfoByCache(cacheKey);
            if (jobFormInfo == null || StringUtils.isEmpty((String)taskInfo.getId())) {
                return;
            }
            TaskClientProxy.addTask((IFormView)this.getView(), (JobFormInfo)jobFormInfo, (TaskInfo)taskInfo);
            BackgroundTaskSubscriber subscriber = new BackgroundTaskSubscriber(RequestContext.get(), jobFormInfo, taskId);
            ThreadPools.executeOnce((String)name, (Runnable)subscriber);
        }
    }

    private void stopProgress(ProgressEvent evt) {
        evt.setProgress(100);
        ProgressBar bar = (ProgressBar)this.getView().getControl("progress");
        bar.stop();
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        if (parentView instanceof ListView) {
            ((ListView)parentView).clearSelection();
            parentView.invokeOperation("refresh");
        } else {
            parentView.updateView();
        }
        this.getView().sendFormAction(parentView);
    }

    private JobFormInfo getJobFormInfoByCache(String cacheKey) {
        String params = (String)HRDICacheUtils.get((String)cacheKey, String.class);
        if (!HRStringUtils.isEmpty((String)params)) {
            Map customParams = (Map)SerializationUtils.fromJsonString((String)params, Map.class);
            String jobFormInfo = customParams.get("JobFormInfo").toString();
            if (HRStringUtils.isEmpty((String)jobFormInfo)) {
                return null;
            }
            return (JobFormInfo)SerializationUtils.fromJsonString((String)jobFormInfo, JobFormInfo.class);
        }
        return null;
    }

    public void setTaskId(String taskId) {
        this.getPageCache().put("taskId", taskId);
    }

    private String getTaskId() {
        if (this.getView().getFormShowParameter().getCustomParams().containsKey("taskId")) {
            return (String)this.getView().getFormShowParameter().getCustomParam("taskId");
        }
        return this.getPageCache().get("taskId");
    }
}

