/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.formplugin.web.intgovern.list;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.list.column.ListOperationColumnDesc;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrdbs.business.application.service.metadata.IDynamicMetadataApplicationService;
import kd.hdtc.hrdbs.business.common.ServiceFactory;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenParam;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenResult;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hdtc.hrdbs.formplugin.web.HDTCDataBaseList;
import kd.hdtc.hrdi.business.domain.config.IHRDIBaseConfigDomainService;
import kd.hdtc.hrdi.business.domain.intgovern.entity.IIntRelationEntityService;
import kd.hdtc.hrdi.business.domain.middle.IMidTableConfigDomainService;
import kd.hdtc.hrdi.business.domain.middle.entity.IMidTableConfigEntityService;

public class IntRelationListPlugin
extends HDTCDataBaseList {
    private final IIntRelationEntityService intRelationEntityService = (IIntRelationEntityService)kd.hdtc.hrdi.business.common.ServiceFactory.getService(IIntRelationEntityService.class);
    private final IMidTableConfigDomainService midTableConfigDomainService = (IMidTableConfigDomainService)kd.hdtc.hrdi.business.common.ServiceFactory.getService(IMidTableConfigDomainService.class);
    private final IDynamicMetadataApplicationService dynamicMetadataApplicationService = (IDynamicMetadataApplicationService)ServiceFactory.getService(IDynamicMetadataApplicationService.class);
    private final IHRDIBaseConfigDomainService configDomainService = (IHRDIBaseConfigDomainService)kd.hdtc.hrdi.business.common.ServiceFactory.getService(IHRDIBaseConfigDomainService.class);
    private final IMidTableConfigEntityService configEntityService = (IMidTableConfigEntityService)kd.hdtc.hrdi.business.common.ServiceFactory.getService(IMidTableConfigEntityService.class);
    private final String RES_GEN_INFO = ResManager.loadKDString((String)"\u751f\u6210\u4e2d\u95f4\u8868\u5b9e\u4f53\u6210\u529f", (String)"IntSourceListPlugin_10", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]);
    private final String RES_GEN_ERROR = ResManager.loadKDString((String)"\u751f\u6210\u4e2d\u95f4\u8868\u5b9e\u4f53\u5931\u8d25\u3002", (String)"IntSourceListPlugin_3", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]);

    public void beforeDoOperation(BeforeDoOperationEventArgs event) {
        String operateKey;
        super.beforeDoOperation(event);
        FormOperate formOperate = (FormOperate)event.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "viewmidtable": {
                this.viewMidTable(event);
                break;
            }
            case "viewintlog": {
                this.viewIntLog(event);
                break;
            }
        }
    }

    private long getSelectedRowId(BeforeDoOperationEventArgs event) {
        ListSelectedRowCollection listSelectedData = event.getListSelectedData();
        ListSelectedRow listSelectedRow = listSelectedData.get(0);
        return (Long)listSelectedRow.getPrimaryKeyValue();
    }

    private void viewMidTable(BeforeDoOperationEventArgs event) {
        long primaryKeyValue = this.getSelectedRowId(event);
        DynamicObject intRelation = this.queryIntRelation(primaryKeyValue);
        DynamicObject intSource = intRelation.getDynamicObject("intsource");
        if (this.hasMidTableMetadata(intSource)) {
            String midTableNumber = this.getMidTableNumber(intSource.getLong("midtableconfig.id"));
            String pageId = this.getView().getPageId() + "_" + primaryKeyValue + "-" + midTableNumber;
            String title = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u4e2d\u95f4\u8868\u5217\u8868", (String)"IntSourceListPlugin_8", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]), intSource.getString("name"));
            String sourceSysNumber = intRelation.getDynamicObject("sourcesys").getString("number");
            QFilter filter = new QFilter("hrdisourcesys", "=", (Object)sourceSysNumber);
            this.showListPage(midTableNumber, pageId, title, filter);
        } else {
            long midTableConfigId = intSource.getLong("midtableconfig.id");
            this.getPageCache().put("cacheMidTableConfigId", midTableConfigId + "");
            event.setCancel(true);
            this.showConfirm();
        }
    }

    private boolean hasMidTableMetadata(DynamicObject intSource) {
        long midTableConfigId = intSource.getLong("midtableconfig.id");
        return MetadataUtils.isExist((String)this.getMidTableNumber(midTableConfigId));
    }

    private String getMidTableNumber(long midTableId) {
        String midTableNumber = this.getPageCache().get(midTableId + "");
        if (StringUtils.isEmpty((String)midTableNumber)) {
            DynamicObject midTableConfig = this.configEntityService.queryOne("midentitynumber", (Object)midTableId);
            midTableNumber = midTableConfig.getString("midentitynumber");
            this.getPageCache().put(midTableId + "", midTableNumber);
        }
        return midTableNumber;
    }

    private DynamicObject queryIntRelation(long primaryKeyValue) {
        return this.intRelationEntityService.queryOne("number,name,intsource,intdirection,intmode,sourcesys", (Object)primaryKeyValue);
    }

    private void showConfirm() {
        ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("generateMidTableActionId", (IFormPlugin)this);
        HashMap btnNameMaps = Maps.newHashMapWithExpectedSize((int)16);
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"IntSourceListPlugin_0", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u91cd\u65b0\u751f\u6210", (String)"IntSourceListPlugin_1", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]));
        String title = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5bf9\u5e94\u7684\u4e2d\u95f4\u8868\u8fd8\u672a\u751f\u6210\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u4e2d\u95f4\u8868\u3002", (String)"IntSourceListPlugin_2", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(title, "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, callBackListener, (Map)btnNameMaps);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (StringUtils.equals((String)"generateMidTableActionId", (String)event.getCallBackId()) && event.getResult() == MessageBoxResult.Yes) {
            String midTableConfigId = this.getPageCache().get("cacheMidTableConfigId");
            if (StringUtils.isEmpty((String)midTableConfigId)) {
                return;
            }
            Map metadataGenParamMap = this.midTableConfigDomainService.batchBuildGenParam((Set)ImmutableSet.of((Object)Long.parseLong(midTableConfigId)));
            for (Map.Entry entry : metadataGenParamMap.entrySet()) {
                MetadataGenResult result = this.dynamicMetadataApplicationService.generate((MetadataGenParam)entry.getValue());
                if (!result.isSuccess()) {
                    String msg = this.RES_GEN_ERROR + String.join((CharSequence)",", result.getMsgList());
                    this.getView().showErrorNotification(msg);
                    continue;
                }
                this.getView().showSuccessNotification(this.RES_GEN_INFO);
            }
        }
    }

    private void viewIntLog(BeforeDoOperationEventArgs event) {
        long primaryKeyValue = this.getSelectedRowId(event);
        DynamicObject intRelation = this.queryIntRelation(primaryKeyValue);
        DynamicObject intSource = intRelation.getDynamicObject("intsource");
        String intSourceName = intSource.getString("name");
        String formId = "hrdi_intlog";
        String title = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5411\u5185\u96c6\u6210\u65e5\u5fd7\u5217\u8868", (String)"IntSourceListPlugin_6", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]), intSourceName);
        if ("2".equals(intRelation.getString("intdirection")) && "2".equals(intRelation.getString("intmode"))) {
            formId = "hrdi_msgrecordlog";
            title = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5411\u5916\u96c6\u6210\u65e5\u5fd7\u5217\u8868", (String)"IntSourceListPlugin_9", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]), intSourceName);
        }
        String pageId = this.getView().getPageId() + "_" + primaryKeyValue + "-" + formId;
        QFilter filter = new QFilter("intsource", "=", (Object)intRelation.getLong("intsource.id"));
        filter.and("sourcesys", "=", (Object)intRelation.getLong("sourcesys.id"));
        this.showListPage(formId, pageId, title, filter);
    }

    private void showListPage(String billFormId, String pageId, String title, QFilter qFilter) {
        ListShowParameter lsp = new ListShowParameter();
        lsp.setFormId("bos_list");
        lsp.setBillFormId(billFormId);
        lsp.setHasRight(true);
        lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        lsp.setPageId(pageId);
        if (StringUtils.isNotEmpty((String)title)) {
            lsp.setCaption(title);
        }
        if (qFilter != null) {
            lsp.getListFilterParameter().setFilter(qFilter);
        }
        this.getView().showForm((FormShowParameter)lsp);
    }

    public void packageData(PackageDataEvent event) {
        Object midTableConfig;
        DynamicObject intSourceDyn;
        Object source = event.getSource();
        if (!(source instanceof ListOperationColumnDesc)) {
            return;
        }
        boolean saveMidTableData = "1".equals(this.getView().getPageCache().get("is.save.midtable.data"));
        DynamicObject rowData = event.getRowData();
        boolean showIntLog = true;
        boolean showMidTable = true;
        if ("2".equals(rowData.getString("intdirection"))) {
            showMidTable = false;
        }
        if ((intSourceDyn = rowData.getDynamicObject("intsource")) != null && (midTableConfig = intSourceDyn.get("midtableconfig")) == null) {
            showMidTable = false;
        }
        if ("2".equals(rowData.getString("intdirection")) && "1".equals(rowData.getString("intmode"))) {
            showIntLog = false;
        }
        List itemList = (List)event.getFormatValue();
        for (OperationColItem item : itemList) {
            if (saveMidTableData && "viewmidtable".equals(item.getOperationKey())) {
                item.setVisible(showMidTable);
            }
            if (!"viewintlog".equals(item.getOperationKey())) continue;
            item.setVisible(showIntLog);
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        String saveMidTableData = this.configDomainService.queryBaseConfigValueByNumber("is.save.midtable.data");
        this.getView().getPageCache().put("is.save.midtable.data", saveMidTableData);
        if ("1".equals(saveMidTableData)) {
            return;
        }
        List listColumnList = args.getListColumns();
        listColumnList.removeIf(listColumn -> "viewmidtable".equals(listColumn.getListFieldKey()));
    }
}

