/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.formplugin.web.intgovern.list;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.bos.list.ListShowParameter;
import kd.bos.list.column.ListOperationColumnDesc;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrdbs.business.application.service.metadata.IDynamicMetadataApplicationService;
import kd.hdtc.hrdbs.business.common.ServiceFactory;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenParam;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenResult;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hdtc.hrdbs.formplugin.web.HDTCDataBaseList;
import kd.hdtc.hrdi.business.domain.datamapping.entity.DataMappingFactory;
import kd.hdtc.hrdi.business.domain.intgovern.entity.IIntSourceEntityService;
import kd.hdtc.hrdi.business.domain.middle.IMidTableConfigDomainService;

public class IntSourceListPlugin
extends HDTCDataBaseList {
    private final IIntSourceEntityService intSourceEntityService = (IIntSourceEntityService)kd.hdtc.hrdi.business.common.ServiceFactory.getService(IIntSourceEntityService.class);
    private final IMidTableConfigDomainService midTableConfigDomainService = (IMidTableConfigDomainService)kd.hdtc.hrdi.business.common.ServiceFactory.getService(IMidTableConfigDomainService.class);
    private final IDynamicMetadataApplicationService dynamicMetadataApplicationService = (IDynamicMetadataApplicationService)ServiceFactory.getService(IDynamicMetadataApplicationService.class);
    private final String RES_GEN_ERROR = ResManager.loadKDString((String)"\u751f\u6210\u4e2d\u95f4\u8868\u5b9e\u4f53\u5931\u8d25\u3002", (String)"IntSourceListPlugin_3", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]);
    private final String RES_GEN_INFO = ResManager.loadKDString((String)"\u751f\u6210\u4e2d\u95f4\u8868\u5b9e\u4f53\u6210\u529f", (String)"IntSourceListPlugin_10", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]);

    public void beforeDoOperation(BeforeDoOperationEventArgs beforeDoOperationEventArgs) {
        super.beforeDoOperation(beforeDoOperationEventArgs);
        FormOperate formOperate = (FormOperate)beforeDoOperationEventArgs.getSource();
        String operateKey = formOperate.getOperateKey();
        ListSelectedRowCollection listSelectedData = beforeDoOperationEventArgs.getListSelectedData();
        if (StringUtils.equals((String)"viewmidtable", (String)operateKey)) {
            ListSelectedRow listSelectedRow = listSelectedData.get(0);
            long primaryKeyValue = (Long)listSelectedRow.getPrimaryKeyValue();
            this.viewMidTable(primaryKeyValue, beforeDoOperationEventArgs);
        } else if (StringUtils.equals((String)"viewidmapping", (String)operateKey)) {
            if (listSelectedData.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\uff0c\u4e0d\u652f\u6301\u6279\u91cf\u67e5\u8be2\u6620\u5c04\u5173\u7cfb\u3002", (String)"IntSourceListPlugin_4", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]));
            } else {
                ListSelectedRow listSelectedRow = listSelectedData.get(0);
                long primaryKeyValue = (Long)listSelectedRow.getPrimaryKeyValue();
                this.viewIdMapping(primaryKeyValue);
            }
        } else if (StringUtils.equals((String)"viewmappinglog", (String)operateKey)) {
            Object[] primaryKeyValues = listSelectedData.getPrimaryKeyValues();
            String pageId = this.getView().getPageId() + "_" + primaryKeyValues[0];
            QFilter entityObjIdFilter = new QFilter("datamaprecord.intsource", "in", (Object)primaryKeyValues);
            this.viewListPage("hrdi_datamappinglog", "bos_list", pageId, null, entityObjIdFilter);
        } else if (StringUtils.equals((String)"viewqueryapi", (String)operateKey)) {
            Object[] primaryKeyValues = listSelectedData.getPrimaryKeyValues();
            String pageId = this.getView().getPageId() + "_" + primaryKeyValues[0];
            String selectProperties = String.join((CharSequence)",", "id", "name", "entityobj.id");
            DynamicObject intSource = this.intSourceEntityService.queryOne(selectProperties, primaryKeyValues[0]);
            QFilter entityObjIdFilter = new QFilter("mainentityobj", "=", intSource.get("entityobj.id"));
            this.viewListPage("hrdi_queryapiconfig", "hrdi_intsourcetreelist", pageId, null, entityObjIdFilter);
        }
    }

    private void showProgressForm(List<Object> successPkIds) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hrdi_mappingprogress");
        showParameter.setCaption(ResManager.loadKDString((String)"\u540c\u6b65\u521d\u59cb\u5316\u6620\u5c04\u5173\u7cfb", (String)"IntSourceListPlugin_5", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("intSourceIds", successPkIds);
        showParameter.setCustomParam("batchnumber", (Object)ID.genLongId());
        this.getView().showForm(showParameter);
    }

    private void viewListPage(String billFormId, String formId, String pageId, String title, QFilter qFilter) {
        ListShowParameter lsp = new ListShowParameter();
        lsp.setFormId(formId);
        lsp.setBillFormId(billFormId);
        lsp.setHasRight(true);
        lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        lsp.setPageId(pageId);
        if (StringUtils.isNotEmpty((String)title)) {
            lsp.setCaption(title);
        }
        if (qFilter != null) {
            lsp.getListFilterParameter().setFilter(qFilter);
        }
        this.getView().showForm((FormShowParameter)lsp);
    }

    private void viewIdMapping(long primaryKeyValue) {
        String selectProperties = String.join((CharSequence)",", "id", "name", "entityobj.id", "midtableconfig.id");
        DynamicObject intSource = this.intSourceEntityService.queryOne(selectProperties, (Object)primaryKeyValue);
        if (intSource != null) {
            String entityNumber = intSource.getString("entityobj.id");
            String idMappingEntityNumber = new DataMappingFactory().getIdMappingEntityNumber(entityNumber);
            ListShowParameter lsp = new ListShowParameter();
            lsp.setFormId("bos_list");
            lsp.setBillFormId(idMappingEntityNumber);
            lsp.setHasRight(true);
            String pageId = this.getView().getPageId() + "_" + primaryKeyValue + "-" + idMappingEntityNumber;
            lsp.setPageId(pageId);
            String title = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u6570\u636e\u6620\u5c04\u5173\u7cfb", (String)"IntSourceListPlugin_7", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]), intSource.getString("name"));
            lsp.setCaption(title);
            lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            QFilter entityObjIdFilter = new QFilter("entityobjid", "=", (Object)entityNumber);
            lsp.getListFilterParameter().setFilter(entityObjIdFilter);
            this.getView().showForm((FormShowParameter)lsp);
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        args.getListColumns().removeIf(listColumn -> "viewintlog".equals(listColumn.getListFieldKey()));
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (StringUtils.equals((String)"publish_in_openapi", (String)operateKey) && operationResult != null && operationResult.isSuccess()) {
            this.getView().invokeOperation("refresh");
        } else if (StringUtils.equals((String)"cancel_openapi", (String)operateKey) && operationResult != null && operationResult.isSuccess()) {
            this.getView().invokeOperation("refresh");
        } else if (StringUtils.equals((String)"syncinitmapping", (String)operateKey) && operationResult != null && operationResult.isSuccess()) {
            List successPkIds = operationResult.getSuccessPkIds();
            this.showProgressForm(successPkIds);
        }
    }

    private void viewMidTable(long primaryKeyValue, BeforeDoOperationEventArgs beforeDoOperationEventArgs) {
        String selectProperties = String.join((CharSequence)",", "id", "midtableconfig.midentitynumber", "midtableconfig.id");
        DynamicObject intSource = this.intSourceEntityService.queryOne(selectProperties, (Object)primaryKeyValue);
        if (intSource != null) {
            String entityNumber = intSource.getString("midtableconfig.midentitynumber");
            if (MetadataUtils.isExist((String)entityNumber)) {
                String midTableNumber = intSource.getString("midtableconfig.midentitynumber");
                ListShowParameter lsp = new ListShowParameter();
                lsp.setFormId("bos_list");
                lsp.setBillFormId(midTableNumber);
                lsp.setHasRight(true);
                String pageId = this.getView().getPageId() + "_" + primaryKeyValue + "-" + midTableNumber;
                lsp.setPageId(pageId);
                String title = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u4e2d\u95f4\u8868\u5217\u8868", (String)"IntSourceListPlugin_8", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]), intSource.getString("name"));
                lsp.setCaption(title);
                lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)lsp);
            } else {
                ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("generateMidTableActionId", (IFormPlugin)this);
                HashMap btnNameMaps = Maps.newHashMapWithExpectedSize((int)16);
                btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"IntSourceListPlugin_0", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]));
                btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u91cd\u65b0\u751f\u6210", (String)"IntSourceListPlugin_1", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]));
                String title = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5bf9\u5e94\u7684\u4e2d\u95f4\u8868\u8fd8\u672a\u751f\u6210\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u4e2d\u95f4\u8868\u3002", (String)"IntSourceListPlugin_2", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(title, "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, callBackListener, (Map)btnNameMaps);
                long midTableConfigId = intSource.getLong("midtableconfig.id");
                this.getPageCache().put("cacheMidTableConfigId", midTableConfigId + "");
                beforeDoOperationEventArgs.setCancel(true);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String midTableConfigId;
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((String)"generateMidTableActionId", (String)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes && StringUtils.isNotEmpty((String)(midTableConfigId = this.getPageCache().get("cacheMidTableConfigId")))) {
            Map metadataGenParamMap = this.midTableConfigDomainService.batchBuildGenParam((Set)ImmutableSet.of((Object)Long.parseLong(midTableConfigId)));
            for (Map.Entry entry : metadataGenParamMap.entrySet()) {
                MetadataGenResult result = this.dynamicMetadataApplicationService.generate((MetadataGenParam)entry.getValue());
                if (!result.isSuccess()) {
                    String msg = this.RES_GEN_ERROR + String.join((CharSequence)",", result.getMsgList());
                    this.getView().showErrorNotification(msg);
                    continue;
                }
                this.getView().showSuccessNotification(this.RES_GEN_INFO);
            }
        }
    }

    public void packageData(PackageDataEvent event) {
        Object source = event.getSource();
        if (!(source instanceof ListOperationColumnDesc)) {
            return;
        }
        DynamicObject rowData = event.getRowData();
        DynamicObject midTableDyn = rowData.getDynamicObject("midtableconfig");
        if (midTableDyn != null) {
            return;
        }
        List itemList = (List)event.getFormatValue();
        for (OperationColItem item : itemList) {
            if ("viewmidtable".equals(item.getOperationKey())) {
                item.setVisible(false);
            }
            if (!"viewidmapping".equals(item.getOperationKey())) continue;
            item.setVisible(false);
        }
    }
}

