/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.formplugin.web.intserviceconfig.list;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrdi.business.application.external.IIscServiceFlowDomainService;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.intserviceconfig.IIntScmLogDomainService;

public class IntScmLogListPlugin
extends AbstractListPlugin {
    private final IIntScmLogDomainService intScmLogDomainService = (IIntScmLogDomainService)ServiceFactory.getService(IIntScmLogDomainService.class);
    private final IIscServiceFlowDomainService serviceFlowDomainService = (IIscServiceFlowDomainService)ServiceFactory.getService(IIscServiceFlowDomainService.class);
    private final String NO_DATA_TIP = ResManager.loadKDString((String)"\u60a8\u8981\u8bfb\u53d6\u7684\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u3002\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u8bd5!", (String)"IntSchemaLogListPlugin_0", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]);

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getFieldName();
        if ("number".equals(fieldName)) {
            args.setCancel(true);
            Object selectedId = ((BillList)args.getHyperLinkClickEvent().getSource()).getCurrentSelectedRowInfo().getPrimaryKeyValue();
            this.doShowIscListPage(selectedId);
        }
    }

    private void doShowIscListPage(Object selectedId) {
        ListShowParameter listShowParameter;
        DynamicObject intScmLogDyn = this.intScmLogDomainService.queryIntScmLogById((Long)selectedId);
        if (Objects.isNull(intScmLogDyn)) {
            this.getView().showTipNotification(this.NO_DATA_TIP);
            return;
        }
        String iscType = intScmLogDyn.getString("inttype");
        long scmId = intScmLogDyn.getDynamicObject("intscm").getLong("id");
        if ("isc_data_copy_trigger".equalsIgnoreCase(iscType)) {
            QFilter qFilter = new QFilter("data_copy_trigger", "=", (Object)scmId);
            listShowParameter = this.getListShowParameter("isc_data_copy_execution", qFilter);
            listShowParameter.getCustomParams().put("isctype", "isc_data_copy_trigger");
        } else if ("isc_service_flow".equalsIgnoreCase(iscType)) {
            List pkIdList = this.serviceFlowDomainService.queryPrimaryKeys(Long.valueOf(scmId));
            QFilter qFilter = new QFilter("flow", "in", (Object)pkIdList);
            listShowParameter = this.getListShowParameter("isc_sf_proc_inst", qFilter);
            listShowParameter.getCustomParams().put("isctype", "isc_service_flow");
        } else {
            listShowParameter = null;
        }
        if (listShowParameter != null) {
            listShowParameter.setHasRight(true);
            listShowParameter.setPageId(selectedId.toString());
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    private ListShowParameter getListShowParameter(String formId, QFilter qFilter) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.setFormId("bos_list");
        listShowParameter.setBillFormId(formId);
        if (qFilter != null) {
            ArrayList qFilterList = Lists.newArrayListWithExpectedSize((int)1);
            qFilterList.add(qFilter);
            listShowParameter.getListFilterParameter().setQFilters((List)qFilterList);
        }
        return listShowParameter;
    }
}

