/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.formplugin.web.middle.form;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.DefaultEntityOperate;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.commonfield.BigIntField;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.DateField;
import kd.bos.metadata.entity.commonfield.DateTimeField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.IntegerField;
import kd.bos.metadata.entity.commonfield.LargeTextField;
import kd.bos.metadata.entity.commonfield.MuliLangTextField;
import kd.bos.metadata.entity.commonfield.TelephoneField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.entity.commonfield.TimeField;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.ConvertUtils;
import kd.hdtc.hrdbs.common.util.JsonUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hdtc.hrdbs.formplugin.web.HDTCDataBaseEdit;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.config.IHRDIBaseConfigDomainService;
import kd.hdtc.hrdi.business.domain.middle.IMidTableConfigDomainService;
import kd.hdtc.hrdi.common.middle.constants.BatchModifyConstants;
import kd.hdtc.hrdi.common.pojo.MidTableConfig;
import kd.hdtc.hrdi.common.pojo.MiddleField;

public class MidBatchModifyFormPlugin
extends HDTCDataBaseEdit {
    private static final Log log = LogFactory.getLog(MidBatchModifyFormPlugin.class);
    private static final LinkedHashSet<String> COMMON_FIELD_SET = Sets.newLinkedHashSetWithExpectedSize((int)9);
    private final IHRDIBaseConfigDomainService baseConfigDomainService = (IHRDIBaseConfigDomainService)ServiceFactory.getService(IHRDIBaseConfigDomainService.class);
    private final IMidTableConfigDomainService configDomainService = (IMidTableConfigDomainService)ServiceFactory.getService(IMidTableConfigDomainService.class);
    private final Set<String> MUST_FIELD_SET = ImmutableSet.of((Object)"hrdibatchnumber", (Object)"hrdisourcesys", (Object)"hrdisourcesyskey");

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        String fieldName;
        if ("fieldnames".equals(propertyChangedArgs.getProperty().getName()) && !StringUtils.isEmpty((String)(fieldName = propertyChangedArgs.getChangeSet()[0].getNewValue().toString()))) {
            MiddleField fieldInfo;
            String showField;
            String fieldNameFieldTypeMapStr = this.getPageCache().get("fieldNumberFieldInfoMap");
            Map fieldNumberFieldInfoMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
            try {
                fieldNumberFieldInfoMap = (Map)JsonUtils.cast((String)fieldNameFieldTypeMapStr, Map.class);
            }
            catch (Exception e) {
                log.error("JsonUtils.cast error:", (Throwable)e);
            }
            if (!CollectionUtils.isEmpty((Map)fieldNumberFieldInfoMap) && !StringUtils.isEmpty((String)(showField = (fieldInfo = (MiddleField)JSONObject.parseObject((String)JSONObject.toJSONString(fieldNumberFieldInfoMap.get(fieldName)), MiddleField.class)).getFieldType().toLowerCase()))) {
                String oldField;
                MiddleField hideFieldInfo;
                String hideFieldName;
                this.getModel().setValue("showfield", (Object)showField);
                this.getModel().setValue("textlength", (Object)fieldInfo.getLength());
                FieldEdit fieldEdit = (FieldEdit)this.getControl(showField);
                fieldEdit.setCaption(fieldInfo.getFieldName());
                if (ComboField.class.getSimpleName().equals(fieldInfo.getFieldType())) {
                    ArrayList itemList = Lists.newArrayListWithCapacity((int)fieldInfo.getItemList().size());
                    for (kd.bos.metadata.entity.commonfield.ComboItem cItem : fieldInfo.getItemList()) {
                        ComboItem comboItem = new ComboItem();
                        comboItem.setValue(cItem.getValue());
                        comboItem.setCaption(cItem.getCaption());
                        itemList.add(comboItem);
                    }
                    ((ComboEdit)fieldEdit).setComboItems((List)itemList);
                }
                if (propertyChangedArgs.getChangeSet()[0].getOldValue() != null && !StringUtils.isEmpty((String)propertyChangedArgs.getChangeSet()[0].getOldValue().toString()) && !StringUtils.isEmpty((String)(hideFieldName = (hideFieldInfo = (MiddleField)JSONObject.parseObject((String)JSONObject.toJSONString(fieldNumberFieldInfoMap.get(oldField = propertyChangedArgs.getChangeSet()[0].getOldValue().toString())), MiddleField.class)).getFieldType().toLowerCase()))) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{hideFieldName});
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{showField});
                this.mustInputFieldHandle(fieldEdit, fieldName);
                this.getView().updateView();
            }
        }
    }

    private void mustInputFieldHandle(FieldEdit fieldEdit, String fieldName) {
        Set mustInputFieldSet = (Set)JSONObject.parseObject((String)this.getPageCache().get("mustInputFieldNumber"), Set.class);
        if (mustInputFieldSet.contains(fieldName)) {
            fieldEdit.setMustInput(true);
        }
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Object dataFormId = showParameter.getCustomParam("dataFormId");
        this.getModel().setValue("data_formid", dataFormId);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs beforeDoOperationEventArgs) {
        super.beforeDoOperation(beforeDoOperationEventArgs);
        if ("batch_save".equals(((DefaultEntityOperate)beforeDoOperationEventArgs.getSource()).getOperateKey())) {
            this.checkFieldLength(beforeDoOperationEventArgs);
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            Object primaryKeys = showParameter.getCustomParam("primaryKeys");
            Object dataFormId = showParameter.getCustomParam("dataFormId");
            OperateOption option = ((DefaultEntityOperate)beforeDoOperationEventArgs.getSource()).getOption();
            option.setVariableValue("primaryKeys", primaryKeys.toString());
            option.setVariableValue("dataFormId", dataFormId.toString());
        }
    }

    private void checkFieldLength(BeforeDoOperationEventArgs beforeDoOperationEventArgs) {
        String showField = ConvertUtils.toString((Object)this.getModel().getValue("showfield"));
        int textLen = ConvertUtils.toInt((Object)this.getModel().getValue("textlength"));
        if (BatchModifyConstants.TEXT_FIELD_LIST.contains(showField)) {
            if ("mulilangtextfield".equals(showField)) {
                ((OrmLocaleValue)this.getModel().getValue(showField)).forEach((key, value) -> {
                    int length = value.getBytes(StandardCharsets.UTF_8).length;
                    if (textLen < length) {
                        this.getView().showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8f93\u5165\u957f\u5ea6\u8d85\u957f\uff0c\u6700\u5927\u957f\u5ea6\uff1a%1$s\u3002", (String)"MidBatchModifyFormPlugin_0", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]), textLen));
                        beforeDoOperationEventArgs.setCancel(true);
                    }
                });
            } else {
                int length;
                String value2 = ConvertUtils.toString((Object)this.getModel().getValue(showField));
                int n = length = StringUtils.isEmpty((String)value2) ? 0 : value2.getBytes(StandardCharsets.UTF_8).length;
                if (textLen < length) {
                    this.getView().showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8f93\u5165\u957f\u5ea6\u8d85\u957f\uff0c\u6700\u5927\u957f\u5ea6\uff1a%1$s\u3002", (String)"MidBatchModifyFormPlugin_0", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]), textLen));
                    beforeDoOperationEventArgs.setCancel(true);
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        OperationResult operationResult;
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (operateKey.equals("batch_save") && StringUtils.isNotEmpty((String)(operationResult = afterDoOperationEventArgs.getOperationResult()).getMessage())) {
            this.getView().returnDataToParent((Object)operationResult.getMessage());
        }
    }

    public void createNewData(BizDataEventArgs bizDataEventArgs) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Object dataFormId = showParameter.getCustomParam("dataFormId");
        ArrayList<ComboItem> itemList = new ArrayList<ComboItem>();
        ComboEdit comboEdit = (ComboEdit)this.getControl("fieldnames");
        String batchModifyCommonField = this.baseConfigDomainService.queryBaseConfigValueByNumber("batch.modify.common.field");
        boolean modifyCommonField = "1".equals(batchModifyCommonField);
        if (dataFormId != null) {
            List<EntityItem<?>> entityItemList = MidBatchModifyFormPlugin.getEntityItems(dataFormId.toString(), modifyCommonField);
            LinkedHashMap fieldNumberFieldInfoMap = Maps.newLinkedHashMapWithExpectedSize((int)entityItemList.size());
            for (EntityItem<?> entityItem : entityItemList) {
                ComboItem comboItem = new ComboItem();
                comboItem.setCaption(entityItem.getName());
                comboItem.setValue(entityItem.getKey());
                itemList.add(comboItem);
                MiddleField fieldInfo = this.getFieldType(entityItem);
                fieldNumberFieldInfoMap.put(entityItem.getKey(), fieldInfo);
            }
            comboEdit.setComboItems(itemList);
            this.getPageCache().put("fieldNumberFieldInfoMap", JSONObject.toJSONString((Object)fieldNumberFieldInfoMap));
            this.getView().setVisible(Boolean.FALSE, BatchModifyConstants.MIDDLE_BATCH_MODIFY_FIELD_LIST.toArray(new String[0]));
            this.cacheMustInputField(dataFormId.toString());
        }
    }

    private void cacheMustInputField(String midTableEntity) {
        MidTableConfig midTableConfig = this.configDomainService.getMidTableConfigByMidTable(midTableEntity);
        HashSet<String> mustFieldSet = new HashSet<String>(16);
        midTableConfig.getFieldConfigList().forEach(field -> {
            if (field.isIntField() && field.isMustInput()) {
                mustFieldSet.add(field.getNumberAlias());
            }
        });
        mustFieldSet.addAll(this.MUST_FIELD_SET);
        this.getPageCache().put("mustInputFieldNumber", JSONObject.toJSONString(mustFieldSet));
    }

    private MiddleField getFieldType(EntityItem<?> entityItem) {
        MiddleField fieldInfo = new MiddleField();
        String fieldType = "";
        if (entityItem instanceof BigIntField) {
            fieldType = BigIntField.class.getSimpleName();
        } else if (entityItem instanceof IntegerField) {
            fieldType = IntegerField.class.getSimpleName();
        } else if (entityItem instanceof DecimalField) {
            fieldType = DecimalField.class.getSimpleName();
        } else if (entityItem instanceof LargeTextField) {
            fieldType = LargeTextField.class.getSimpleName();
            fieldInfo.setLength(Integer.valueOf(((LargeTextField)entityItem).getMaxLength()));
        } else if (entityItem instanceof TelephoneField) {
            fieldType = TelephoneField.class.getSimpleName();
        } else if (entityItem instanceof DateField) {
            fieldType = DateField.class.getSimpleName();
        } else if (entityItem instanceof MuliLangTextField) {
            fieldType = MuliLangTextField.class.getSimpleName();
            fieldInfo.setLength(Integer.valueOf(((MuliLangTextField)entityItem).getMaxLength()));
        } else if (entityItem instanceof TimeField) {
            fieldType = TimeField.class.getSimpleName();
        } else if (entityItem instanceof CheckBoxField) {
            fieldType = CheckBoxField.class.getSimpleName();
        } else if (entityItem instanceof ComboField) {
            fieldType = ComboField.class.getSimpleName();
            fieldInfo.setItemList(((ComboField)entityItem).getItems());
        } else if (entityItem instanceof TextField) {
            fieldType = TextField.class.getSimpleName();
            fieldInfo.setLength(Integer.valueOf(((TextField)entityItem).getMaxLength()));
        } else if (entityItem instanceof DateTimeField) {
            fieldType = DateTimeField.class.getSimpleName();
        }
        if ("hrdisourcesys".equals(entityItem.getKey())) {
            fieldType = BasedataField.class.getSimpleName();
        }
        fieldInfo.setFieldType(fieldType);
        fieldInfo.setFieldName(entityItem.getName());
        return fieldInfo;
    }

    private static List<EntityItem<?>> getEntityItems(String number, boolean modifyCommonField) {
        List newItemList = MetadataUtils.getAllEntityItems((String)number);
        List<String> modifyCommonFieldList = Arrays.asList("hrdibatchnumber", "hrdisourcesys", "hrdisourcesyskey");
        if (!modifyCommonField) {
            newItemList = newItemList.stream().filter(dy -> !modifyCommonFieldList.contains(dy.getKey())).collect(Collectors.toList());
        }
        return newItemList.stream().filter(dy -> !COMMON_FIELD_SET.contains(dy.getKey()) && !dy.getKey().equals(number)).collect(Collectors.toList());
    }

    static {
        COMMON_FIELD_SET.add("hrdisequence");
        COMMON_FIELD_SET.add("hrdinumber");
        COMMON_FIELD_SET.add("hrdiintstatus");
        COMMON_FIELD_SET.add("interrormsg");
        COMMON_FIELD_SET.add("is_delete");
        COMMON_FIELD_SET.add("hrdicreatedate");
        COMMON_FIELD_SET.add("hrdimodifydate");
        COMMON_FIELD_SET.add("hrdicreater");
        COMMON_FIELD_SET.add("hrdimodifier");
        COMMON_FIELD_SET.add("is_exception");
    }
}

