/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.formplugin.web.middle.form;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrdbs.business.application.service.metadata.IDynamicMetadataApplicationService;
import kd.hdtc.hrdbs.business.common.ServiceFactory;
import kd.hdtc.hrdbs.common.constants.QFilterConstants;
import kd.hdtc.hrdbs.common.enums.MetadataOperateTypeEnum;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenParam;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenResult;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hdtc.hrdi.business.domain.common.IBaseCommonDomainService;
import kd.hdtc.hrdi.business.domain.config.IHRDIBaseConfigDomainService;
import kd.hdtc.hrdi.business.domain.intgovern.IIntSourceDomainService;
import kd.hdtc.hrdi.business.domain.middle.bo.MidTableConfigBo;
import kd.hdtc.hrdi.formplugin.web.middle.form.MidTableConfigTplEditPlugin;
import kd.hdtc.hrdi.formplugin.web.utils.HrdiPermHelper;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.common.constants.newhismodel.EnumEntityTpl;

public class MidTableConfigEditPlugin
extends MidTableConfigTplEditPlugin {
    private final IDynamicMetadataApplicationService dynamicMetadataApplicationService = (IDynamicMetadataApplicationService)ServiceFactory.getService(IDynamicMetadataApplicationService.class);
    private final IHRDIBaseConfigDomainService baseConfigDomainService = (IHRDIBaseConfigDomainService)kd.hdtc.hrdi.business.common.ServiceFactory.getService(IHRDIBaseConfigDomainService.class);
    private final IIntSourceDomainService sourceDomainService = (IIntSourceDomainService)kd.hdtc.hrdi.business.common.ServiceFactory.getService(IIntSourceDomainService.class);
    private final String RES_GEN_ERROR = ResManager.loadKDString((String)"\u751f\u6210\u4e2d\u95f4\u8868\u5b9e\u4f53\u5931\u8d25\u3002", (String)"HRDIMidTableConfigEdit_0", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]);
    private final String RES_SAVE_TEMP_FIRST = ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u6a21\u677f", (String)"HRDIMidTableConfigEdit_2", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]);
    private final IBaseCommonDomainService iBaseCommonDomainService = (IBaseCommonDomainService)kd.hdtc.hrdi.business.common.ServiceFactory.getService(IBaseCommonDomainService.class);

    @Override
    protected MidTableConfigBo createMidTableConfigBo(DynamicObject bizObj, DynamicObjectType dynamicObjectType) {
        MidTableConfigBo configBo = super.createMidTableConfigBo(bizObj, dynamicObjectType);
        configBo.setPage("hrdi_midtableconfig");
        configBo.setPageEntry("t_hrdi_midtableentry");
        return configBo;
    }

    @Override
    public void registerListener(EventObject event) {
        super.registerListener(event);
        this.addClickListeners(new String[]{"defaultvalue"});
    }

    @Override
    public void afterBindData(EventObject event) {
        DynamicObject dynamicObject;
        super.afterBindData(event);
        String saveMidTableData = this.baseConfigDomainService.queryBaseConfigValueByNumber("is.save.midtable.data");
        if ("0".equals(saveMidTableData)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"midentitynumber"});
        }
        if ((dynamicObject = this.getModel().getDataEntity().getDynamicObject("entityobj")) != null && this.checkViewStatus().booleanValue()) {
            this.setTreeEntryEntity(dynamicObject, Boolean.TRUE);
        }
        DynamicObjectCollection treeEntry = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("treeentryentity");
        int rowIndex = 0;
        for (DynamicObject dyn : treeEntry) {
            if (!dyn.getBoolean("isfield")) {
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"defaultvalue"});
            }
            ++rowIndex;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if ("save".equals(args.getOperateKey())) {
            this.doAfterSave();
        }
    }

    private void doAfterSave() {
        this.generate();
        this.publishApi();
    }

    private void publishApi() {
        String bizEntity = this.getView().getModel().getDataEntity().getString("entityobj.id");
        ArrayList bizEntityList = Lists.newArrayListWithExpectedSize((int)1);
        bizEntityList.add(bizEntity);
        this.sourceDomainService.publishOpenApiByEntityNumber((Collection)bizEntityList);
    }

    private void generate() {
        long id = this.getModel().getDataEntity().getLong("id");
        Map metadataGenParamMap = this.configService.batchBuildGenParam((Set)ImmutableSet.of((Object)id));
        for (Map.Entry entry : metadataGenParamMap.entrySet()) {
            ((MetadataGenParam)entry.getValue()).setMetadataOperateTypeEnum(MetadataOperateTypeEnum.PAGE_SAVE);
            MetadataGenResult result = this.dynamicMetadataApplicationService.generate((MetadataGenParam)entry.getValue());
            if (result.isSuccess()) continue;
            String msg = this.RES_GEN_ERROR + String.join((CharSequence)",", result.getMsgList());
            this.getView().showMessage(msg);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String propertyName = args.getProperty().getName();
        int row = args.getChangeSet()[0].getRowIndex();
        if ("referenceprop".equals(propertyName)) {
            this.getView().getModel().setValue("defaultvalue", (Object)"", row);
        } else if ("isintegrationfield".equals(propertyName) && !this.cancelMustInput(row)) {
            this.getView().getModel().setValue("defaultvalue", (Object)"", row);
        }
    }

    @Override
    protected Boolean isCancelConfigTplMustField(int row) {
        boolean mustInput = (Boolean)this.getModel().getValue("ismustinput", row);
        if (mustInput) {
            return Boolean.FALSE;
        }
        boolean cancelMustInput = this.cancelMustInput(row);
        if (cancelMustInput) {
            OrmLocaleValue fieldName = (OrmLocaleValue)this.getModel().getValue("entityname", row);
            String fieldNameStr = fieldName.getLocaleValue();
            if (!StringUtils.isEmpty((String)fieldNameStr) && fieldNameStr.endsWith("*")) {
                fieldNameStr = fieldNameStr.substring(0, fieldNameStr.length() - 1);
            }
            this.getView().showErrorNotification(String.format(Locale.ROOT, this.CANCEL_MUST_INPUT_FIELD_ERROR, fieldNameStr));
            this.getModel().setValue("ismustinput", (Object)Boolean.TRUE, row);
        }
        return cancelMustInput;
    }

    private boolean cancelMustInput(int row) {
        String fieldAlias = (String)this.getModel().getValue("numberalias", row);
        DynamicObject entityObjDyn = this.getModel().getDataEntity().getDynamicObject("entityobj");
        String entityId = entityObjDyn.getString("id");
        return this.configService.isConfigTplMustInput(entityId, fieldAlias);
    }

    private int getSelectRow() {
        int[] selectRows = ((TreeEntryGrid)this.getView().getControl("treeentryentity")).getSelectRows();
        return selectRows[0];
    }

    public void click(EventObject evt) {
        super.click(evt);
        int row = this.getSelectRow();
        if (((Boolean)this.getView().getModel().getValue("isbasedata", row)).booleanValue()) {
            IBasedataField baseDataFieldProp = this.getBaseDataFieldProp(row);
            if (baseDataFieldProp == null) {
                return;
            }
            this.showF7(baseDataFieldProp, this.getPkIdByDefaultValue(baseDataFieldProp.getBaseEntityId(), row));
        } else {
            this.showDefaultValue(row);
        }
    }

    private void showF7(IBasedataField property, Object[] selectPkIds) {
        ListShowParameter listShowParameter = this.buildF7ShowParameter(property.getBaseEntityId(), property instanceof MulBasedataProp, selectPkIds, new CloseCallBack((IFormPlugin)this, "defaultvalueF7"));
        listShowParameter.setHasRight(true);
        StyleCss style = new StyleCss();
        style.setWidth("800");
        style.setHeight("600");
        listShowParameter.getOpenStyle().setInlineStyleCss(style);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void showDefaultValue(int row) {
        String fieldNumber = (String)this.getModel().getValue("entitynumber", row);
        DynamicObject entryDyn = (DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("treeentryentity").get(row);
        DynamicObject entityDyn = this.getEntityDyn(entryDyn);
        String entityNumber = entityDyn.getString("entitynumber");
        FormShowParameter showParameter = this.buildDefaultValueShowParameter(entityNumber, fieldNumber, new CloseCallBack((IFormPlugin)this, "defaultvalue"));
        this.getView().showForm(showParameter);
    }

    private FormShowParameter buildDefaultValueShowParameter(String entityNumber, String fieldNumber, CloseCallBack callBack) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hrdi_defaultvalue");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(callBack);
        showParameter.setShowTitle(true);
        showParameter.setCustomParam("entityNumber", (Object)entityNumber);
        showParameter.setCustomParam("fieldNumber", (Object)fieldNumber);
        return showParameter;
    }

    private ListShowParameter buildF7ShowParameter(String billFormId, boolean multiSelect, Object[] selectPkIds, CloseCallBack callBack) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setFormId("bos_listf7");
        listShowParameter.setBillFormId(billFormId);
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss inlineStyleCss = new StyleCss();
        inlineStyleCss.setHeight("960");
        inlineStyleCss.setWidth("580");
        listShowParameter.getOpenStyle().setInlineStyleCss(inlineStyleCss);
        listShowParameter.setMultiSelect(false);
        listShowParameter.setLookUp(true);
        listShowParameter.setShowApproved(true);
        listShowParameter.setShowUsed(true);
        listShowParameter.setCloseCallBack(callBack);
        listShowParameter.setShowTitle(false);
        listShowParameter.setShowFilter(false);
        listShowParameter.setMultiSelect(multiSelect);
        if (selectPkIds != null) {
            listShowParameter.setSelectedRows(selectPkIds);
        }
        if (this.hisEntity(billFormId)) {
            ListFilterParameter listFilterParameter = listShowParameter.getListFilterParameter();
            if (listFilterParameter == null) {
                listFilterParameter = new ListFilterParameter();
            }
            listFilterParameter.setFilter(QFilterConstants.Q_CURRENTVERSION);
            listFilterParameter.setFilter(QFilterConstants.Q_HISDATASTATUS);
            listShowParameter.setListFilterParameter(listFilterParameter);
        }
        return listShowParameter;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOp = (FormOperate)args.getSource();
        String operateKey = formOp.getOperateKey();
        if ("showlog".equals(operateKey)) {
            args.setCancel(true);
            if (HrdiPermHelper.hasViewPermission("hrdi_midtableconfig")) {
                this.openMidTableGenLog();
            }
        }
    }

    private void openMidTableGenLog() {
        if (Objects.equals(this.getModel().getValue("id"), 0L)) {
            this.getView().showErrorNotification(this.RES_SAVE_TEMP_FIRST);
            return;
        }
        ListShowParameter lsp = new ListShowParameter();
        lsp.setFormId(FormMetadataCache.getListFormConfig((String)"hrdi_midtablecreatelog_ly").getF7ListFormId());
        lsp.setBillFormId("hrdi_midtablecreatelog_ly");
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        listFilterParameter.setFilter(this.getCusFilter());
        lsp.setListFilterParameter(listFilterParameter);
        lsp.getCustomParams().put("templateId", this.getModel().getValue("id"));
        StyleCss css = new StyleCss();
        css.setWidth("900px");
        css.setHeight("620px");
        lsp.getOpenStyle().setInlineStyleCss(css);
        lsp.getOpenStyle().setClientShowType(ShowType.Modal);
        this.getView().showForm((FormShowParameter)lsp);
    }

    private QFilter getCusFilter() {
        return new QFilter("objnumber", "=", this.getModel().getValue("midentitynumber"));
    }

    private boolean hisEntity(String baseEntityId) {
        String entityTpl = HisModelController.getInstance().entityInhRelation(baseEntityId);
        return !EnumEntityTpl.COMMON_TPL.getNumber().equals(entityTpl);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object returnDataObj = closedCallBackEvent.getReturnData();
        if (returnDataObj == null) {
            return;
        }
        if ("defaultvalueF7".equals(closedCallBackEvent.getActionId())) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)returnDataObj;
            ArrayList pkValueList = Lists.newArrayListWithExpectedSize((int)returnData.size());
            returnData.forEach(rowData -> pkValueList.add(rowData.getPrimaryKeyValue()));
            int row = this.getSelectRow();
            this.getView().getModel().setValue("defaultvalue", (Object)this.getDefaultValueByPkId(pkValueList, row), row);
            this.getView().updateView("defaultvalue", row);
        } else if ("defaultvalue".equals(closedCallBackEvent.getActionId())) {
            this.getView().getModel().setValue("defaultvalue", returnDataObj);
        }
    }

    private String getDefaultValueByPkId(List<Object> pkValueList, int row) {
        IBasedataField baseDataFieldProp = this.getBaseDataFieldProp(row);
        String refProp = (String)this.getView().getModel().getValue("referenceprop", row);
        Map dynMap = this.iBaseCommonDomainService.queryDataByIdList(baseDataFieldProp.getBaseEntityId(), refProp, pkValueList);
        List valueList = dynMap.values().stream().map(dyn -> dyn.getString(refProp)).collect(Collectors.toList());
        return String.join((CharSequence)",", valueList);
    }

    private Object[] getPkIdByDefaultValue(String entityId, int row) {
        String defaultValue = (String)this.getView().getModel().getValue("defaultvalue", row);
        if (StringUtils.isEmpty((String)defaultValue)) {
            return null;
        }
        String[] defaultValues = defaultValue.split(",");
        String refProp = (String)this.getView().getModel().getValue("referenceprop", row);
        QFilter fitler = new QFilter(refProp, "in", Arrays.asList(defaultValues));
        Map idDynMap = this.iBaseCommonDomainService.queryByFilters(entityId, "id", new QFilter[]{fitler});
        return idDynMap.keySet().toArray(new Object[0]);
    }

    protected IBasedataField getBaseDataFieldProp(int row) {
        DynamicObject entryDyn = (DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("treeentryentity").get(row);
        DynamicObject pDyn = this.getEntityDyn(entryDyn);
        String entityNumber = pDyn.getString("entitynumber");
        MainEntityType mainEntityType = MetadataUtils.getMainEntityType((String)entityNumber);
        IDataEntityProperty property = (IDataEntityProperty)mainEntityType.getAllFields().get(entryDyn.getString("entitynumber"));
        if (property instanceof MulBasedataProp || property instanceof BasedataProp) {
            return (IBasedataField)property;
        }
        return null;
    }

    private DynamicObject getEntityDyn(DynamicObject entryDyn) {
        long pid;
        if (CollectionUtils.isEmpty((Map)this.treeEntryMap)) {
            this.initTreeEntryMap();
        }
        if ((pid = entryDyn.getLong("pid")) > 0L) {
            DynamicObject pDyn = (DynamicObject)this.treeEntryMap.get(pid);
            return this.getEntityDyn(pDyn);
        }
        return entryDyn;
    }
}

