/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.formplugin.web.middle.form;

import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.adaptor.IIntSceneRuleDomainService;
import kd.hdtc.hrdi.business.domain.middle.IMidTableConfigDomainService;
import kd.hdtc.hrdi.business.domain.middle.IMidTableConfigTplDomainService;
import kd.hdtc.hrdi.business.domain.middle.bo.MidTableConfigBo;
import kd.hdtc.hrdi.formplugin.web.common.form.AbstractBaseDataEditPlugin;

public class MidTableConfigTplEditPlugin
extends AbstractBaseDataEditPlugin {
    private static final Log log = LogFactory.getLog(MidTableConfigTplEditPlugin.class);
    protected final IMidTableConfigDomainService configService = (IMidTableConfigDomainService)ServiceFactory.getService(IMidTableConfigDomainService.class);
    protected final IMidTableConfigTplDomainService configTplDomainService = (IMidTableConfigTplDomainService)ServiceFactory.getService(IMidTableConfigTplDomainService.class);
    private final IIntSceneRuleDomainService sceneRuleService = (IIntSceneRuleDomainService)ServiceFactory.getService(IIntSceneRuleDomainService.class);
    private final String RES_REMOVE_ERROR = ResManager.loadKDString((String)"\u79fb\u52a8\u5c5e\u6027\u65e0\u6cd5\u66f4\u6539\u5185\u7801\u5c5e\u6027\u7684\u4f4d\u7f6e\u3002", (String)"MidTableConfigTplEditPlugin_0", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]);
    protected final String CANCEL_SCENE_FIELD_ERROR = ResManager.loadKDString((String)"%1$s\u4e3a\u5b9e\u4f53\u5bf9\u8c61\u201c%2$s\u201d\u96c6\u6210\u5fc5\u987b\u7684\u5b57\u6bb5\u3002", (String)"MidTableConfigTplEditPlugin_1", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]);
    protected final String CANCEL_MUST_INPUT_FIELD_ERROR = ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%s\u201d\u4e3a\u4ea7\u54c1\u5fc5\u5f55\u5b57\u6bb5\uff0c\u4e0d\u53ef\u66f4\u6539\u4e3a\u975e\u5fc5\u5f55\u5b57\u6bb5\u3002", (String)"MidTableConfigTplEditPlugin_3", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]);
    private final String ENTITY_CHANGE_TIP = ResManager.loadKDString((String)"\u5f53\u524d\u5b9e\u4f53\u5bf9\u8c61\u5df2\u88ab\u4fee\u6539\uff0c\u5efa\u8bae\u9002\u5f53\u8c03\u6574\u540e\u4fdd\u5b58\u3002", (String)"MidTableConfigTplEditPlugin_2", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]);
    protected Map<Long, DynamicObject> treeEntryMap = null;

    public void beforeClosed(BeforeClosedEvent event) {
        super.beforeClosed(event);
        this.setFieldBizChanged();
    }

    private void setFieldBizChanged() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DataEntityState dataEntityState = dataEntity.getDataEntityState();
        DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
        IDataEntityProperty fieldPorp = (IDataEntityProperty)properties.get((Object)"bizapp");
        dataEntityState.setBizChanged(fieldPorp.getOrdinal(), false);
        IDataEntityProperty fieldIdProp = (IDataEntityProperty)properties.get((Object)"bizapp_id");
        dataEntityState.setBizChanged(fieldIdProp.getOrdinal(), false);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propertyName = args.getProperty().getName();
        IDataModel model = this.getModel();
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        int row = args.getChangeSet()[0].getRowIndex();
        switch (propertyName) {
            case "entityobj": {
                this.chooseProperties(args, model);
                this.changeTableName(model);
                break;
            }
            case "isintegrationfield": {
                if (this.isCancelIntSceneMustField(row).booleanValue()) break;
                this.dealIntegrationAndMustData(model, proxy, propertyName, row);
                break;
            }
            case "ismustinput": {
                if (this.isCancelConfigTplMustField(row).booleanValue()) break;
                this.dealIntegrationAndMustData(model, proxy, propertyName, row);
                break;
            }
        }
    }

    protected Boolean isCancelConfigTplMustField(int row) {
        return Boolean.FALSE;
    }

    private Boolean isCancelIntSceneMustField(int row) {
        boolean isIntegration = (Boolean)this.getModel().getValue("isintegrationfield", row);
        if (isIntegration) {
            return Boolean.FALSE;
        }
        String field = this.getField(row);
        if (StringUtils.isEmpty((String)field)) {
            return Boolean.FALSE;
        }
        String entityId = this.getModel().getDataEntity().getString("entityobj.id");
        Boolean existIntScene = this.sceneRuleService.isExistIntScene(entityId, field);
        if (existIntScene.booleanValue()) {
            OrmLocaleValue fieldName = (OrmLocaleValue)this.getModel().getValue("entityname", row);
            String entityName = this.getModel().getDataEntity().getString("entityobj.name");
            String fieldNameStr = fieldName.getLocaleValue();
            if (!StringUtils.isEmpty((String)fieldNameStr) && fieldNameStr.endsWith("*")) {
                fieldNameStr = fieldNameStr.substring(0, fieldNameStr.length() - 1);
            }
            this.getView().showErrorNotification(String.format(Locale.ROOT, this.CANCEL_SCENE_FIELD_ERROR, fieldNameStr, entityName));
            this.getModel().setValue("isintegrationfield", (Object)Boolean.TRUE, row);
        }
        return existIntScene;
    }

    protected DynamicObject getEntityDyn(int row) {
        Long pid;
        DynamicObject pDyn;
        if (CollectionUtils.isEmpty(this.treeEntryMap)) {
            this.initTreeEntryMap();
        }
        if ((pDyn = this.treeEntryMap.get(pid = (Long)this.getModel().getValue("pid", row))) == null) {
            return null;
        }
        if ("billhead".equals(pDyn.getString("entitynumber"))) {
            pDyn = this.treeEntryMap.get(pDyn.getLong("pid"));
        }
        return pDyn;
    }

    private String getField(int row) {
        if (CollectionUtils.isEmpty(this.treeEntryMap)) {
            this.initTreeEntryMap();
        }
        String field = (String)this.getModel().getValue("entitynumber", row);
        Long pid = (Long)this.getModel().getValue("pid", row);
        DynamicObject pDyn = this.treeEntryMap.get(pid);
        if (pDyn == null) {
            return null;
        }
        if ("billhead".equals(pDyn.getString("entitynumber"))) {
            pDyn = this.treeEntryMap.get(pDyn.getLong("pid"));
        }
        String entity = pDyn.getString("entitynumber");
        return entity + '.' + field;
    }

    protected void initTreeEntryMap() {
        DynamicObjectCollection treeEntryCols = this.getModel().getDataEntity(true).getDynamicObjectCollection("treeentryentity");
        this.treeEntryMap = treeEntryCols.stream().collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn, (o1, o2) -> o1));
    }

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        this.setValidateExist((List<DynamicObject>)((DynamicObjectCollection)this.getModel().getDataEntity().get("treeentryentity")));
        this.setTreeEntryEntityStatus();
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"numberalias"});
    }

    private void setValidateExist(List<DynamicObject> dynamicObjectList) {
        for (DynamicObject entryDyn : dynamicObjectList) {
            boolean flag = entryDyn.getBoolean("isvalidateexist") && (!entryDyn.getBoolean("isbasedata") || !entryDyn.getBoolean("isintegrationfield"));
            if (!flag) continue;
            entryDyn.set("isvalidateexist", (Object)Boolean.FALSE);
        }
        this.getModel().setDataChanged(false);
    }

    protected Boolean checkViewStatus() {
        return !OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus());
    }

    public void registerListener(EventObject event) {
        super.registerListener(event);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        BasedataEdit entityObjEdit = (BasedataEdit)this.getControl("entityobj");
        entityObjEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit initEntityObjEdit = (BasedataEdit)this.getControl("initentityobject");
        initEntityObjEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        switch (evt.getItemKey()) {
            case "entryup": 
            case "entrydown": {
                this.checkMove(evt);
                break;
            }
        }
    }

    private void checkMove(BeforeItemClickEvent evt) {
        Boolean isDownIdOrPidRow = this.isDownIdOrPidRow(evt);
        if (isDownIdOrPidRow.booleanValue()) {
            this.getView().showTipNotification(this.RES_REMOVE_ERROR);
            evt.setCancel(isDownIdOrPidRow.booleanValue());
        }
    }

    private Boolean isDownIdOrPidRow(BeforeItemClickEvent evt) {
        int[] rowsIndex;
        IDataModel model = this.getModel();
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        for (int index : rowsIndex = proxy.getEntryState("treeentryentity").getSelectedRows()) {
            String entityNumber;
            if (index < 1) {
                return Boolean.FALSE;
            }
            if ("entryup".equals(evt.getItemKey())) {
                --index;
            }
            if (!"id".equals(entityNumber = (String)model.getValue("entitynumber", index)) && !entityNumber.endsWith(".id") && !entityNumber.endsWith(".pid")) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void checkChildren(IDataModel model, String propertyName, boolean propertyValue, int row, Set<String> mustFieldSet) {
        long entryId = (Long)model.getEntryRowEntity("treeentryentity", row).get("id");
        int count = model.getEntryRowCount("treeentryentity");
        for (int i = row + 1; i < count; ++i) {
            if (entryId != (Long)model.getEntryRowEntity("treeentryentity", i).get("pid") || propertyValue == (Boolean)model.getValue(propertyName, i)) continue;
            boolean value = propertyValue;
            if (CollectionUtils.isNotEmpty(mustFieldSet)) {
                String numberAlias = (String)model.getValue("numberalias", i);
                value = mustFieldSet.contains(numberAlias);
            }
            model.setValue(propertyName, (Object)value, i);
            if (Boolean.TRUE.equals(model.getValue("isfield", i))) continue;
            this.checkChildren(model, propertyName, propertyValue, i, mustFieldSet);
        }
    }

    private void checkParent(IDataModel model, IClientViewProxy proxy, String propertyName, boolean propertyValue, int row) {
        long parentEntryId = (Long)model.getEntryRowEntity("treeentryentity", row).get("pid");
        for (int i = row - 1; i >= 0; --i) {
            boolean flag;
            long entryId = (Long)model.getEntryRowEntity("treeentryentity", i).get("id");
            if (parentEntryId != entryId || propertyValue == (Boolean)model.getValue(propertyName, i)) continue;
            int totalCount = 0;
            int checkCount = 0;
            int count = model.getEntryRowCount("treeentryentity");
            for (int j = i + 1; j < count; ++j) {
                if (entryId != (Long)model.getEntryRowEntity("treeentryentity", j).get("pid")) continue;
                ++totalCount;
                if (!Boolean.TRUE.equals(model.getValue(propertyName, j))) continue;
                ++checkCount;
            }
            boolean bl = flag = totalCount > 0 && (propertyValue && checkCount == totalCount || !propertyValue && checkCount < totalCount);
            if (!flag) break;
            model.beginInit();
            model.setValue(propertyName, (Object)propertyValue, i);
            model.endInit();
            this.update(proxy, propertyName, propertyValue, i);
            this.checkParent(model, proxy, propertyName, propertyValue, i);
        }
    }

    private void update(IClientViewProxy proxy, String propertyName, boolean propertyValue, int row) {
        if (proxy == null) {
            return;
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
        dataMap.put("k", "treeentryentity");
        HashMap<String, Object> state = new HashMap<String, Object>(16);
        state.put("r", row);
        state.put("v", propertyValue);
        state.put("k", propertyName);
        dataMap.put("fieldstates", Collections.singletonList(state));
        proxy.addAction("u", dataMap);
    }

    private void dealIntegrationAndMustData(IDataModel model, IClientViewProxy proxy, String propertyName, int row) {
        if (StringUtils.equals((String)"isintegrationfield", (String)propertyName)) {
            this.dealDataByIsIntegration(model, row);
        } else if (StringUtils.equals((String)"ismustinput", (String)propertyName)) {
            this.dealDataByMustInput(model, row);
        }
        boolean propertyValue = (Boolean)model.getValue(propertyName, row);
        if (!Boolean.TRUE.equals(model.getValue("isfield", row))) {
            Set<String> mustFieldSet = new HashSet<String>(16);
            if (!propertyValue) {
                String entityObj = model.getDataEntity().getString("entityobj.id");
                mustFieldSet = this.configTplDomainService.getMustFieldsByBizNumber(entityObj);
            }
            this.checkChildren(model, propertyName, propertyValue, row, mustFieldSet);
        }
        this.checkParent(model, proxy, propertyName, propertyValue, row);
    }

    private void dealDataByMustInput(IDataModel model, int row) {
        if (((Boolean)model.getValue("ismustinput", row)).booleanValue() && !((Boolean)model.getValue("isintegrationfield", row)).booleanValue()) {
            model.setValue("isintegrationfield", (Object)Boolean.TRUE, row);
        }
    }

    private void dealDataByIsIntegration(IDataModel model, int row) {
        boolean isIntegration = (Boolean)model.getValue("isintegrationfield", row);
        if (((Boolean)model.getValue("isbasedata", row)).booleanValue()) {
            model.setValue("isvalidateexist", (Object)isIntegration, row);
        }
        if (!isIntegration) {
            model.setValue("ismustinput", (Object)Boolean.FALSE, row);
        }
    }

    private void chooseProperties(PropertyChangedArgs args, IDataModel model) {
        DynamicObject bizObj = (DynamicObject)args.getChangeSet()[0].getNewValue();
        if (bizObj != null) {
            this.setTreeEntryEntity(bizObj, Boolean.FALSE);
            this.setTreeEntryEntityStatus();
            model.setValue("bizapp", (Object)bizObj.getDynamicObject("bizappid"));
        } else {
            model.deleteEntryData("treeentryentity");
        }
    }

    private void setTreeEntryEntityStatus() {
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl("treeentryentity");
        grid.setCollapse(false);
        this.getView().updateView("treeentryentity");
    }

    protected void setTreeEntryEntity(DynamicObject bizObj, Boolean bindFlag) {
        DynamicObjectType dynamicObjectType = this.getModel().getEntryEntity("treeentryentity").getDynamicObjectType();
        MidTableConfigBo configBo = this.createMidTableConfigBo(bizObj, dynamicObjectType);
        this.configService.buildFieldsTreeByEntity(configBo);
        this.setValidateExist(configBo.getDynamicObjectList());
        if (bindFlag.booleanValue()) {
            DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity().getDynamicObjectCollection("treeentryentity");
            if (this.checkChanged(dynamicObjectCollection, configBo.getDynamicObjectList()).booleanValue()) {
                List allDynList = this.configService.buildEntryByOldValue(dynamicObjectCollection, configBo);
                this.getModel().getDataEntity(true).set("treeentryentity", (Object)new DynamicObjectCollection(dynamicObjectType, (Object)this.getModel().getDataEntity(), allDynList));
                this.getView().showMessage(this.ENTITY_CHANGE_TIP);
            }
        } else {
            this.getModel().getDataEntity(true).set("treeentryentity", (Object)new DynamicObjectCollection(dynamicObjectType, (Object)this.getModel().getDataEntity(), configBo.getDynamicObjectList()));
        }
        this.getView().updateView("treeentryentity");
    }

    protected MidTableConfigBo createMidTableConfigBo(DynamicObject bizObj, DynamicObjectType dynamicObjectType) {
        String entityId = bizObj.getString(((BasedataEntityType)bizObj.getDataEntityType()).getNumberProperty());
        MidTableConfigBo configBo = new MidTableConfigBo();
        configBo.setBizEntity(entityId);
        configBo.setPage("hrdi_midtableconfigtpl");
        configBo.setPageEntry("T_HRDI_MIDTABLETPLENTRY");
        configBo.setDynamicObjectType(dynamicObjectType);
        return configBo;
    }

    private Boolean checkChanged(DynamicObjectCollection dynamicObjectCollection, List<DynamicObject> newDynamicObjectCollection) {
        if (dynamicObjectCollection.size() != newDynamicObjectCollection.size()) {
            log.error("midtable data change size: old midtbale Size:{}, new midtable Size:{}", (Object)dynamicObjectCollection.size(), (Object)newDynamicObjectCollection.size());
        }
        return dynamicObjectCollection.size() != newDynamicObjectCollection.size() || this.checkFieldChanged(dynamicObjectCollection, newDynamicObjectCollection) != false;
    }

    private Boolean checkFieldChanged(DynamicObjectCollection dynCollection, List<DynamicObject> newDynCollection) {
        int size = dynCollection.size() + newDynCollection.size();
        HashMap map = new HashMap(size);
        dynCollection.forEach(dyc -> this.setDynamicObject(map, (DynamicObject)dyc, Boolean.TRUE));
        newDynCollection.forEach(dyc -> this.setDynamicObject(map, (DynamicObject)dyc, Boolean.FALSE));
        if (map.entrySet().stream().anyMatch(Map.Entry::getValue)) {
            log.error("midtable different field value:{}", (Object)map.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.joining(",")));
        }
        return map.entrySet().stream().anyMatch(Map.Entry::getValue);
    }

    private void setDynamicObject(Map<String, Boolean> map, DynamicObject dyc, Boolean flag) {
        String key = dyc.getString("entitynumber");
        map.put(key, flag);
    }

    private void changeTableName(IDataModel model) {
        if (model.getValue("entityobj") != null) {
            DynamicObject entityObj = this.getModel().getDataEntity().getDynamicObject("entityobj");
            String tableName = this.configService.getMidTableName(entityObj.getString("number"));
            this.getModel().setValue("midentitynumber", (Object)tableName);
        } else {
            this.getModel().setValue("midentitynumber", null);
        }
    }
}

