/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.formplugin.web.middle.form;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.DefaultEntityOperate;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.LargeTextProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.hdtc.hrdbs.common.util.ConvertUtils;
import kd.hdtc.hrdbs.common.util.DateTimeUtils;
import kd.hdtc.hrdbs.common.util.ObjectUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hdtc.hrdbs.formplugin.web.HDTCDataBaseEdit;
import kd.hdtc.hrdi.common.middle.constants.MidTableDefaultValueConstants;

public class MidTableDefaultValueEditPlugin
extends HDTCDataBaseEdit {
    private final String ERROR_MSG = ResManager.loadKDString((String)"\u65e0\u6cd5\u8bbe\u7f6e\u9ed8\u8ba4\u503c\uff0c\u56e0\u4e3a\u5b9e\u4f53\u5bf9\u8c61\u6216\u5b57\u6bb5\u6807\u8bc6\u4e3a\u7a7a\u3002", (String)"MidTableDefaultValueEditPlugin_0", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]);
    private final String MAX_LEGTH_MSG = ResManager.loadKDString((String)"\u8f93\u5165\u957f\u5ea6\u8d85\u957f\uff0c\u6700\u5927\u957f\u5ea6\uff1a%1$s\u3002", (String)"MidTableDefaultValueEditPlugin_1", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]);
    private static final int LARGE_TEXT_FIELD_MAX_LENGTH = 600;

    public void afterCreateNewData(EventObject event) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        this.getPageCache().put("entityNumber", (String)showParameter.getCustomParam("entityNumber"));
        this.getPageCache().put("fieldNumber", (String)showParameter.getCustomParam("fieldNumber"));
        this.getView().setVisible(Boolean.FALSE, MidTableDefaultValueConstants.SET_DEFAULT_VALUE_FIELD_LIST.toArray(new String[0]));
    }

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        this.init();
    }

    private void init() {
        IDataEntityProperty fieldProp = this.getShowFieldProp();
        if (fieldProp == null) {
            return;
        }
        String showField = this.getShowField(fieldProp);
        FieldEdit fieldEdit = (FieldEdit)this.getControl(showField);
        fieldEdit.setCaption(fieldProp.getDisplayName());
        this.specialFieldHandle(showField, fieldProp);
    }

    private void specialFieldHandle(String fieldNumber, IDataEntityProperty fieldProp) {
        if (MidTableDefaultValueConstants.TEXT_FIELD_LIST.contains(fieldNumber)) {
            this.getPageCache().put("textLength", ConvertUtils.toString((Object)((TextProp)fieldProp).getMaxLenth()));
        } else if (StringUtils.equals((String)LargeTextProp.class.getSimpleName().toLowerCase(Locale.ROOT), (String)fieldNumber)) {
            this.getPageCache().put("textLength", ConvertUtils.toString((Object)600));
        } else if (MidTableDefaultValueConstants.COMBO_FIELD_LIST.contains(fieldNumber)) {
            List comboItemList = ((ComboProp)fieldProp).getComboItems();
            ArrayList itemList = new ArrayList(10);
            comboItemList.forEach(dy -> {
                ComboItem comboItem = new ComboItem();
                comboItem.setCaption(dy.getName());
                comboItem.setValue(dy.getValue());
                itemList.add(comboItem);
            });
            ((ComboEdit)this.getControl(fieldNumber)).setComboItems(itemList);
        }
    }

    private String getShowField(IDataEntityProperty fieldProp) {
        String showField = fieldProp.getClass().getSimpleName().toLowerCase(Locale.ROOT);
        if (fieldProp instanceof MulComboProp) {
            showField = MulComboProp.class.getSimpleName().toLowerCase(Locale.ROOT);
        } else if (fieldProp instanceof ComboProp) {
            showField = ComboProp.class.getSimpleName().toLowerCase(Locale.ROOT);
        }
        this.getPageCache().put("showField", showField);
        this.getView().setVisible(Boolean.valueOf(true), new String[]{showField});
        return showField;
    }

    private IDataEntityProperty getShowFieldProp() {
        String entityNumber = this.getPageCache().get("entityNumber");
        String fieldNumber = this.getPageCache().get("fieldNumber");
        if (StringUtils.isEmpty((String)entityNumber) || StringUtils.isEmpty((String)fieldNumber)) {
            this.getView().showErrorNotification(this.ERROR_MSG);
            return null;
        }
        Map entityPropertyMap = MetadataUtils.getMainEntityType((String)entityNumber).getAllFields();
        return (IDataEntityProperty)entityPropertyMap.get(fieldNumber);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((DefaultEntityOperate)args.getSource()).getOperateKey();
        if (StringUtils.equals((String)"btnok", (String)operateKey)) {
            String msg = this.checkTextField();
            if (StringUtils.isEmpty((String)msg)) {
                this.getView().returnDataToParent(this.getDefaultValue());
                this.getView().close();
            } else {
                this.getView().showTipNotification(msg);
            }
        }
    }

    private Object getDefaultValue() {
        String fieldNumber = this.getPageCache().get("showField");
        Object value = this.getModel().getValue(fieldNumber);
        if (ObjectUtils.isEmpty((Object)value)) {
            return null;
        }
        if (StringUtils.equals((String)DateTimeProp.class.getSimpleName().toLowerCase(Locale.ROOT), (String)fieldNumber)) {
            return DateTimeUtils.format((Date)((Date)value));
        }
        if (StringUtils.equals((String)DateProp.class.getSimpleName().toLowerCase(Locale.ROOT), (String)fieldNumber)) {
            return DateTimeUtils.format((Date)((Date)value), (String)"yyyy-MM-dd");
        }
        if (StringUtils.equals((String)MuliLangTextProp.class.getSimpleName().toLowerCase(Locale.ROOT), (String)fieldNumber)) {
            return ((ILocaleString)value).getLocaleValue();
        }
        if (StringUtils.equals((String)LargeTextProp.class.getSimpleName().toLowerCase(Locale.ROOT), (String)fieldNumber)) {
            return this.getModel().getDataEntity().getString(fieldNumber + "_tag");
        }
        return value;
    }

    private String checkTextField() {
        String showField = this.getPageCache().get("showField");
        int textLen = ConvertUtils.toInt((Object)this.getPageCache().get("textLength"));
        String msg = "";
        if (!MidTableDefaultValueConstants.CHECK_LENGTH_FIELD_LIST.contains(showField)) {
            return msg;
        }
        if ("mulilangtextfield".equals(showField)) {
            Map.Entry entry;
            Iterator iterator = ((OrmLocaleValue)this.getModel().getValue(showField)).entrySet().iterator();
            while (iterator.hasNext() && !StringUtils.isNotEmpty((String)(msg = this.checkLength((String)(entry = (Map.Entry)iterator.next()).getValue(), textLen)))) {
            }
        } else {
            String value = ConvertUtils.toString((Object)this.getModel().getValue(showField));
            msg = this.checkLength(value, textLen);
        }
        return msg;
    }

    private String checkLength(String value, int maxLen) {
        int length;
        int n = length = StringUtils.isEmpty((String)value) ? 0 : value.length();
        if (maxLen < length) {
            return String.format(Locale.ROOT, this.MAX_LEGTH_MSG, maxLen);
        }
        return "";
    }
}

