/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.formplugin.web.middle.list;

import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.param.AppParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListColumn;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.hdtc.hrdbs.formplugin.web.HDTCDataBaseList;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class MidModifyLogListPlugin
extends HDTCDataBaseList {
    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        this.setButtonStatus();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (StringUtils.equals((CharSequence)"logview", (CharSequence)operateKey)) {
            this.viewLog(listShowParameter.getBillFormId(), 0L);
        } else if (StringUtils.equals((CharSequence)"viewonelog", (CharSequence)operateKey)) {
            ListSelectedRowCollection listSelectedData = args.getListSelectedData();
            ListSelectedRow listSelectedRow = listSelectedData.get(0);
            long primaryKeyValue = (Long)listSelectedRow.getPrimaryKeyValue();
            this.viewLog(listShowParameter.getBillFormId(), primaryKeyValue);
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        List columnList = args.getListColumns();
        if (!this.getRecordChanged()) {
            Iterator it = columnList.iterator();
            while (it.hasNext()) {
                IListColumn column = (IListColumn)it.next();
                if (!StringUtils.equals((CharSequence)column.getListFieldKey(), (CharSequence)"viewlogap")) continue;
                it.remove();
            }
        }
    }

    private void viewLog(String billFormId, long primaryKeyValue) {
        ListShowParameter lsp = new ListShowParameter();
        lsp.setFormId("bos_list");
        lsp.setBillFormId("hrdi_midmodifylog");
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        QFilter bizObj = new QFilter("bizobj", "=", (Object)billFormId);
        if (primaryKeyValue != 0L) {
            bizObj.and(new QFilter("modifybillid", "like", (Object)(primaryKeyValue + "%")));
        }
        listFilterParameter.setFilter(bizObj);
        lsp.setListFilterParameter(listFilterParameter);
        FormShowParameter listShowParameter = this.getView().getFormShowParameter();
        lsp.setCustomParam("caption", (Object)listShowParameter.getCaption());
        lsp.setCustomParam("appId", (Object)listShowParameter.getAppId());
        lsp.setCustomParam("formId", (Object)((ListShowParameter)listShowParameter).getBillFormId());
        lsp.setCustomParam("tab", (Object)"1");
        lsp.setCustomParam("pkid", (Object)primaryKeyValue);
        lsp.setHasRight(true);
        String pageId = this.getView().getPageId() + "_" + primaryKeyValue;
        lsp.setPageId(pageId);
        lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)lsp);
    }

    private boolean getRecordChanged() {
        String isOpen;
        ListShowParameter listShowParameter;
        Map params;
        Map<String, Object> systemParam = this.getConfigParams();
        boolean isRecordChange = false;
        if (!Objects.isNull(systemParam.get("changecheck"))) {
            isRecordChange = (Boolean)systemParam.get("changecheck");
        }
        if (!CollectionUtils.isEmpty((Map)(params = (Map)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hbss", (String)"IHBSSService", (String)"getParamByEntity", (Object[])new Object[]{(listShowParameter = (ListShowParameter)this.getView().getFormShowParameter()).getBillFormId()}))) && StringUtils.equals((CharSequence)(isOpen = (String)params.get("isopen")), (CharSequence)"1")) {
            isRecordChange = (Boolean)params.get("changecheck");
        }
        return isRecordChange;
    }

    private Map<String, Object> getConfigParams() {
        long orgId = RequestContext.get().getOrgId() == 0L ? 100000L : RequestContext.get().getOrgId();
        AppParam appParam = new AppParam("XYRL3+A8Z+Z", Long.valueOf(orgId));
        return SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
    }

    private void setButtonStatus() {
        if (this.getRecordChanged()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"log"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"log"});
        }
    }
}

