/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.formplugin.web.middle.list;

import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.OperationResultUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.formplugin.web.HDTCDataBaseList;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.common.IBaseCommonDomainService;
import kd.hdtc.hrdi.business.domain.intgovern.IIntSourceDomainService;
import kd.hdtc.hrdi.common.intgovern.constants.IntSourceConstants;

public class MidTemplateListPlugin
extends HDTCDataBaseList {
    private final IIntSourceDomainService iIntSourceDomainService = (IIntSourceDomainService)ServiceFactory.getService(IIntSourceDomainService.class);
    private final IBaseCommonDomainService iBaseCommonDomainService = (IBaseCommonDomainService)ServiceFactory.getService(IBaseCommonDomainService.class);

    public void setFilter(SetFilterEvent setFilterEvent) {
        setFilterEvent.setOrderBy("id desc");
        super.setFilter(setFilterEvent);
    }

    public void registerListener(EventObject eventObject) {
        this.addItemClickListeners(new String[]{"batch_modify"});
        super.registerListener(eventObject);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs beforeDoOperationEventArgs) {
        ListSelectedRowCollection listSelectedData;
        super.beforeDoOperation(beforeDoOperationEventArgs);
        String operateKey = ((FormOperate)beforeDoOperationEventArgs.getSource()).getOperateKey();
        boolean checkPerm = this.checkPerm(operateKey, beforeDoOperationEventArgs);
        if (checkPerm && !CollectionUtils.isEmpty((Collection)(listSelectedData = beforeDoOperationEventArgs.getListSelectedData()))) {
            Object[] primaryKeyValues = listSelectedData.getPrimaryKeyValues();
            switch (operateKey) {
                case "batch_modify": {
                    this.openBatchModify(primaryKeyValues, ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId());
                    break;
                }
                case "viewintlog": {
                    ListSelectedRow listSelectedRow = listSelectedData.get(0);
                    long primaryKeyValue = (Long)listSelectedRow.getPrimaryKeyValue();
                    this.viewIntLog(primaryKeyValue);
                    break;
                }
            }
        }
    }

    private boolean checkPerm(String operateKey, BeforeDoOperationEventArgs beforeDoOperationEventArgs) {
        boolean hasSpecificPerm;
        long userId = RequestContext.get().getCurrUserId();
        String permItemId = (String)IntSourceConstants.OPERATE_KEY_PERM_ID_MAP.get(operateKey);
        if (StringUtils.isNotEmpty((String)permItemId) && !(hasSpecificPerm = PermissionServiceHelper.hasSpecificPerm((long)userId, (String)"hrdi_intsource", (String)permItemId))) {
            DynamicObject perm = this.iBaseCommonDomainService.queryOneById("perm_permitem", "name", (Object)permItemId);
            String permName = perm == null ? "" : perm.getString("name");
            this.getView().showErrorNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff0c\u60a8\u6ca1\u6709\u201cHR\u96c6\u6210\u8d44\u6e90\u201d\u7684\u201c%s\u201d\u6743\u9650\u3002", (String)"MidTemplateFormPlugin_0", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]), permName));
            beforeDoOperationEventArgs.setCancel(true);
            return false;
        }
        return true;
    }

    private void viewIntLog(long primaryKeyValue) {
        String formId = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
        Map middleDataMap = this.iBaseCommonDomainService.queryByIdList(formId, "hrdibatchnumber", Collections.singletonList(primaryKeyValue));
        if (CollectionUtils.isNotEmpty((Map)middleDataMap)) {
            String batchNumber = ((DynamicObject)middleDataMap.get(primaryKeyValue)).getString("hrdibatchnumber");
            ListShowParameter lsp = new ListShowParameter();
            lsp.setFormId("bos_list");
            lsp.setBillFormId("hrdi_intlog");
            lsp.setHasRight(true);
            lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            String pageId = this.getView().getPageId() + "_" + primaryKeyValue + "-" + "hrdi_intlog";
            lsp.setPageId(pageId);
            Object[] intSources = this.iIntSourceDomainService.queryIntSourceByMidEntityNumbers(Collections.singletonList(formId));
            if (ArrayUtils.isNotEmpty((Object[])intSources)) {
                String intSourceName = intSources[0].getString("name");
                String title = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5411\u5185\u96c6\u6210\u65e5\u5fd7\u5217\u8868", (String)"IntSourceListPlugin_6", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]), intSourceName);
                lsp.setCaption(title);
                QFilter entityObjIdFilter = new QFilter("intsource", "=", (Object)intSources[0].getLong("id"));
                QFilter batchNumberFilter = new QFilter("batchnumber", "=", (Object)batchNumber);
                lsp.getListFilterParameter().setFilter(entityObjIdFilter);
                lsp.getListFilterParameter().setFilter(batchNumberFilter);
                this.getView().showForm((FormShowParameter)lsp);
            }
        }
    }

    private void openBatchModify(Object[] primaryKeyValues, String dataFormId) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("hrdi_midbatchmodify");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam("primaryKeys", (Object)primaryKeyValues);
        fsp.setCustomParam("dataFormId", (Object)dataFormId);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "batch_modify_action_id"));
        fsp.setHasRight(true);
        this.getView().showForm(fsp);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (StringUtils.equals((String)"retry", (String)operateKey) && operationResult != null && operationResult.isSuccess()) {
            List successPkIds = operationResult.getSuccessPkIds();
            this.showProgressForm(successPkIds);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("batch_modify_action_id".equals(closedCallBackEvent.getActionId())) {
            FormShowParameter parameters;
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData != null && (parameters = OperationResultUtils.getShowOperationResultPageParameter((String)returnData.toString())) != null) {
                this.getView().showForm(parameters);
            }
            this.getView().invokeOperation("refresh");
        }
    }

    private void showProgressForm(List<Object> successPkIds) {
        FormShowParameter showParameter = new FormShowParameter();
        ListView listView = (ListView)this.getView();
        showParameter.setFormId("hrdi_midtableprogress");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("intMidIds", successPkIds);
        showParameter.setCustomParam("midTableNumber", (Object)listView.getBillFormId());
        this.getView().showForm(showParameter);
    }
}

