/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.formplugin.web.monitor.list;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.platform.DynamicObjectUtils;
import kd.hdtc.hrdbs.formplugin.web.HDTCDataBaseList;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.config.IHRDIBaseConfigDomainService;
import kd.hdtc.hrdi.business.domain.middle.entity.IMidTableConfigEntityService;
import kd.hdtc.hrdi.business.domain.monitor.IIntLogDomainService;
import kd.hdtc.hrdi.business.domain.monitor.IIntWarnLogDomainService;
import kd.hdtc.hrdi.business.domain.monitor.entity.IIntLogEntityService;
import kd.hdtc.hrdi.common.enums.OperateStatusEnum;

public class IntLogListPlugin
extends HDTCDataBaseList {
    private final IIntLogDomainService iIntLogDomainService = (IIntLogDomainService)ServiceFactory.getService(IIntLogDomainService.class);
    private final IIntWarnLogDomainService iIntWarnLogDomainService = (IIntWarnLogDomainService)ServiceFactory.getService(IIntWarnLogDomainService.class);
    private final IHRDIBaseConfigDomainService configDomainService = (IHRDIBaseConfigDomainService)ServiceFactory.getService(IHRDIBaseConfigDomainService.class);
    private final IMidTableConfigEntityService midTableConfigEntityService = (IMidTableConfigEntityService)ServiceFactory.getService(IMidTableConfigEntityService.class);
    private final IIntLogEntityService iIntLogEntityService = (IIntLogEntityService)ServiceFactory.getService(IIntLogEntityService.class);

    public void setFilter(SetFilterEvent event) {
        String intLogNumberStr;
        DynamicObject intWarnLog;
        QFilter parentFilter = new QFilter("parent", "!=", (Object)0L);
        String intWarnLogIdStr = (String)this.getView().getFormShowParameter().getCustomParam("intWarnLogId");
        if (StringUtils.isNotEmpty((String)intWarnLogIdStr) && (intWarnLog = this.iIntWarnLogDomainService.queryOneById(Long.valueOf(Long.parseLong(intWarnLogIdStr)))) != null && StringUtils.isNotEmpty((String)(intLogNumberStr = DynamicObjectUtils.getBigText((DynamicObject)intWarnLog, (String)"intnumber")))) {
            String[] intLogNumbers = intLogNumberStr.split(",");
            QFilter intLogNumberFilter = new QFilter("number", "in", (Object)intLogNumbers);
            event.getQFilters().add(intLogNumberFilter);
        }
        event.getQFilters().add(parentFilter);
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        String saveMidTableData = this.configDomainService.queryBaseConfigValueByNumber("is.save.midtable.data");
        this.getView().getPageCache().put("is.save.midtable.data", saveMidTableData);
        String showException = this.configDomainService.queryBaseConfigValueByNumber("is.show.exception.info");
        List listColumnList = args.getListColumns();
        ArrayList<IListColumn> removeListColumnList = new ArrayList<IListColumn>(16);
        for (IListColumn listColumn : listColumnList) {
            if ("viewmidtable".equals(listColumn.getListFieldKey()) && "0".equals(saveMidTableData)) {
                removeListColumnList.add(listColumn);
            }
            if (!"errorinfo".equals(listColumn.getListFieldKey()) || !"0".equals(showException)) continue;
            removeListColumnList.add(listColumn);
        }
        listColumnList.removeAll(removeListColumnList);
    }

    public void beforePackageData(BeforePackageDataEvent beforePackageDataEvent) {
        DynamicObjectCollection intLogCollection = beforePackageDataEvent.getPageData();
        if (CollectionUtils.isNotEmpty((Collection)intLogCollection)) {
            ArrayList parentIdList = Lists.newArrayListWithCapacity((int)intLogCollection.size());
            intLogCollection.forEach(dy -> {
                DynamicObject parent = dy.getDynamicObject("parent");
                if (parent == null) {
                    parentIdList.add(dy.getLong("id"));
                }
            });
            Set withErrorParentIntLogIdList = this.iIntLogDomainService.queryWithErrorParentIntLogIdList((List)parentIdList);
            intLogCollection.forEach(dd -> {
                DynamicObject parent = dd.getDynamicObject("parent");
                if (parent == null && withErrorParentIntLogIdList.contains(dd.getLong("id"))) {
                    dd.set("operatestatus", (Object)OperateStatusEnum.SERVICE_EXCEPTION.getCode());
                }
            });
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs beforeDoOperationEventArgs) {
        super.beforeDoOperation(beforeDoOperationEventArgs);
        FormOperate formOperate = (FormOperate)beforeDoOperationEventArgs.getSource();
        String operateKey = formOperate.getOperateKey();
        ListSelectedRowCollection listSelectedData = beforeDoOperationEventArgs.getListSelectedData();
        if (StringUtils.equals((String)"viewmidtable", (String)operateKey)) {
            ListSelectedRow listSelectedRow = listSelectedData.get(0);
            long primaryKeyValue = (Long)listSelectedRow.getPrimaryKeyValue();
            this.viewMidTable(primaryKeyValue);
        }
    }

    private void viewMidTable(long primaryKeyValue) {
        DynamicObject midTableConfig;
        String selectProperties = String.join((CharSequence)",", "id", "batchnumber", "startnumber", "endnumber", "selectnumber_tag", "intsource");
        DynamicObject intLog = this.iIntLogEntityService.queryOne(selectProperties, (Object)primaryKeyValue);
        if (intLog != null && (midTableConfig = intLog.getDynamicObject("intsource.midtableconfig")) != null && (midTableConfig = this.midTableConfigEntityService.queryOne("number,midentitynumber", (Object)midTableConfig.getLong("id"))) != null) {
            String midTableNumber = midTableConfig.getString("midentitynumber");
            ListShowParameter lsp = new ListShowParameter();
            lsp.getListFilterParameter().setFilter(this.buildMidTableListFilter(intLog));
            lsp.setFormId("bos_list");
            lsp.setBillFormId(midTableNumber);
            lsp.setHasRight(true);
            String pageId = this.getView().getPageId() + "_" + primaryKeyValue + "-" + midTableNumber;
            lsp.setPageId(pageId);
            String title = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u4e2d\u95f4\u8868\u5217\u8868", (String)"IntSourceListPlugin_8", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]), intLog.getString("intsource.name"));
            lsp.setCaption(title);
            lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)lsp);
        }
    }

    private QFilter buildMidTableListFilter(DynamicObject intLog) {
        String selectNumber = intLog.getString("selectnumber_tag");
        QFilter numberFilter = null;
        if (StringUtils.isNotEmpty((String)selectNumber)) {
            String[] numbers = selectNumber.split(",");
            numberFilter = new QFilter("hrdinumber", "in", (Object)numbers);
        } else {
            String startNumber = intLog.getString("startnumber");
            String endNumber = intLog.getString("endnumber");
            if (StringUtils.isNotEmpty((String)startNumber) && StringUtils.isNotEmpty((String)endNumber)) {
                numberFilter = new QFilter("hrdinumber", ">=", (Object)startNumber);
                QFilter endNumberFilter = new QFilter("hrdinumber", "<=", (Object)endNumber);
                numberFilter.and(endNumberFilter);
            }
        }
        return numberFilter;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (StringUtils.equals((String)"retry", (String)operateKey) && operationResult != null && operationResult.isSuccess()) {
            List successPkIds = operationResult.getSuccessPkIds();
            this.showProgressForm(successPkIds);
        }
    }

    private void showProgressForm(List<Object> successPkIds) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hrdi_intlogretryprogress");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("intLogIds", successPkIds);
        this.getView().showForm(showParameter);
    }

    public void beforeBindData(EventObject eventObject) {
        boolean saveMidTable;
        super.beforeBindData(eventObject);
        String saveMidTableConfigValue = this.configDomainService.queryBaseConfigValueByNumber("is.save.midtable.data");
        boolean bl = saveMidTable = !"0".equals(saveMidTableConfigValue);
        if (!saveMidTable) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"retry"});
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hrdi_intlogdetail");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        BillListHyperLinkClickEvent event = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        showParameter.getCustomParams().put("id", event.getCurrentRow().getPrimaryKeyValue());
        showParameter.getCustomParams().put("log_type", "1");
        this.getView().showForm(showParameter);
    }
}

