/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.formplugin.web.monitor.list;

import java.util.ArrayList;
import java.util.List;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.IListColumn;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.formplugin.web.HDTCDataBaseList;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.config.IHRDIBaseConfigDomainService;

public class MsgRecordLogListPlugin
extends HDTCDataBaseList {
    private final IHRDIBaseConfigDomainService configDomainService = (IHRDIBaseConfigDomainService)ServiceFactory.getService(IHRDIBaseConfigDomainService.class);

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (StringUtils.equals((String)"retry", (String)operateKey) && operationResult != null && operationResult.isSuccess()) {
            List successPkIds = operationResult.getSuccessPkIds();
            this.showProgressForm(successPkIds);
        }
    }

    private void showProgressForm(List<Object> successPkIds) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hrdi_msgrecordlogprocess");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("msgRecordLogIds", successPkIds);
        this.getView().showForm(showParameter);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hrdi_intlogdetail");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        BillListHyperLinkClickEvent event = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        showParameter.getCustomParams().put("id", event.getCurrentRow().getPrimaryKeyValue());
        showParameter.getCustomParams().put("log_type", "2");
        this.getView().showForm(showParameter);
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        String showException = this.configDomainService.queryBaseConfigValueByNumber("is.show.exception.info");
        List listColumnList = args.getListColumns();
        ArrayList<IListColumn> removeListColumnList = new ArrayList<IListColumn>(16);
        for (IListColumn listColumn : listColumnList) {
            if (!"errorinfo".equals(listColumn.getListFieldKey()) || !"0".equals(showException)) continue;
            removeListColumnList.add(listColumn);
        }
        listColumnList.removeAll(removeListColumnList);
    }
}

