/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.formplugin.web.queryapi.form;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.property.LongProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hdtc.hrdbs.common.constants.QFilterConstants;
import kd.hdtc.hrdbs.common.util.DateTimeUtils;
import kd.hdtc.hrdbs.common.util.platform.DynamicObjectUtils;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.common.IBaseCommonDomainService;
import kd.hdtc.hrdi.business.domain.queryapi.bo.QueryConditionBo;
import kd.hdtc.hrdi.business.domain.queryapi.bo.QueryConditionValueBo;
import kd.hdtc.hrdi.common.queryapi.enums.ConditionCustomEvent;
import kd.hdtc.hrdi.common.queryapi.model.condition.QueryCondition;
import kd.hdtc.hrdi.formplugin.web.queryapi.form.QueryApiConfigBaseCommonFormPlugin;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.common.constants.newhismodel.EnumEntityTpl;

public class QueryApiConditionFormPlugin
extends QueryApiConfigBaseCommonFormPlugin
implements ICloseCallBack {
    private final IBaseCommonDomainService domainService = (IBaseCommonDomainService)ServiceFactory.getService(IBaseCommonDomainService.class);
    private final Set<String> mulValueOperateTypeSet = ImmutableSet.builder().add((Object)CompareTypeEnum.IN.getId()).add((Object)CompareTypeEnum.NOTIN.getId()).build();

    public void registerListener(EventObject event) {
        super.registerListener(event);
        this.addClickListeners(new String[]{"btnnext", "btnprev", "btnupdate", "btnclose"});
    }

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        this.updateData("true");
    }

    private void updateData(String initing) {
        QueryConditionBo conditionBo = new QueryConditionBo(this.getModel().getDataEntity(true), this.getAllQueryFieldMap(), this.getView().getFormShowParameter().getStatus());
        this.updateCustomAp(conditionBo.getCustomApData(initing));
        if (this.getModel().getDataChanged()) {
            DynamicObjectUtils.setBigText((DynamicObject)this.getModel().getDataEntity(), (String)"conditionvalue", (String)conditionBo.getConditionValueJsonData());
        }
    }

    private void updateData(String initing, String changedParamType) {
        QueryConditionBo conditionBo = new QueryConditionBo(this.getModel().getDataEntity(true), this.getAllQueryFieldMap(), this.getView().getFormShowParameter().getStatus(), changedParamType);
        this.updateCustomAp(conditionBo.getCustomApData(initing));
        DynamicObjectUtils.setBigText((DynamicObject)this.getModel().getDataEntity(), (String)"conditionvalue", (String)conditionBo.getConditionValueJsonData());
    }

    private void updateCustomAp(Object value) {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod("customcontrolap", "updateData", new Object[]{value});
    }

    public void beforeClick(BeforeClickEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        String tabIndex = this.getPageCache().get("wizardTabIndex");
        if ("btnnext".equals(key) && "1".equals(tabIndex)) {
            this.updateData("false");
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        if ("paramnumber".equalsIgnoreCase(name) || "paramname".equalsIgnoreCase(name) || "paramtype".equalsIgnoreCase(name)) {
            this.updateData("false", this.getChangedParamType(args));
        } else if ("ruledate".equalsIgnoreCase(name)) {
            Date newDate = (Date)args.getChangeSet()[0].getNewValue();
            this.updateDate(newDate);
        }
    }

    private String getChangedParamType(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        if (!"paramtype".equalsIgnoreCase(name)) {
            return "";
        }
        ChangeData changeData = args.getChangeSet()[0];
        if (!kd.hdtc.hrdbs.common.util.StringUtils.equals((String)((String)changeData.getOldValue()), (String)((String)changeData.getNewValue()))) {
            return (String)this.getModel().getValue("paramnumber", changeData.getRowIndex());
        }
        return "";
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs args) {
        String name = args.getEntryProp().getName();
        if (kd.hdtc.hrdbs.common.util.StringUtils.equals((String)"requestentryentity", (String)name)) {
            this.updateData("false");
        }
    }

    private void showDateControl(String format) {
        Map map = (Map)JSONObject.parseObject((String)format, Map.class);
        String dateFormat = (String)map.get("dateFormat");
        this.getPageCache().put("format", dateFormat);
        this.updateRuleDateFormat(dateFormat);
        HashMap<String, Boolean> valueMap = new HashMap<String, Boolean>(16);
        valueMap.put("showDate", Boolean.TRUE);
        this.updateCustomAp(valueMap);
    }

    protected void updateRuleDateFormat(String dateFormat) {
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)4);
        HashMap itemMap = Maps.newHashMapWithExpectedSize((int)4);
        paramMap.put("mask", dateFormat);
        itemMap.put("item", paramMap);
        this.getView().updateControlMetadata("ruledate", (Map)itemMap);
    }

    private void updateDate(Date newDate) {
        String format = this.getPageCache().get("format");
        String dateStr = "";
        if (newDate != null) {
            dateStr = DateTimeUtils.format((Date)newDate, (String)format);
        }
        HashMap<String, String> valueMap = new HashMap<String, String>(16);
        valueMap.put("date", dateStr);
        this.updateCustomAp(valueMap);
    }

    public void customEvent(CustomEventArgs event) {
        String eventName = event.getEventName();
        if (kd.hdtc.hrdbs.common.util.StringUtils.equalsIgnoreCase((String)ConditionCustomEvent.SET_VALUE.getCode(), (String)eventName)) {
            DynamicObjectUtils.setBigText((DynamicObject)this.getModel().getDataEntity(), (String)"conditionvalue", (String)event.getEventArgs());
        } else if (kd.hdtc.hrdbs.common.util.StringUtils.equalsIgnoreCase((String)ConditionCustomEvent.SET_DATE_FORMAT.getCode(), (String)eventName)) {
            this.showDateControl(event.getEventArgs());
        } else if (kd.hdtc.hrdbs.common.util.StringUtils.equalsIgnoreCase((String)ConditionCustomEvent.OPEAN_PARAM_F7.getCode(), (String)eventName)) {
            this.showF7(event.getEventArgs());
        } else if (kd.hdtc.hrdbs.common.util.StringUtils.equalsIgnoreCase((String)ConditionCustomEvent.OPEAN_EXPRESS_VIEW.getCode(), (String)eventName)) {
            // empty if block
        }
    }

    private void showF7(String args) {
        LinkedHashMap argsMap = (LinkedHashMap)JSONObject.parseObject((String)args, LinkedHashMap.class);
        String index = argsMap.get("index").toString();
        this.getPageCache().put("index", index);
        String entityNumber = argsMap.get("entityNumber").toString();
        this.getPageCache().put("entityNumber", entityNumber);
        boolean isMulti = false;
        if (this.mulValueOperateTypeSet.contains(argsMap.get("operators").toString())) {
            isMulti = true;
        }
        String selectedValue = null == argsMap.get("value") ? "" : argsMap.get("value").toString();
        String filterStr = (String)argsMap.get("filters");
        ListShowParameter fsp = ShowFormHelper.createShowListForm((String)entityNumber, (boolean)isMulti);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "openConditionParamF7CallBack"));
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setShowTitle(false);
        fsp.setHasRight(true);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        List<QFilter> qFilters = this.getQFilters(mainEntityType, filterStr);
        fsp.setListFilterParameter(new ListFilterParameter(qFilters, null));
        boolean pkLong = mainEntityType.getPrimaryKey() instanceof LongProp;
        if (isMulti && kd.hdtc.hrdbs.common.util.StringUtils.isNotEmpty((String)selectedValue)) {
            Object[] selectedIds = this.getSelectIds(entityNumber, index, selectedValue, pkLong);
            fsp.setSelectedRows(selectedIds);
        }
        this.getView().showForm((FormShowParameter)fsp);
    }

    private Object[] getSelectIds(String entityNumber, String index, String selectedValue, boolean pkLong) {
        QueryConditionValueBo valueBo = new QueryConditionValueBo(this.getModel().getDataEntity());
        QueryCondition condition = valueBo.getConditionByIndex(Integer.parseInt(index));
        String param = condition.getParam();
        String field = param.substring(param.lastIndexOf(".") + 1);
        if (kd.hdtc.hrdbs.common.util.StringUtils.equals((String)"id", (String)field)) {
            Object[] selectedIds = selectedValue.split(",");
            if (pkLong) {
                return this.convert((String[])selectedIds);
            }
            return selectedIds;
        }
        Map<Object, DynamicObject> basedataMap = this.queryBasedata(entityNumber, field, selectedValue);
        return basedataMap.keySet().toArray();
    }

    private Map<Object, DynamicObject> queryBasedata(String entityNumber, String field, String selectedValue) {
        String[] selectedValues = selectedValue.split(",");
        String entityTpl = HisModelController.getInstance().entityInhRelation(entityNumber);
        QFilter filter = new QFilter(field, "in", (Object)selectedValues);
        QFilter[] filters = EnumEntityTpl.COMMON_TPL.getNumber().equals(entityTpl) ? new QFilter[]{filter} : new QFilter[]{filter, QFilterConstants.Q_CURRENTVERSION};
        return this.domainService.queryByFilters(entityNumber, "id", filters);
    }

    private Long[] convert(String[] selectedIds) {
        ArrayList<Long> idList = new ArrayList<Long>(10);
        for (String selectedId : selectedIds) {
            idList.add(Long.parseLong(selectedId));
        }
        return idList.toArray(new Long[0]);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        if ("openConditionParamF7CallBack".equals(event.getActionId())) {
            this.updateF7Param((ListSelectedRowCollection)event.getReturnData());
        }
    }

    private void updateF7Param(ListSelectedRowCollection returnData) {
        if (returnData == null) {
            return;
        }
        HashMap<String, Object> paramValueMap = new HashMap<String, Object>(16);
        paramValueMap.put("index", this.getPageCache().get("index"));
        ArrayList<Object> idList = new ArrayList<Object>(10);
        ArrayList<Object> nameList = new ArrayList<Object>(10);
        ArrayList<Object> numberList = new ArrayList<Object>(10);
        boolean idIsString = false;
        for (ListSelectedRow row : returnData) {
            if (!row.isPkLongType()) {
                idIsString = true;
            }
            idList.add(row.getPrimaryKeyValue());
            nameList.add(row.getName());
            numberList.add(row.getNumber());
        }
        List<Object> basedataList = this.getBasedataParam(idList, nameList, numberList);
        paramValueMap.put("valueIdIsString", idIsString);
        paramValueMap.put("idList", basedataList);
        paramValueMap.put("nameList", basedataList);
        paramValueMap.put("numberList", numberList);
        HashMap<String, HashMap<String, Object>> valueMap = new HashMap<String, HashMap<String, Object>>(16);
        valueMap.put("paramValue", paramValueMap);
        this.updateCustomAp(valueMap);
    }

    private List<Object> getBasedataParam(List<Object> idList, List<Object> nameList, List<Object> numberList) {
        String field;
        String index = this.getPageCache().get("index");
        String entityNumber = this.getPageCache().get("entityNumber");
        QueryConditionValueBo valueBo = new QueryConditionValueBo(this.getModel().getDataEntity());
        QueryCondition condition = valueBo.getCondition(Integer.parseInt(index));
        String param = condition.getParam();
        switch (field = param.substring(param.lastIndexOf(".") + 1)) {
            case "id": {
                return idList;
            }
            case "name": {
                return nameList;
            }
            case "number": {
                return numberList;
            }
        }
        Map dataMap = this.domainService.queryByFilters(entityNumber, field, new QFilter[]{new QFilter("id", "in", idList)});
        ArrayList<Object> resultList = new ArrayList<Object>(10);
        dataMap.forEach((obj, dyn) -> resultList.add(dyn.getString(field)));
        return resultList;
    }

    private List<QFilter> getQFilters(MainEntityType mainEntityType, String filterStr) {
        List qFilterList;
        ArrayList qFilters = Lists.newArrayListWithExpectedSize((int)2);
        if (null != mainEntityType.findProperty("enable")) {
            qFilters.add(new QFilter("enable", "=", (Object)"1"));
        }
        if (null != mainEntityType.findProperty("status")) {
            qFilters.add(new QFilter("status", "=", (Object)"C"));
        }
        if (StringUtils.isNotEmpty((CharSequence)filterStr) && !CollectionUtils.isEmpty((Collection)(qFilterList = SerializationUtils.fromJsonStringToList((String)filterStr, QFilter.class)))) {
            qFilters.addAll(qFilterList);
        }
        return qFilters;
    }
}

