/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.formplugin.web.queryapi.form;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.mulentities.QSConditionRow;
import kd.bos.entity.mulentities.QuerySourceJoinRelation;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.platform.DynamicObjectUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hdtc.hrdi.business.application.external.IHRQueryConfigDomainService;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.queryapi.bo.QueryApiEntityInfoParseBo;
import kd.hdtc.hrdi.common.queryapi.model.QueryEntityModel;
import kd.hdtc.hrdi.common.queryapi.model.QueryFieldModel;
import kd.hdtc.hrdi.common.util.StringValidateUtil;
import kd.hdtc.hrdi.formplugin.web.queryapi.form.QueryApiConfigBaseCommonFormPlugin;
import kd.hr.hbp.business.service.complexobj.util.DBConfigUtil;
import kd.hr.hbp.common.util.HRStringUtils;

public class QueryApiConfigFormPlugin
extends QueryApiConfigBaseCommonFormPlugin
implements CellClickListener,
BeforeF7SelectListener {
    private final IHRQueryConfigDomainService queryConfigDomainService = (IHRQueryConfigDomainService)ServiceFactory.getService(IHRQueryConfigDomainService.class);
    private static final List<String> QUERY_ENTITY_FIELD_LIST = ImmutableList.of((Object)"fieldnumber", (Object)"fieldname", (Object)"fieldalias", (Object)"fielddescription", (Object)"fullfieldnumber", (Object)"fieldvaluetype", (Object)"fieldtype", (Object)"comboitemmap", (Object)"queryentitynumber", (Object)"queryentityname");
    private static final List<String> ORDER_ENTITY_FIELD_LIST = ImmutableList.of((Object)"orderfieldnumber", (Object)"orderfieldname", (Object)"orderfielddescription", (Object)"orderrule", (Object)"orderfullfieldnumber");

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        EntryGrid RelEntryGrid = (EntryGrid)this.getView().getControl("relentryentity");
        RelEntryGrid.addCellClickListener((CellClickListener)this);
        this.addItemClickListeners(new String[]{"queryfieldtoolbarap"});
        this.addItemClickListeners(new String[]{"orderfieldtoolbarap"});
        BasedataEdit rightEntityObjFieldEdit = (BasedataEdit)this.getView().getControl("rightentityobj");
        rightEntityObjFieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"btnnext", "btnprev", "btnupdate", "btnclose"});
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        Boolean isCopy = (Boolean)this.getView().getFormShowParameter().getCustomParam("iscopy");
        if (isCopy != null && isCopy.booleanValue()) {
            this.getView().getModel().setValue("queryconfignumber", (Object)"");
            this.getView().getModel().setValue("ispublishapi", (Object)"0");
        }
        this.querySchemaHandle();
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        String propertyName;
        switch (propertyName = propertyChangedArgs.getProperty().getName()) {
            case "mainentityobj": {
                this.onMainEntityObjChange(propertyChangedArgs);
                break;
            }
            case "rightentityobj": {
                this.onRightEntityObjChange(propertyChangedArgs);
                break;
            }
            case "fieldalias": {
                this.onFieldAliasChange(propertyChangedArgs);
                break;
            }
            case "requestmethod": {
                this.onQueryMethodChange(propertyChangedArgs);
                break;
            }
        }
    }

    private void onQueryMethodChange(PropertyChangedArgs propertyChangedArgs) {
        Object[] changeSet = propertyChangedArgs.getChangeSet();
        if (ArrayUtils.isEmpty((Object[])changeSet)) {
            return;
        }
        Object changeData = changeSet[0];
        String newValue = (String)changeData.getNewValue();
        if (StringUtils.equals((String)"0", (String)newValue)) {
            DynamicObjectCollection requestEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("requestentryentity");
            requestEntry.forEach(dyn -> dyn.set("mulvalue", (Object)"0"));
        }
    }

    private void onRightEntityObjChange(PropertyChangedArgs propertyChangedArgs) {
        Object[] changeSet = propertyChangedArgs.getChangeSet();
        if (ArrayUtils.isEmpty((Object[])changeSet)) {
            return;
        }
        Object changeData = changeSet[0];
        this.getModel().setValue("rightentityfield", (Object)"", changeData.getRowIndex());
        this.getView().updateView("relentryentity");
        this.querySchemaHandle();
    }

    private void querySchemaHandle() {
        String mainEntity = this.getMainEntity();
        if (StringUtils.isEmpty((String)mainEntity)) {
            return;
        }
        List<String> relEntityList = this.getRelEntity();
        boolean crossDb = false;
        DBConfigUtil dbConfigUtil = new DBConfigUtil();
        String mainDbSharingId = this.getDBConfigSharingId(dbConfigUtil, mainEntity);
        for (String relEntity : relEntityList) {
            if (StringUtils.equals((String)mainDbSharingId, (String)this.getDBConfigSharingId(dbConfigUtil, relEntity))) continue;
            crossDb = true;
            break;
        }
        if (crossDb) {
            this.getModel().setValue("queryschema", (Object)"ALGO");
        }
        this.getView().setEnable(Boolean.valueOf(!crossDb), new String[]{"radioksql"});
        this.getView().updateView("queryschema");
    }

    private String getDBConfigSharingId(DBConfigUtil dbConfigUtil, String entity) {
        String dbConfigSharingIdJson = this.getPageCache().get("DBConfigSharingId_cache");
        HashMap<String, String> dbConfigSharingIdMap = !StringUtils.isEmpty((String)dbConfigSharingIdJson) ? (HashMap<String, String>)SerializationUtils.fromJsonString((String)dbConfigSharingIdJson, Map.class) : new HashMap<String, String>(16);
        String dbConfigSharingId = (String)dbConfigSharingIdMap.get(entity);
        if (StringUtils.isEmpty((String)dbConfigSharingId)) {
            String dbRouteKey = MetadataUtils.getMainEntityType((String)entity).getDBRouteKey();
            dbConfigSharingId = dbConfigUtil.getDBConfigSharingId(dbRouteKey);
            dbConfigSharingIdMap.put(entity, dbConfigSharingId);
            this.getPageCache().put("DBConfigSharingId_cache", SerializationUtils.toJsonString(dbConfigSharingIdMap));
        }
        return dbConfigSharingId;
    }

    private String getMainEntity() {
        DynamicObject mainEntityDyn = this.getModel().getDataEntity().getDynamicObject("mainentityobj");
        if (mainEntityDyn == null) {
            return "";
        }
        return mainEntityDyn.getString("id");
    }

    private List<String> getRelEntity() {
        DynamicObjectCollection relEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("relentryentity");
        return relEntry.stream().filter(relDyn -> relDyn.get("rightentityobj") != null).map(relDyn -> relDyn.getString("rightentityobj.id")).collect(Collectors.toList());
    }

    private void onFieldAliasChange(PropertyChangedArgs propertyChangedArgs) {
        Object[] changeSet = propertyChangedArgs.getChangeSet();
        if (ArrayUtils.isEmpty((Object[])changeSet)) {
            return;
        }
        ChangeData changeData = propertyChangedArgs.getChangeSet()[0];
        String oldQueryFieldAlias = (String)changeData.getOldValue();
        String newQueryFieldAlias = (String)changeData.getNewValue();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("queryentryentity");
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("queryentryentity");
        for (int i = 0; i < entryEntity.size(); ++i) {
            String currentFieldAlias = ((DynamicObject)entryEntity.get(i)).getString("fieldalias");
            if (entryCurrentRowIndex == i || !currentFieldAlias.equals(newQueryFieldAlias)) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4fee\u6539\u53c2\u6570\u522b\u540d\uff0c\u907f\u514d\u4e0e\u5176\u4ed6\u53c2\u6570\u91cd\u590d\u3002", (String)"QueryApiConfigFormPlugin_5", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]));
            this.getModel().beginInit();
            ((DynamicObject)entryEntity.get(i)).set("fieldalias", (Object)oldQueryFieldAlias);
            this.getModel().endInit();
            this.getView().updateView("queryentryentity");
            return;
        }
        if (StringValidateUtil.containsSpecialCharacter((String)newQueryFieldAlias)) {
            this.getView().showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u67e5\u8be2\u5b57\u6bb5\u53c2\u6570\u522b\u540d\u201c%s\u201d\u4e0d\u80fd\u5305\u542b\u4e2d\u6587\u6216\u9664\u4e0b\u5212\u7ebf\u5916\u7684\u7279\u6b8a\u7b26\u53f7\uff0c\u8bf7\u4fee\u6b63\u3002", (String)"QueryApiConfigFormPlugin_6", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]), newQueryFieldAlias));
        }
    }

    private void onMainEntityObjChange(PropertyChangedArgs propertyChangedArgs) {
        Object[] changeSet = propertyChangedArgs.getChangeSet();
        if (ArrayUtils.isEmpty((Object[])changeSet)) {
            return;
        }
        ChangeData changeData = propertyChangedArgs.getChangeSet()[0];
        DynamicObject oldMainEntityObj = (DynamicObject)changeData.getOldValue();
        if (oldMainEntityObj != null) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u4fee\u6539\u4e3b\u5b9e\u4f53\u5bf9\u8c61\u5c06\u5bfc\u81f4\u201c\u591a\u5b9e\u4f53\u5173\u7cfb\u201d\u5206\u5f55\u53ca\u76f8\u5173\u914d\u7f6e\u88ab\u6e05\u7a7a\u3002\u662f\u5426\u7ee7\u7eed\uff1f", (String)"QueryApiConfigFormPlugin_3", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("mainEntityObjChangeConfirmActionId", (IFormPlugin)this));
            this.getPageCache().put("oldMainEntityObjId", oldMainEntityObj.getString("id"));
        } else {
            this.doQueryEntityHandle();
        }
    }

    private void doQueryEntityHandle() {
        DynamicObject mainEntity = (DynamicObject)this.getModel().getValue("mainentityobj");
        if (mainEntity == null) {
            return;
        }
        String newEntity = mainEntity.getString("id");
        MainEntityType mainEntityType = MetadataUtils.getMainEntityType((String)newEntity);
        if (!(mainEntityType instanceof QueryEntityType)) {
            this.getModel().setValue("queryconfigtype", (Object)"1");
            this.getModel().setValue("queryconfignumber", (Object)"");
            return;
        }
        QueryEntityType queryEntityType = (QueryEntityType)mainEntityType;
        this.commonFieldHandleByQueryEntity(newEntity);
        this.buildRelEntryByQueryEntity(queryEntityType);
    }

    private void commonFieldHandleByQueryEntity(String newEntity) {
        this.getModel().setValue("queryconfigtype", (Object)"2");
        this.getModel().setValue("queryconfignumber", (Object)newEntity);
    }

    private void buildRelEntryByQueryEntity(QueryEntityType queryEntityType) {
        List joinRelationList = queryEntityType.getJoinRelations();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        AtomicInteger index = new AtomicInteger();
        joinRelationList.forEach(relation -> relation.getCondition().forEach(row -> {
            this.buildEntryValueSetter(setter, (QuerySourceJoinRelation)relation, (QSConditionRow)row, index.get());
            index.getAndIncrement();
        }));
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        this.getModel().beginInit();
        model.batchCreateNewEntryRow("relentryentity", setter);
        this.getModel().endInit();
        this.getView().updateView("relentryentity");
    }

    private void buildEntryValueSetter(TableValueSetter setter, QuerySourceJoinRelation relation, QSConditionRow qsConditionRow, int index) {
        setter.set("leftentityobj", (Object)relation.getEntityNumber(), index);
        setter.set("leftentityfield", (Object)qsConditionRow.getLeftItem().toString(), index);
        setter.set("leftentityfieldname", (Object)qsConditionRow.getLeftItem().toString(), index);
        setter.set("logicalrel", (Object)"=", index);
        setter.set("rightentityobj", (Object)relation.getRelEntityNumber(), index);
        setter.set("rightentityfield", (Object)qsConditionRow.getRightItem().toString(), index);
        setter.set("rightentityfieldname", (Object)qsConditionRow.getRightItem().toString(), index);
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        String key = ((Control)evt.getSource()).getKey();
        String tabIndex = this.getPageCache().get("wizardTabIndex");
        if ("btnnext".equals(key) && "0".equals(tabIndex)) {
            DynamicObject mainEntityObj = this.getModel().getDataEntity().getDynamicObject("mainentityobj");
            if (mainEntityObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4e3b\u5b9e\u4f53\u5bf9\u8c61\u3002", (String)"QueryApiConfigFormPlugin_9", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
            QueryApiEntityInfoParseBo queryApiEntityInfoParseBo = new QueryApiEntityInfoParseBo(this.getModel().getDataEntity(true));
            QueryEntityType queryEntityType = queryApiEntityInfoParseBo.getQueryEntityType();
            List queryEntityModelList = queryApiEntityInfoParseBo.getQueryEntityModelList(queryEntityType);
            this.getPageCache().put("allQueryEntityInfoList", JSONObject.toJSONString((Object)queryEntityModelList));
            this.getPageCache().put("allQueryFieldInfoList", JSONObject.toJSONString((Object)queryApiEntityInfoParseBo.getQueryFieldModelList()));
            this.getPageCache().put("allQueryFieldTreeNodeMap", JSONObject.toJSONString((Object)queryApiEntityInfoParseBo.getEntityNumberAndFieldTreeNodeListMap()));
            this.deleteQueryEntryEntityCollection(queryEntityModelList);
            this.fillQueryFieldByQueryEntity(queryEntityType);
        } else if ("btnnext".equals(key) && "1".equals(tabIndex)) {
            DynamicObjectCollection queryEntryEntity = this.getModel().getEntryEntity("queryentryentity");
            if (CollectionUtils.isEmpty((Collection)queryEntryEntity)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u67e5\u8be2\u5b57\u6bb5\u3002", (String)"QueryApiConfigFormPlugin_7", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
            boolean addOrderField = this.getModel().getDataEntity().getBoolean("addorderfield");
            DynamicObjectCollection orderEntryEntity = this.getModel().getEntryEntity("orderentryentity");
            if (addOrderField && CollectionUtils.isEmpty((Collection)orderEntryEntity)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u201c\u6dfb\u52a0\u6392\u5e8f\u5b57\u6bb5\u201d\u4e3a\u201c\u662f\u201d\u65f6\uff0c\u201c\u6392\u5e8f\u5b57\u6bb5\u201d\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QueryApiConfigFormPlugin_8", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    private void deleteQueryEntryEntityCollection(List<QueryEntityModel> queryEntityModelList) {
        Set entityNumberSet = queryEntityModelList.stream().map(QueryEntityModel::getEntityNumber).collect(Collectors.toSet());
        DynamicObjectCollection queryEntryEntity = this.getModel().getEntryEntity("queryentryentity");
        ArrayList needDelIdxList = Lists.newArrayListWithExpectedSize((int)16);
        for (int i = 0; i < queryEntryEntity.size(); ++i) {
            String entityNumber = ((DynamicObject)queryEntryEntity.get(i)).getString("queryentitynumber");
            if (entityNumberSet.contains(entityNumber)) continue;
            needDelIdxList.add(i);
        }
        this.deleteEntryEntityRows(needDelIdxList, "queryentryentity");
        DynamicObjectCollection orderDynColl = this.getModel().getEntryEntity("orderentryentity");
        Map<String, QueryFieldModel> allQueryFieldInfoMap = this.getAllQueryFieldInfoMap();
        ArrayList needDelOrderIdxList = Lists.newArrayListWithExpectedSize((int)16);
        for (int i = 0; i < orderDynColl.size(); ++i) {
            String orderFullNumber = ((DynamicObject)orderDynColl.get(i)).getString("orderfullfieldnumber");
            QueryFieldModel queryFieldModel = allQueryFieldInfoMap.get(orderFullNumber);
            if (queryFieldModel != null) continue;
            needDelOrderIdxList.add(i);
        }
        this.deleteEntryEntityRows(needDelOrderIdxList, "orderentryentity");
    }

    private void deleteEntryEntityRows(List<Integer> needDelIdxList, String entryEntityKey) {
        if (CollectionUtils.isNotEmpty(needDelIdxList)) {
            int[] needDelIdxs = new int[needDelIdxList.size()];
            for (int i = 0; i < needDelIdxs.length; ++i) {
                needDelIdxs[i] = needDelIdxList.get(i);
            }
            this.getModel().deleteEntryRows(entryEntityKey, needDelIdxs);
        }
    }

    private void fillQueryFieldByQueryEntity(QueryEntityType queryEntityType) {
        if (queryEntityType == null) {
            return;
        }
        Map<String, QueryFieldModel> allQueryFieldInfoMap = this.getAllQueryFieldMap();
        List selectFields = queryEntityType.getSelectFields();
        ArrayList<QueryFieldModel> queryFieldModelList = new ArrayList<QueryFieldModel>(10);
        selectFields.forEach(field -> {
            QueryFieldModel queryFieldModel = (QueryFieldModel)allQueryFieldInfoMap.get(field.getAlias());
            if (queryFieldModel != null) {
                queryFieldModelList.add(queryFieldModel);
            }
        });
        this.buildQueryFieldEntry(queryFieldModelList);
    }

    private void buildQueryFieldEntry(List<QueryFieldModel> queryFieldModelList) {
        TableValueSetter valueSetter = new TableValueSetter(new String[0]);
        int index = 0;
        for (QueryFieldModel queryFieldModel : queryFieldModelList) {
            String comboItem = CollectionUtils.isEmpty((Collection)queryFieldModel.getComboItemList()) ? "" : JSONObject.toJSONString((Object)queryFieldModel.getComboItemList());
            valueSetter.set("fieldnumber", (Object)queryFieldModel.getQueryFieldNumber(), index);
            valueSetter.set("fieldname", (Object)queryFieldModel.getFieldName(), index);
            valueSetter.set("fieldalias", (Object)queryFieldModel.getQueryFieldNumber(), index);
            valueSetter.set("fielddescription", (Object)queryFieldModel.getFieldName(), index);
            valueSetter.set("fullfieldnumber", (Object)queryFieldModel.getFullFieldNumber(), index);
            valueSetter.set("fieldvaluetype", (Object)queryFieldModel.getValueType(), index);
            valueSetter.set("fieldtype", (Object)queryFieldModel.getFieldType(), index);
            valueSetter.set("comboitemmap", (Object)comboItem, index);
            valueSetter.set("queryentitynumber", (Object)queryFieldModel.getEntityNumber(), index);
            valueSetter.set("queryentityname", (Object)queryFieldModel.getEntityName(), index);
            ++index;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        model.batchCreateNewEntryRow("queryentryentity", valueSetter);
        model.endInit();
        this.getView().updateView("queryentryentity");
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        if (StringUtils.equals((String)fieldKey, (String)"rightentityobj")) {
            HashSet entryObjIdSet = Sets.newHashSetWithExpectedSize((int)16);
            DynamicObject mainEntityObj = this.getModel().getDataEntity().getDynamicObject("mainentityobj");
            if (mainEntityObj != null) {
                entryObjIdSet.add(mainEntityObj.getString("id"));
            }
            DynamicObjectCollection dynColl = this.getModel().getEntryEntity("relentryentity");
            for (DynamicObject row : dynColl) {
                DynamicObject rightEntryObj;
                DynamicObject leftEntryObj = row.getDynamicObject("leftentityobj");
                if (leftEntryObj != null) {
                    entryObjIdSet.add(leftEntryObj.getString("id"));
                }
                if ((rightEntryObj = row.getDynamicObject("rightentityobj")) == null) continue;
                entryObjIdSet.add(rightEntryObj.getString("id"));
            }
            if (CollectionUtils.isNotEmpty((Collection)entryObjIdSet)) {
                QFilter entityObjIdFilter = new QFilter("id", "not in", (Object)entryObjIdSet);
                beforeF7SelectEvent.addCustomQFilter(entityObjIdFilter);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if (operateKey.equals("rel_newentry")) {
            this.relEntryNewValidate(args);
        } else if (operateKey.equals("rel_deleteentry")) {
            this.relEntryDeleteHandle(args);
        } else if ("save".equals(operateKey)) {
            this.setAppIdAndEntityFieldName();
        }
    }

    private void setAppIdAndEntityFieldName() {
        DynamicObject entityObj = this.getModel().getDataEntity().getDynamicObject("mainentityobj");
        DynamicObjectCollection dynColl = this.getModel().getEntryEntity("relentryentity");
        DynamicObject queryApiConfig = this.getModel().getDataEntity(true);
        if (entityObj != null) {
            queryApiConfig.set("bizapp", (Object)entityObj.getDynamicObject("bizappid"));
            String newEntity = entityObj.getString("id");
            MainEntityType mainEntityType = MetadataUtils.getMainEntityType((String)newEntity);
            if (!(mainEntityType instanceof QueryEntityType)) {
                if (CollectionUtils.isEmpty((Collection)dynColl)) {
                    queryApiConfig.set("queryconfigtype", (Object)"0");
                } else {
                    queryApiConfig.set("queryconfigtype", (Object)"1");
                }
            }
        }
        Map<String, QueryFieldModel> allQueryFieldInfoMap = this.getAllQueryFieldInfoMap();
        dynColl.forEach(dyn -> {
            DynamicObject leftEntityObj = dyn.getDynamicObject("leftentityobj");
            String leftEntityField = dyn.getString("leftentityfield");
            DynamicObject rightEntityObj = dyn.getDynamicObject("rightentityobj");
            String rightEntityField = dyn.getString("rightentityfield");
            if (leftEntityObj != null && rightEntityObj != null) {
                String rightFullFieldNumber;
                QueryFieldModel rightQueryFieldModel;
                String leftFullFieldNumber = leftEntityObj.getString("number") + "." + leftEntityField;
                QueryFieldModel leftQueryFieldModel = (QueryFieldModel)allQueryFieldInfoMap.get(leftFullFieldNumber);
                if (leftQueryFieldModel != null) {
                    dyn.set("leftentityfieldname", (Object)leftQueryFieldModel.getFieldName());
                }
                if ((rightQueryFieldModel = (QueryFieldModel)allQueryFieldInfoMap.get(rightFullFieldNumber = rightEntityObj.getString("number") + "." + rightEntityField)) != null) {
                    dyn.set("rightentityfieldname", (Object)rightQueryFieldModel.getFieldName());
                }
            }
        });
    }

    private void relEntryDeleteHandle(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection dynColl = this.getModel().getEntryEntity("relentryentity");
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("relentryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (dynColl.size() > 0 && selectRows.length > 0) {
            for (int idx : selectRows) {
                if (idx != 0) continue;
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u9996\u884c\uff0c\u5c06\u540c\u65f6\u5220\u9664\u6240\u6709\u201c\u591a\u5b9e\u4f53\u5173\u7cfb\u201d\u5206\u5f55\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"QueryApiConfigFormPlugin_2", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("rel_deleteentry", (IFormPlugin)this));
                args.setCancel(true);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (HRStringUtils.equals((String)messageBoxClosedEvent.getCallBackId(), (String)"rel_deleteentry") && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.clearAllEntryEntity();
        } else if (HRStringUtils.equals((String)messageBoxClosedEvent.getCallBackId(), (String)"mainEntityObjChangeConfirmActionId")) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Cancel) {
                String oldMainEntityObjId = this.getPageCache().get("oldMainEntityObjId");
                this.getModel().beginInit();
                this.getModel().setValue("mainentityobj", (Object)oldMainEntityObjId);
                this.getModel().endInit();
                this.getView().updateView("mainentityobj");
            } else {
                this.clearAllEntryEntity();
                this.doQueryEntityHandle();
            }
        }
    }

    private void clearAllEntryEntity() {
        this.clearEntryEntity("relentryentity");
        this.clearEntryEntity("queryentryentity");
        this.clearEntryEntity("orderentryentity");
        DynamicObjectUtils.setBigText((DynamicObject)this.getModel().getDataEntity(), (String)"conditionvalue", (String)"");
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"radioksql"});
    }

    private void clearEntryEntity(String entryEntityKey) {
        DynamicObjectCollection dynColl = this.getModel().getEntryEntity(entryEntityKey);
        int[] selectRows = new int[dynColl.size()];
        for (int i = 0; i < dynColl.size(); ++i) {
            selectRows[i] = i;
        }
        this.getModel().deleteEntryRows(entryEntityKey, selectRows);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (operateKey.equals("rel_newentry")) {
            DynamicObjectCollection dynColl = this.getModel().getEntryEntity("relentryentity");
            if (dynColl.size() > 0) {
                DynamicObject mainEntityObj = this.getModel().getDataEntity().getDynamicObject("mainentityobj");
                ((DynamicObject)dynColl.get(dynColl.size() - 1)).set("leftentityobj", (Object)mainEntityObj);
                this.getModel().beginInit();
                this.getModel().setValue("relentryentity", (Object)dynColl);
                this.getModel().endInit();
                this.getView().updateView("relentryentity");
            }
        } else if (operateKey.equals("save")) {
            this.queryConfigDomainService.saveQuerySchema(this.getModel().getDataEntity());
        } else if (operateKey.equals("rel_deleteentry")) {
            this.querySchemaHandle();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("btn_queryfield_new".equals(itemKey)) {
            this.showQuerySelectFieldForm(this.getAllQueryEntityModelList(), this.getAllQueryFieldTreeNodeMap(), itemKey, this.initAndGetSelectFullFieldNumberSet("queryentryentity"));
        } else if ("btn_order_new".equals(itemKey)) {
            this.showQuerySelectFieldForm(this.getAllQueryEntityModelList(), this.getAllQueryFieldTreeNodeMap(), itemKey, this.initAndGetSelectFullFieldNumberSet("orderentryentity"));
        }
    }

    protected Set<String> initAndGetSelectFullFieldNumberSet(String entryEntity) {
        String selectFieldKey = "selectQueryFieldSet";
        String fieldName = "fullfieldnumber";
        if (entryEntity.equals("orderentryentity")) {
            selectFieldKey = "selectOrderFieldSet";
            fieldName = "orderfullfieldnumber";
        }
        LinkedHashSet selectQueryFieldSet = Sets.newLinkedHashSetWithExpectedSize((int)16);
        DynamicObjectCollection entryEntityCollection = this.getModel().getEntryEntity(entryEntity);
        for (DynamicObject entry : entryEntityCollection) {
            selectQueryFieldSet.add(entry.getString(fieldName));
        }
        this.getPageCache().put(selectFieldKey, JSONObject.toJSONString((Object)selectQueryFieldSet));
        return selectQueryFieldSet;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.equals("btn_queryfield_new")) {
            this.fillQueryFields((String)closedCallBackEvent.getReturnData());
        } else if (actionId.equals("btn_order_new")) {
            this.fillOrderFields((String)closedCallBackEvent.getReturnData());
        }
    }

    public void cellClick(CellClickEvent evt) {
        String fieldKey = evt.getFieldKey();
        if (HRStringUtils.equals((String)fieldKey, (String)"leftentityfield")) {
            this.setFieldComboItems("leftentityobj", fieldKey);
        } else if (HRStringUtils.equals((String)fieldKey, (String)"rightentityfield")) {
            this.setFieldComboItems("rightentityobj", fieldKey);
        }
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
        this.cellClick(cellClickEvent);
    }

    private void showQuerySelectFieldForm(List<QueryEntityModel> queryEntityModelList, Map<String, List<TreeNode>> entityNumberAndQueryFieldListMap, String actionId, Set<String> selectFullFieldNumberSet) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hrdi_queryfieldf7");
        showParameter.getCustomParams().put("queryFieldList", JSONObject.toJSONString(entityNumberAndQueryFieldListMap));
        showParameter.getCustomParams().put("queryEntityList", JSONObject.toJSONString(queryEntityModelList));
        showParameter.getCustomParams().put("ismulti", "true");
        showParameter.getCustomParams().put("nodeids", String.join((CharSequence)",", selectFullFieldNumberSet));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        if ("btn_order_new".equals(actionId)) {
            String caption = ResManager.loadKDString((String)"\u6392\u5e8f\u5b57\u6bb5\u9009\u62e9", (String)"QueryApiConfigFormPlugin_4", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]);
            showParameter.setCaption(caption);
        }
        this.getView().showForm(showParameter);
    }

    private void relEntryNewValidate(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection dynColl;
        DynamicObject mainEntityObj = this.getModel().getDataEntity().getDynamicObject("mainentityobj");
        if (mainEntityObj == null) {
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4e3b\u5b9e\u4f53\u5bf9\u8c61\u3002", (String)"QueryApiConfigFormPlugin_0", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]));
        }
        if ((dynColl = this.getModel().getEntryEntity("relentryentity")).size() >= 10) {
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6bcf\u4e2a\u5206\u5f55\u6700\u591a\u53ea\u80fd\u6dfb\u52a010\u6761\u5b9e\u4f53\u5173\u7cfb\uff0c\u65e0\u6cd5\u518d\u589e\u52a0\u3002", (String)"QueryApiConfigFormPlugin_1", (String)"hdtc-hrdi-formplugin", (Object[])new Object[0]));
        }
    }

    private void fillOrderFields(String selectFullFieldNumbers) {
        if (StringUtils.isEmpty((String)selectFullFieldNumbers)) {
            return;
        }
        Map<String, QueryFieldModel> allQueryFieldInfoMap = this.getAllQueryFieldInfoMap();
        String[] fullFieldNumbers = selectFullFieldNumbers.split(",");
        TableValueSetter vs = this.generateTableValueSetter(ORDER_ENTITY_FIELD_LIST);
        Set<String> selectOrderFieldSet = this.getSelectFullFieldNumberSet("selectOrderFieldSet");
        for (String fullFieldNumber : fullFieldNumbers) {
            QueryFieldModel queryFieldModel = allQueryFieldInfoMap.get(fullFieldNumber);
            if (queryFieldModel == null || queryFieldModel.isComplexType() || selectOrderFieldSet.contains(fullFieldNumber)) continue;
            vs.addRow(new Object[]{queryFieldModel.getQueryFieldNumber(), queryFieldModel.getFieldName(), queryFieldModel.getFullFieldName(), "asc", queryFieldModel.getFullFieldNumber()});
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        model.batchCreateNewEntryRow("orderentryentity", vs);
        model.endInit();
        this.getView().updateView("orderentryentity");
        this.deleteNoCheckField(fullFieldNumbers, "orderentryentity", "orderfullfieldnumber");
    }

    private void fillQueryFields(String selectFullFieldNumbers) {
        if (StringUtils.isEmpty((String)selectFullFieldNumbers)) {
            return;
        }
        Map<String, QueryFieldModel> allQueryFieldInfoMap = this.getAllQueryFieldInfoMap();
        String[] fullFieldNumbers = selectFullFieldNumbers.split(",");
        TableValueSetter vs = this.generateTableValueSetter(QUERY_ENTITY_FIELD_LIST);
        Set<String> selectQueryFieldSet = this.getSelectFullFieldNumberSet("selectQueryFieldSet");
        for (String fullFieldNumber : fullFieldNumbers) {
            QueryFieldModel queryFieldModel = allQueryFieldInfoMap.get(fullFieldNumber);
            if (queryFieldModel == null || queryFieldModel.isComplexType() || selectQueryFieldSet.contains(fullFieldNumber)) continue;
            vs.addRow(new Object[]{queryFieldModel.getQueryFieldNumber(), queryFieldModel.getFieldName(), queryFieldModel.getQueryFieldNumber(), queryFieldModel.getFullFieldName(), queryFieldModel.getFullFieldNumber(), queryFieldModel.getValueType(), queryFieldModel.getFieldType(), CollectionUtils.isEmpty((Collection)queryFieldModel.getComboItemList()) ? "" : JSONObject.toJSONString((Object)queryFieldModel.getComboItemList()), queryFieldModel.getEntityNumber(), queryFieldModel.getEntityName()});
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        model.batchCreateNewEntryRow("queryentryentity", vs);
        model.endInit();
        this.getView().updateView("queryentryentity");
        this.deleteNoCheckField(fullFieldNumbers, "queryentryentity", "fullfieldnumber");
    }

    private void deleteNoCheckField(String[] fullFieldNumbers, String entryEntityKey, String fullFieldNumberName) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entryEntityKey);
        HashSet<String> fullFieldNumberList = new HashSet<String>(Arrays.asList(fullFieldNumbers));
        ArrayList needDelIdxList = Lists.newArrayListWithExpectedSize((int)16);
        for (int i = 0; i < entryEntity.size(); ++i) {
            if (fullFieldNumberList.contains(((DynamicObject)entryEntity.get(i)).getString(fullFieldNumberName))) continue;
            needDelIdxList.add(i);
        }
        this.deleteEntryEntityRows(needDelIdxList, entryEntityKey);
    }

    private TableValueSetter generateTableValueSetter(List<String> entityFieldList) {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        entityFieldList.forEach(entityField -> vs.addField(entityField, new Object[0]));
        return vs;
    }

    private void setFieldComboItems(String entityObjFieldName, String fieldName) {
        DynamicObject entityObj;
        int currentIndex = this.getModel().getEntryCurrentRowIndex("relentryentity");
        DynamicObjectCollection relEntryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("relentryentity");
        DynamicObject relEntryOne = (DynamicObject)relEntryEntity.get(currentIndex);
        if (!ObjectUtils.isEmpty((Object)relEntryOne) && (entityObj = relEntryOne.getDynamicObject(entityObjFieldName)) != null) {
            List<ComboItem> comboItemList = this.getEntityFieldComboFieldVal(entityObj.getString("number"));
            ComboEdit keyFieldEdit = (ComboEdit)this.getControl(fieldName);
            keyFieldEdit.setComboItems(comboItemList);
        }
    }

    public List<ComboItem> getEntityFieldComboFieldVal(String entityNumber) {
        List allEntityItemList = MetadataUtils.getAllEntityItems((String)entityNumber);
        if (CollectionUtils.isEmpty((Collection)allEntityItemList)) {
            return new ArrayList<ComboItem>();
        }
        ArrayList entityFieldItemList = new ArrayList(10);
        HashSet entryFieldSet = new HashSet(16);
        allEntityItemList.forEach(entityItem -> {
            if (entityItem instanceof Field) {
                entityFieldItemList.add(entityItem);
            }
            if (entityItem instanceof EntryEntity) {
                ((EntryEntity)entityItem).getItems().forEach(entryItem -> entryFieldSet.add(entryItem.getKey()));
            }
        });
        ArrayList comboItems = Lists.newArrayListWithExpectedSize((int)allEntityItemList.size());
        ComboItem idItem = new ComboItem();
        idItem.setCaption(new LocaleString("id"));
        idItem.setValue("id");
        comboItems.add(idItem);
        entityFieldItemList.forEach(pro -> {
            if (entryFieldSet.contains(pro.getKey())) {
                return;
            }
            if (pro instanceof Field && StringUtils.isNotEmpty((String)((Field)pro).getFieldName())) {
                if (pro instanceof BasedataField) {
                    ComboItem refIdItem = new ComboItem();
                    refIdItem.setCaption(new LocaleString(pro.getKey() + "." + "id"));
                    refIdItem.setValue(pro.getKey() + "." + "id");
                    comboItems.add(refIdItem);
                    ((BasedataField)pro).getRefProps().forEach(refProp -> {
                        if (refProp.getName().indexOf(".") > 0) {
                            return;
                        }
                        ComboItem comboItem = new ComboItem();
                        comboItem.setCaption(new LocaleString(pro.getKey() + "." + refProp.getName()));
                        comboItem.setValue(pro.getKey() + "." + refProp.getName());
                        comboItems.add(comboItem);
                    });
                } else {
                    ComboItem comboItem = new ComboItem();
                    comboItem.setCaption(new LocaleString(pro.getKey()));
                    comboItem.setValue(pro.getKey());
                    comboItems.add(comboItem);
                }
            }
        });
        return comboItems;
    }
}

