/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.formplugin.web.queryapi.form;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.hdtc.hrdbs.formplugin.web.HDTCDataBaseEdit;
import kd.hdtc.hrdi.common.queryapi.model.QueryEntityModel;

public class QueryApiSelectFieldFormPlugin
extends HDTCDataBaseEdit
implements TreeNodeClickListener,
TreeNodeCheckListener {
    public static final String FormId_SelectField = "botp_selectfield";
    private static final String CACHE_KEY_SELECTED_NODE_IDS = "nodeids";
    public static final String Key_btnOK = "btnok";
    public static final String Key_btnCancel = "btncancel";
    public static final String Key_TreeView = "tv_fields";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{Key_btnOK, Key_btnCancel});
        TreeView tv = (TreeView)this.getView().getControl(Key_TreeView);
        tv.addTreeNodeClickListener((TreeNodeClickListener)this);
        tv.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        if (!this.isMultiSelected()) {
            tv.setMulti(false);
        }
    }

    public void afterCreateNewData(EventObject eventObject) {
        super.afterCreateNewData(eventObject);
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.fillTreeNodes();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if (Key_btnOK.equalsIgnoreCase(ctlSource.getKey())) {
            String currNodeId = this.getPageCache().get(CACHE_KEY_SELECTED_NODE_IDS);
            if (StringUtils.isNotBlank((CharSequence)currNodeId)) {
                this.getView().returnDataToParent((Object)currNodeId);
            } else {
                this.getView().returnDataToParent((Object)"");
            }
            this.getView().close();
        } else if (Key_btnCancel.equalsIgnoreCase(ctlSource.getKey())) {
            this.getView().close();
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        if (this.isMultiSelected()) {
            return;
        }
        String currNodeId = (String)e.getNodeId();
        if ("0".equals(currNodeId)) {
            currNodeId = "";
        }
        this.getPageCache().put(CACHE_KEY_SELECTED_NODE_IDS, currNodeId);
    }

    public void treeNodeDoubleClick(TreeNodeEvent e) {
        if (this.isMultiSelected()) {
            return;
        }
        String currNodeId = (String)e.getNodeId();
        if ("0".equals(currNodeId)) {
            currNodeId = "";
        }
        if (StringUtils.isBlank((CharSequence)currNodeId)) {
            return;
        }
        this.getView().returnDataToParent((Object)currNodeId);
        this.getView().close();
    }

    public void treeNodeCheck(TreeNodeCheckEvent e) {
        String cacheNodeIds = "";
        TreeView treeView = (TreeView)e.getSource();
        List checkedNodeIds = treeView.getTreeState().getCheckedNodeIds();
        if (checkedNodeIds != null) {
            checkedNodeIds.remove("0");
            cacheNodeIds = StringUtils.join((Object[])checkedNodeIds.toArray(), (String)",");
        }
        this.getPageCache().put(CACHE_KEY_SELECTED_NODE_IDS, cacheNodeIds);
    }

    private TreeNode getRootTreeNode() {
        TreeNode treeNode = this.addTreeRootNode();
        treeNode.setIsOpened(true);
        treeNode.setChildren(new ArrayList());
        String entityNodeListStr = (String)this.getView().getFormShowParameter().getCustomParam("queryEntityList");
        String fieldNodeListStr = (String)this.getView().getFormShowParameter().getCustomParam("queryFieldList");
        if (StringUtils.isNotEmpty((CharSequence)entityNodeListStr)) {
            List queryEntityModelList = JSONObject.parseArray((String)entityNodeListStr, QueryEntityModel.class);
            Map entityNumberAndQueryFieldListMap = (Map)JSONObject.parseObject((String)fieldNodeListStr, Map.class);
            queryEntityModelList.forEach(queryEntityModel -> {
                TreeNode entryNode = new TreeNode(treeNode.getId(), queryEntityModel.getEntityNumber(), queryEntityModel.getEntityName());
                List fieldTreeNodes = (List)entityNumberAndQueryFieldListMap.get(queryEntityModel.getEntityNumber());
                entryNode.addChildren(JSONObject.parseArray((String)JSONObject.toJSONString((Object)fieldTreeNodes), TreeNode.class));
                treeNode.getChildren().add(entryNode);
            });
        }
        return treeNode;
    }

    private void fillTreeNodes() {
        TreeNode rootNode = this.getRootTreeNode();
        TreeView tree = (TreeView)this.getView().getControl(Key_TreeView);
        tree.addNode(rootNode);
        if (this.isMultiSelected()) {
            tree.setMulti(true);
            String cacheNodeIds = (String)this.getView().getFormShowParameter().getCustomParam(CACHE_KEY_SELECTED_NODE_IDS);
            if (StringUtils.isNotBlank((CharSequence)cacheNodeIds)) {
                this.getPageCache().put(CACHE_KEY_SELECTED_NODE_IDS, cacheNodeIds);
                String[] arr = StringUtils.split((String)cacheNodeIds, (String)",");
                ArrayList<TreeNode> selectedNodes = new ArrayList<TreeNode>();
                for (String nodeId : arr) {
                    TreeNode node = rootNode.getTreeNode(nodeId, 5);
                    if (node == null) continue;
                    selectedNodes.add(node);
                }
                if (selectedNodes.size() > 0) {
                    tree.checkNodes(selectedNodes);
                }
            }
        }
    }

    private TreeNode addTreeRootNode() {
        return new TreeNode("", "0", ResManager.loadKDString((String)"\u5355\u636e\u5b57\u6bb5\u5217\u8868", (String)"QuerySelectFieldList_0", (String)"bos-designer-plugin", (Object[])new Object[0]));
    }

    private boolean isMultiSelected() {
        String isMulti = (String)this.getView().getFormShowParameter().getCustomParam("ismulti");
        if (StringUtils.isBlank((CharSequence)isMulti)) {
            return false;
        }
        return isMulti.equalsIgnoreCase("true") || isMulti.equalsIgnoreCase("1");
    }
}

