/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.adaptor.common;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdi.adaptor.common.IBizCommonSync;
import kd.hdtc.hrdi.adaptor.outbound.OrgCommonSync;
import kd.hdtc.hrdi.adaptor.outbound.PersonCommonSync;
import kd.hdtc.hrdi.adaptor.outbound.PositionCommonSync;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.config.IHRDIBaseConfigDomainService;
import kd.hdtc.hrdi.business.domain.intgovern.IIntRelationDomainService;
import kd.hr.hbp.business.service.message.IHRMsgTplService;
import kd.hr.hbp.common.mservice.HRMServiceResult;

public class ChangeEventCommonConsumer
implements IHRMsgTplService {
    private static final Log LOG = LogFactory.getLog(ChangeEventCommonConsumer.class);
    private IHRDIBaseConfigDomainService ihrdiBaseConfigDomainService = (IHRDIBaseConfigDomainService)ServiceFactory.getService(IHRDIBaseConfigDomainService.class);
    private IIntRelationDomainService relationDomainService = (IIntRelationDomainService)ServiceFactory.getService(IIntRelationDomainService.class);
    private static final Map<String, IBizCommonSync> ENTITY_MAP = ImmutableMap.builder().put((Object)"haos_adminorgdetail", (Object)new OrgCommonSync()).put((Object)"hbpm_position_api", (Object)new PositionCommonSync()).put((Object)"hrpi_emp_integrate", (Object)new PersonCommonSync()).put((Object)"hrpi_peraddress", (Object)new PersonCommonSync()).build();

    public HRMServiceResult consumerSaveMsg(DynamicObject tplDy) {
        String realTimeOpen = this.ihrdiBaseConfigDomainService.queryBaseConfigValueByNumber("real.time.open");
        LOG.info("consumerSaveMsg start : realTimeOpen:{}", (Object)realTimeOpen);
        if (!"1".equals(realTimeOpen)) {
            return HRMServiceResult.success();
        }
        String msgSubNo = tplDy.getString("msgsubno");
        String entityNumber = this.relationDomainService.queryEntityNumberByMsgSubscriberNumber(msgSubNo);
        LOG.info("consumerSaveMsg doSync start : msgSubNo:{},entityNumber:{}", (Object)msgSubNo, (Object)entityNumber);
        if (StringUtils.isEmpty((String)entityNumber)) {
            return HRMServiceResult.success();
        }
        IBizCommonSync iBizCommonSync = ENTITY_MAP.get(entityNumber);
        if (iBizCommonSync != null) {
            iBizCommonSync.doSync(tplDy, entityNumber);
        } else {
            LOG.info("PersonCommonSync doSync");
            new PersonCommonSync().doSync(tplDy, entityNumber);
        }
        LOG.info("consumerSaveMsg end : msgSubNo:{},entityNumber:{}", (Object)msgSubNo, (Object)entityNumber);
        return HRMServiceResult.success();
    }
}

