/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.adaptor.inbound.biz;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdi.adaptor.inbound.biz.common.BizSyncSceneAdaptorDefault;
import kd.hdtc.hrdi.adaptor.inbound.biz.handle.DataCompareHandle;
import kd.hdtc.hrdi.adaptor.inbound.biz.sceneadaptor.handle.ISceneHandle;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.adaptor.IBizSyncAdaptor;
import kd.hdtc.hrdi.business.domain.adaptor.IIntSceneRuleDomainService;
import kd.hdtc.hrdi.business.domain.adaptor.context.IntBizSyncContext;
import kd.hdtc.hrdi.business.domain.adaptor.context.IntRowResult;
import kd.hdtc.hrdi.business.domain.intgovern.IIntEntityCategoryDomainService;
import kd.hdtc.hrdi.common.adaptor.enums.IntSceneEnum;
import kd.hdtc.hrdi.common.enums.BizCategoryEnum;
import kd.hr.hbp.business.log.EntityModifyInfo;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.hdtc.hrdi.adaptor.api.IBizSyncSceneAdaptor;
import kd.sdk.hdtc.hrdi.adaptor.extend.IBizSyncSceneExtendAdaptor;

public abstract class AbstractBizSceneAdapter
implements IBizSyncAdaptor {
    private static final Log LOG = LogFactory.getLog(AbstractBizSceneAdapter.class);
    private final IIntSceneRuleDomainService iIntSceneRuleDomainService = (IIntSceneRuleDomainService)ServiceFactory.getService(IIntSceneRuleDomainService.class);
    private final IIntEntityCategoryDomainService domainService = (IIntEntityCategoryDomainService)ServiceFactory.getService(IIntEntityCategoryDomainService.class);
    protected Map<String, String> sceneTypeAndClassPathMap;
    protected Map<IntSceneEnum, ISceneHandle> SCENE_HANDLE_MAP;
    protected Map<String, Object> modifyFieldMap = new HashMap<String, Object>();
    protected DynamicObject sceneRule;
    private final Map<String, String> personAttachedClassMap = ImmutableMap.of((Object)"40", (Object)"kd.hdtc.hrdi.adaptor.inbound.biz.personattached.PersonAttachedCreateMServiceAdaptor", (Object)"50", (Object)"kd.hdtc.hrdi.adaptor.inbound.biz.personattached.PersonAttachedChangeMServiceAdaptor", (Object)"100", (Object)"kd.hdtc.hrdi.adaptor.inbound.biz.personattached.PersonAttachedDeleteMServiceAdaptor");
    private String bizEntityKey;

    public AbstractBizSceneAdapter() {
        this.sceneRule = this.iIntSceneRuleDomainService.getEnabledSceneRule(IntBizSyncContext.get().getBizEntityNumber());
    }

    public void sync() {
        LOG.info("1.sync compare start.");
        new DataCompareHandle().compare();
        LOG.info("2.sync dataSort start.");
        this.dataSort();
        LOG.info("3.sync initSceneType start.");
        this.initSceneType();
        LOG.info("4.sync sceneAdaptor start.");
        this.sceneAdaptor();
        Map<IntSceneEnum, List<IntRowResult>> sceneTypeIntRowResultListMap = this.intSceneGroup();
        LOG.info("6.sync bizServiceInvoke start.");
        this.bizServiceInvoke(sceneTypeIntRowResultListMap);
    }

    protected Map<IntSceneEnum, List<IntRowResult>> intSceneGroup() {
        List rowResultList = IntBizSyncContext.get().getSortedIntRowResultList();
        HashMap<IntSceneEnum, List<IntRowResult>> resultMap = new HashMap<IntSceneEnum, List<IntRowResult>>(16);
        rowResultList.forEach(rowResult -> {
            IntSceneEnum sceneType = rowResult.getSceneType();
            if (sceneType == null) {
                rowResult.setSuccess(Boolean.valueOf(true));
            } else {
                List intRowResultList = resultMap.getOrDefault(sceneType, new ArrayList(10));
                intRowResultList.add(rowResult);
                resultMap.put(sceneType, intRowResultList);
            }
        });
        return resultMap;
    }

    protected void dataSort() {
        IntBizSyncContext.get().addSortedIntRowResultList(IntBizSyncContext.get().getIntRowResultList());
    }

    private void initSceneType() {
        this.sceneTypeAndClassPathMap = this.getSceneTypeAndClassPathMap(this.sceneRule);
    }

    protected void bizServiceInvoke(Map<IntSceneEnum, List<IntRowResult>> sceneTypeIntRowResultListMap) {
        if (CollectionUtils.isEmpty(sceneTypeIntRowResultListMap)) {
            return;
        }
        IntSceneEnum[] intSceneEnums = IntSceneEnum.values();
        Arrays.stream(intSceneEnums).forEach(intSceneEnum -> {
            List rowResultList = (List)sceneTypeIntRowResultListMap.get(intSceneEnum);
            if (CollectionUtils.isNotEmpty((Collection)rowResultList)) {
                String classPath = this.sceneTypeAndClassPathMap.get(intSceneEnum.getSceneType());
                IBizSyncSceneAdaptor bizSyncSceneAdaptor = (IBizSyncSceneAdaptor)TypesContainer.createInstance((String)classPath);
                this.syncExtHandle(bizSyncSceneAdaptor, rowResultList);
            }
        });
    }

    private void syncExtHandle(IBizSyncSceneAdaptor bizSyncSceneAdaptor, List<IntRowResult> rowResultList) {
        DynamicObject[] dyns = (DynamicObject[])rowResultList.stream().map(dy -> dy.getBizDataSyncDataMappingBo().getBizDynamicObject()).toArray(DynamicObject[]::new);
        HRPluginProxy pluginProxy = HRPlugInProxyFactory.create((Object)new BizSyncSceneAdaptorDefault(), IBizSyncSceneExtendAdaptor.class, (String)"kd.sdk.hdtc.hrdi.adaptor.extend.IBizSyncSceneExtendAdaptor", null);
        pluginProxy.callBefore(adaptorExt -> {
            adaptorExt.beforeSync(dyns);
            return null;
        });
        HRPluginProxy replacePluginProxy = HRPlugInProxyFactory.create((Object)bizSyncSceneAdaptor, IBizSyncSceneAdaptor.class, (String)"kd.sdk.hdtc.hrdi.adaptor.api.IBizSyncSceneAdaptor", null);
        HashMap errorInfoMap = Maps.newHashMapWithExpectedSize((int)16);
        try (TXHandle txHandle = TX.requiresNew();){
            List resultList = replacePluginProxy.callReplaceIfPresent(adaptor -> adaptor.sync(dyns));
            if (CollectionUtils.isNotEmpty((Collection)resultList) && CollectionUtils.isNotEmpty((Map)((Map)resultList.get(0)))) {
                errorInfoMap.putAll((Map)resultList.get(0));
            }
            ArrayList<DynamicObject> successDynList = new ArrayList<DynamicObject>(16);
            String key = this.getBizEntityKey(dyns[0]);
            for (DynamicObject dyn : dyns) {
                if (errorInfoMap.containsKey(dyn.get(key) + "")) continue;
                successDynList.add(dyn);
            }
            if (CollectionUtils.isNotEmpty(successDynList)) {
                pluginProxy.callAfter(adaptorExt -> {
                    adaptorExt.afterSyncSuccess(successDynList);
                    return null;
                });
            }
            pluginProxy.callAfter(adaptorExt -> {
                adaptorExt.afterSync(dyns[0].getDataEntityType().getName(), errorInfoMap);
                return null;
            });
            LOG.info("AbstractBizSceneAdapter bizSyncSceneAdaptor:{},parseResult:{}", (Object)bizSyncSceneAdaptor.getClass().getName(), (Object)errorInfoMap);
            this.parseResult(errorInfoMap, rowResultList);
        }
    }

    protected String getBizEntityKey(DynamicObject bizDyn) {
        if (StringUtils.isNotEmpty((String)this.bizEntityKey)) {
            return this.bizEntityKey;
        }
        DataEntityPropertyCollection properties = bizDyn.getDataEntityType().getProperties();
        Set propertiesSet = properties.stream().map(IMetadata::getName).collect(Collectors.toSet());
        this.bizEntityKey = propertiesSet.contains("number") ? "number" : "id";
        return this.bizEntityKey;
    }

    protected void parseResult(Map<String, String> errorMap, List<IntRowResult> rowResultList) {
        boolean allFailed = errorMap.containsKey("allFailed");
        for (IntRowResult rowResult : rowResultList) {
            String bizEntityKey;
            rowResult.setException(Boolean.FALSE);
            if (allFailed) {
                rowResult.setErrorMsg(errorMap.get("allFailed"));
                rowResult.setSuccess(Boolean.FALSE);
                continue;
            }
            DynamicObject bizDy = rowResult.getBizDataSyncDataMappingBo().getBizDynamicObject();
            String number = bizDy.get(bizEntityKey = this.getBizEntityKey(bizDy)) + "";
            String errorInfo = errorMap.get(number);
            if (StringUtils.isNotEmpty((String)errorInfo)) {
                rowResult.setErrorMsg(errorInfo);
                rowResult.setSuccess(Boolean.FALSE);
                continue;
            }
            rowResult.setErrorMsg("");
            rowResult.setSuccess(Boolean.TRUE);
        }
    }

    protected void sceneAdaptor() {
        this.initSceneHandle();
        this.doSceneAdaptor();
    }

    protected void doSceneAdaptor() {
        this.beforeDoSceneAdaptor();
        Map compareMap = IntBizSyncContext.get().getCompareMap();
        compareMap.forEach((intRowResult, entityModifyInfo) -> {
            this.buildModifyFieldMap((EntityModifyInfo)entityModifyInfo, (IntRowResult)intRowResult);
            for (Map.Entry<IntSceneEnum, ISceneHandle> next : this.SCENE_HANDLE_MAP.entrySet()) {
                ISceneHandle iSceneHandle;
                IntSceneEnum intSceneEnum = next.getKey();
                if (!this.sceneTypeAndClassPathMap.containsKey(intSceneEnum.getSceneType()) || !(iSceneHandle = next.getValue()).isFindScene(this.modifyFieldMap)) continue;
                intRowResult.setSceneType(intSceneEnum);
                break;
            }
        });
    }

    protected void beforeDoSceneAdaptor() {
    }

    protected void buildModifyFieldMap(EntityModifyInfo entityModifyInfo, IntRowResult intRowResult) {
        this.modifyFieldMap.clear();
        this.modifyFieldMap.put("entityModifyInfo", entityModifyInfo);
        boolean delete = ((DynamicObject)intRowResult.getBizDataSyncDataMappingBo().getMidDynamicObjectList().get(0)).getBoolean("is_delete");
        if (delete) {
            this.modifyFieldMap.put("deleteField", entityModifyInfo);
            this.modifyFieldMap.put("intRowResult", intRowResult);
        }
        List fields = entityModifyInfo.getFields();
        fields.forEach(field -> {
            if ("enable".equals(field.getFieldName())) {
                this.modifyFieldMap.put("enableModifyField", field);
            }
        });
    }

    protected abstract void initSceneHandle();

    private Map<String, String> getSceneTypeAndClassPathMap(DynamicObject enabledSceneRule) {
        if (enabledSceneRule == null) {
            BizCategoryEnum categoryEnum = this.domainService.getCategoryByEntityNumber(IntBizSyncContext.get().getBizEntityNumber());
            if (BizCategoryEnum.PERSON_ATTACHED.getCode().equals(categoryEnum.getCode())) {
                return this.personAttachedClassMap;
            }
            LOG.error("can not find enabledSceneRule.");
            return null;
        }
        LinkedHashMap sceneTypeAndClassPathMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
        DynamicObjectCollection ruleEntry = enabledSceneRule.getDynamicObjectCollection("ruleentry");
        if (CollectionUtils.isNotEmpty((Collection)ruleEntry)) {
            ruleEntry.forEach(rule -> sceneTypeAndClassPathMap.put(rule.getString("scenetype"), rule.getString("classpath")));
        }
        return sceneTypeAndClassPathMap;
    }

    private static /* synthetic */ void lambda$syncExtHandle$8(Exception ex, IntRowResult rowResult) {
        rowResult.setException(Boolean.TRUE);
        rowResult.setErrorMsg(ex.toString());
        rowResult.setSuccess(Boolean.FALSE);
    }
}

