/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.adaptor.inbound.biz.adminorg;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdi.adaptor.inbound.biz.adminorg.AbstractAdminOrgBizSyncSceneBaseAdaptor;
import kd.hdtc.hrdi.adaptor.inbound.biz.common.BizMServiceLog;
import kd.hdtc.hrdi.business.application.external.entity.IAdminOrgEntityService;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.adaptor.context.IntBizSyncContext;
import kd.hdtc.hrdi.business.domain.adaptor.context.IntRowResult;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;

public class AdminOrgChangeMServiceAdaptor
extends AbstractAdminOrgBizSyncSceneBaseAdaptor {
    private static final Log LOG = LogFactory.getLog(AdminOrgChangeMServiceAdaptor.class);
    protected final IAdminOrgEntityService iAdminOrgEntityService = (IAdminOrgEntityService)ServiceFactory.getService(IAdminOrgEntityService.class);

    @Override
    protected Map<String, String> doSync() {
        LOG.info("IBizSyncSceneAdaptor AdminOrgChangeMServiceAdaptor toOrgFastChgInfoList start.");
        ArrayList<DynamicObject> dynamicObjects = this.toOrgFastChgInfoList(this.dys);
        Map<String, Object> changeOrgResultMap = this.callMService(dynamicObjects);
        Map errorMap = Maps.newHashMap();
        if (changeOrgResultMap.get("data") != null) {
            errorMap = (Map)changeOrgResultMap.get("data");
        }
        return errorMap;
    }

    protected Map<String, Object> callMService(ArrayList<DynamicObject> dynamicObjects) {
        LOG.info("IBizSyncSceneAdaptor AdminOrgChangeMServiceAdaptor callMService, data count{}.", (Object)dynamicObjects.size());
        BizMServiceLog mServiceLog = new BizMServiceLog();
        Map resultMap = this.iAdminOrgEntityService.changeAdminOrg(dynamicObjects);
        LOG.info("IBizSyncSceneAdaptor AdminOrgChangeMServiceAdaptor callMService, result.", (Object)resultMap);
        mServiceLog.end();
        return resultMap;
    }

    private ArrayList<DynamicObject> toOrgFastChgInfoList(DynamicObject[] adminOrgs) {
        ArrayList orgFastChgAddList = Lists.newArrayListWithExpectedSize((int)adminOrgs.length);
        Map bizIdIntRowResultMap = IntBizSyncContext.get().getRowMap();
        for (DynamicObject adminOrg : adminOrgs) {
            DynamicObject orgFastChgAdd = this.toOrgFastChgInfo(adminOrg, bizIdIntRowResultMap);
            orgFastChgAddList.add(orgFastChgAdd);
        }
        return orgFastChgAddList;
    }

    private DynamicObject toOrgFastChgInfo(DynamicObject adminOrg, Map<Long, IntRowResult> bizIdIntRowResultMap) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("homs_orgfastchginfo");
        DynamicObject orgFastChgInfo = hrBaseServiceHelper.generateEmptyDynamicObject();
        HRDynamicObjectUtils.copy((DynamicObject)adminOrg, (DynamicObject)orgFastChgInfo);
        IntRowResult intRowResult = bizIdIntRowResultMap.get(adminOrg.getLong("id"));
        DynamicObject currentBizDynamicObject = intRowResult.getBizDataSyncDataMappingBo().getCurrentBizDynamicObject();
        orgFastChgInfo.set("adminorg", (Object)currentBizDynamicObject);
        orgFastChgInfo.set("nameold", currentBizDynamicObject.get("name"));
        orgFastChgInfo.set("parentorgold", currentBizDynamicObject.get("parentorg"));
        orgFastChgInfo.set("effdt", adminOrg.get("bsed"));
        orgFastChgInfo.set("establishmentdate", adminOrg.get("establishmentdate"));
        DynamicObjectCollection dynamicObjectCollection = orgFastChgInfo.getDynamicObjectCollection("entryentity");
        DynamicObject row = dynamicObjectCollection.addNew();
        row.set("adminorgboid", (Object)adminOrg.getLong("id"));
        orgFastChgInfo.set("openapiflag", (Object)"1");
        this.fillBizMustField(orgFastChgInfo, adminOrg, currentBizDynamicObject);
        return orgFastChgInfo;
    }
}

