/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.adaptor.inbound.biz.adminorg;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hdtc.hrdi.adaptor.inbound.biz.adminorg.AbstractAdminOrgBizSyncSceneBaseAdaptor;
import kd.hdtc.hrdi.adaptor.inbound.biz.common.BizMServiceLog;
import kd.hdtc.hrdi.business.application.external.entity.IAdminOrgEntityService;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.adaptor.context.IntBizSyncContext;
import kd.hdtc.hrdi.business.domain.adaptor.context.IntRowResult;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class AdminOrgChangeParentMServiceAdaptor
extends AbstractAdminOrgBizSyncSceneBaseAdaptor {
    private static final Log LOG = LogFactory.getLog(AdminOrgChangeParentMServiceAdaptor.class);
    protected final IAdminOrgEntityService iAdminOrgEntityService = (IAdminOrgEntityService)ServiceFactory.getService(IAdminOrgEntityService.class);

    @Override
    protected Map<String, String> doSync() {
        LOG.info("IBizSyncSceneAdaptor AdminOrgChangeParentMServiceAdaptor toOrgFastChgParentList start.");
        ArrayList<DynamicObject> dynamicObjects = this.toOrgFastChgParentList(this.dys);
        Map<String, Object> changeOrgResultMap = this.callMService(dynamicObjects);
        LOG.info("IBizSyncSceneAdaptor AdminOrgChangeParentMServiceAdaptor callMService, result.", changeOrgResultMap);
        Map errorMap = Maps.newHashMap();
        if (changeOrgResultMap.get("data") != null) {
            errorMap = (Map)changeOrgResultMap.get("data");
        }
        return errorMap;
    }

    protected Map<String, Object> callMService(ArrayList<DynamicObject> dynamicObjects) {
        LOG.info("IBizSyncSceneAdaptor AdminOrgChangeParentMServiceAdaptor callMService, data count{}.", (Object)dynamicObjects.size());
        BizMServiceLog mServiceLog = new BizMServiceLog();
        Map resultMap = this.iAdminOrgEntityService.changeParentAdminOrg(dynamicObjects);
        mServiceLog.end();
        return resultMap;
    }

    private ArrayList<DynamicObject> toOrgFastChgParentList(DynamicObject[] adminOrgs) {
        ArrayList orgFastChgAddList = Lists.newArrayListWithExpectedSize((int)adminOrgs.length);
        Map bizIdIntRowResultMap = IntBizSyncContext.get().getRowMap();
        List targetFieldNumberList = MetadataUtils.getFieldNumberList((String)"homs_orgfastchgparent");
        for (int i = 0; i < adminOrgs.length; ++i) {
            DynamicObject orgFastChgAdd = this.toOrgFastChgParent(adminOrgs[i], targetFieldNumberList, bizIdIntRowResultMap);
            orgFastChgAddList.add(orgFastChgAdd);
        }
        return orgFastChgAddList;
    }

    private DynamicObject toOrgFastChgParent(DynamicObject adminOrg, List<String> targetFieldNumberList, Map<Long, IntRowResult> bizIdIntRowResultMap) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("homs_orgfastchgparent");
        DynamicObject orgFastChgInfo = hrBaseServiceHelper.generateEmptyDynamicObject();
        List fieldNumberList = IntBizSyncContext.get().getFieldNumberList();
        fieldNumberList.forEach(fieldNumber -> {
            if (targetFieldNumberList.contains(fieldNumber)) {
                orgFastChgInfo.set(fieldNumber, adminOrg.get(fieldNumber));
            }
        });
        IntRowResult intRowResult = bizIdIntRowResultMap.get(adminOrg.getLong("id"));
        DynamicObject currentBizDynamicObject = intRowResult.getBizDataSyncDataMappingBo().getCurrentBizDynamicObject();
        orgFastChgInfo.set("adminorg", (Object)currentBizDynamicObject);
        orgFastChgInfo.set("nameold", currentBizDynamicObject.get("name"));
        orgFastChgInfo.set("parentorgold", currentBizDynamicObject.get("parentorg"));
        orgFastChgInfo.set("effdt", adminOrg.get("bsed"));
        orgFastChgInfo.set("establishmentdate", adminOrg.get("establishmentdate"));
        DynamicObjectCollection dynamicObjectCollection = orgFastChgInfo.getDynamicObjectCollection("entryentity");
        DynamicObject row = dynamicObjectCollection.addNew();
        row.set("adminorgboid", (Object)adminOrg.getLong("id"));
        orgFastChgInfo.set("openapiflag", (Object)"1");
        this.fillBizMustField(orgFastChgInfo, adminOrg, currentBizDynamicObject);
        return orgFastChgInfo;
    }
}

