/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.adaptor.inbound.biz.adminorg;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdi.adaptor.inbound.biz.adminorg.AbstractAdminOrgBizSyncSceneBaseAdaptor;
import kd.hdtc.hrdi.adaptor.inbound.biz.common.BizMServiceLog;
import kd.hdtc.hrdi.business.application.external.entity.IAdminOrgEntityService;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.adaptor.context.IntBizSyncContext;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;

public class AdminOrgCreateMServiceAdaptor
extends AbstractAdminOrgBizSyncSceneBaseAdaptor {
    private static final Log LOG = LogFactory.getLog(AdminOrgCreateMServiceAdaptor.class);
    private final IAdminOrgEntityService iAdminOrgEntityService = (IAdminOrgEntityService)ServiceFactory.getService(IAdminOrgEntityService.class);
    private boolean buField;
    private Map<Long, DynamicObject> adminOrgIdDynMap;

    @Override
    public Map<String, String> doSync() {
        LOG.info("IBizSyncSceneAdaptor AdminOrgCreateMServiceAdaptor toOrgFastChgAddList start.");
        ArrayList<DynamicObject> dynamicObjects = this.toOrgFastChgAddList(this.dys);
        LOG.info("IBizSyncSceneAdaptor AdminOrgCreateMServiceAdaptor callMService, data count{}.", (Object)dynamicObjects.size());
        BizMServiceLog mServiceLog = new BizMServiceLog();
        Map resultMap = this.iAdminOrgEntityService.addNewAdminOrg(dynamicObjects);
        LOG.info("IBizSyncSceneAdaptor AdminOrgCreateMServiceAdaptor callMService, result.", (Object)resultMap);
        mServiceLog.end();
        Map errorMap = Maps.newHashMap();
        if (resultMap.get("data") != null) {
            Map failInfoMap = (Map)resultMap.get("data");
            errorMap = (Map)failInfoMap.get("fail");
        }
        return errorMap;
    }

    private ArrayList<DynamicObject> toOrgFastChgAddList(DynamicObject[] adminOrgs) {
        ArrayList orgFastChgAddList = Lists.newArrayListWithExpectedSize((int)adminOrgs.length);
        this.buField = this.hasBuField(adminOrgs[0]);
        this.adminOrgIdDynMap = Maps.newHashMapWithExpectedSize((int)adminOrgs.length);
        for (int i = 0; i < adminOrgs.length; ++i) {
            DynamicObject orgFastChgAdd = this.toOrgFastChgAdd(adminOrgs[i], i + 1);
            orgFastChgAddList.add(orgFastChgAdd);
            this.adminOrgIdDynMap.put(adminOrgs[i].getLong("id"), orgFastChgAdd);
        }
        return orgFastChgAddList;
    }

    private DynamicObject toOrgFastChgAdd(DynamicObject adminOrg, int index) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("homs_orgfastchgadd");
        DynamicObject orgFastChgAdd = hrBaseServiceHelper.generateEmptyDynamicObject();
        List fieldNumberList = IntBizSyncContext.get().getFieldNumberList();
        fieldNumberList.remove("enable");
        HRDynamicObjectUtils.copy((DynamicObject)adminOrg, (DynamicObject)orgFastChgAdd);
        orgFastChgAdd.set("org", (Object)this.getBuDynamicObject(adminOrg));
        orgFastChgAdd.set("orgid", (Object)adminOrg.getLong("id"));
        orgFastChgAdd.set("effdt", adminOrg.get("bsed"));
        orgFastChgAdd.set("establishmentdate", adminOrg.get("bsed"));
        int idx = adminOrg.getInt("index");
        orgFastChgAdd.set("index", (Object)(idx != 0 ? idx : index));
        DynamicObject parentOrgDyn = orgFastChgAdd.getDynamicObject("parentorg");
        if (parentOrgDyn != null && parentOrgDyn.getLong("boid") == 0L) {
            parentOrgDyn.set("boid", parentOrgDyn.get("id"));
        }
        this.fillBizMustField(orgFastChgAdd, adminOrg, null);
        return orgFastChgAdd;
    }

    private DynamicObject getBuDynamicObject(DynamicObject adminOrg) {
        DynamicObject buDyn = null;
        if (this.buField) {
            buDyn = adminOrg.getDynamicObject("org");
        }
        if (adminOrg.getDynamicObject("parentorg") == null) {
            return buDyn;
        }
        if (buDyn == null) {
            buDyn = adminOrg.getDynamicObject("parentorg").getDynamicObject("org");
        }
        if (buDyn == null) {
            long parentId = adminOrg.getDynamicObject("parentorg").getLong("id");
            DynamicObject parentDyn = this.adminOrgIdDynMap.get(parentId);
            if (parentDyn == null) {
                return null;
            }
            buDyn = parentDyn.getDynamicObject("org");
        }
        return buDyn;
    }

    private boolean hasBuField(DynamicObject adminOrg) {
        DataEntityPropertyCollection properties = adminOrg.getDataEntityType().getProperties();
        boolean orgField = false;
        for (IDataEntityProperty property : properties) {
            if (!"org".equals(property.getName())) continue;
            orgField = true;
            break;
        }
        return orgField;
    }
}

