/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.adaptor.inbound.biz.bizdataquery;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrdbs.common.constants.QFilterConstants;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hdtc.hrdi.adaptor.inbound.biz.bizdataquery.IBizDataQueryHandle;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.common.IBaseCommonDomainService;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;

public class AdminOrgDataQueryHandle
implements IBizDataQueryHandle {
    private static final Log LOG = LogFactory.getLog(AdminOrgDataQueryHandle.class);
    private final IBaseCommonDomainService iBaseCommonDomainService = (IBaseCommonDomainService)ServiceFactory.getService(IBaseCommonDomainService.class);
    private Map<Long, DynamicObject> adminOrgDataMap;
    private List<String> groupFieldList;
    private List<String> companyFieldList;
    private List<String> departmentFieldList;

    @Override
    public Map<Long, DynamicObject> queryBizData(String bizEntity, List<Long> pkIdList, List<String> intFieldList) {
        this.init(bizEntity, intFieldList);
        this.adminOrgDataMap = this.queryAdminOrgData(bizEntity, pkIdList, intFieldList);
        this.fillGroupyField(pkIdList);
        this.fillCompanyField(pkIdList);
        this.fillDepartmentField(pkIdList);
        return this.adminOrgDataMap;
    }

    private void init(String bizEntity, List<String> intFieldList) {
        List<String> notDbFieldList = this.getNotDbField(bizEntity, intFieldList);
        this.groupFieldList = this.getSelectField("haos_adminorggroup", notDbFieldList);
        this.fieldListLogHandle("haos_adminorggroup", this.groupFieldList);
        this.companyFieldList = this.getSelectField("haos_adminorgcompany", notDbFieldList);
        this.fieldListLogHandle("haos_adminorgcompany", this.companyFieldList);
        this.departmentFieldList = this.getSelectField("haos_adminorgdepartment", notDbFieldList);
        this.fieldListLogHandle("haos_adminorgdepartment", this.departmentFieldList);
    }

    private void fieldListLogHandle(String key, List<String> fieldList) {
        String msg = key + ":" + String.join((CharSequence)",", fieldList);
        LOG.info(msg);
    }

    private List<String> getSelectField(String bizEntity, List<String> notDbFieldList) {
        ArrayList<String> selectFieldList = new ArrayList<String>(10);
        MainEntityType mainEntityType = MetadataUtils.getMainEntityType((String)bizEntity);
        mainEntityType.getAllFields().forEach((field, prop) -> {
            if (notDbFieldList.contains(field)) {
                selectFieldList.add((String)field);
            }
        });
        return selectFieldList;
    }

    private void fillCompanyField(List<Long> adminOrgIdList) {
        if (CollectionUtils.isEmpty(this.companyFieldList)) {
            return;
        }
        Map<Object, DynamicObject> companyDynMap = this.queryAdminOrgInfo("haos_adminorgcompany", adminOrgIdList, this.companyFieldList);
        this.fillAdminOrgInfoField(companyDynMap, this.companyFieldList);
    }

    private void fillDepartmentField(List<Long> adminOrgIdList) {
        if (CollectionUtils.isEmpty(this.departmentFieldList)) {
            return;
        }
        Map<Object, DynamicObject> depDynMap = this.queryAdminOrgInfo("haos_adminorgdepartment", adminOrgIdList, this.departmentFieldList);
        this.fillAdminOrgInfoField(depDynMap, this.departmentFieldList);
    }

    private void fillGroupyField(List<Long> adminOrgIdList) {
        if (CollectionUtils.isEmpty(this.groupFieldList)) {
            return;
        }
        Map<Object, DynamicObject> groupDynMap = this.queryAdminOrgInfo("haos_adminorggroup", adminOrgIdList, this.groupFieldList);
        this.fillAdminOrgInfoField(groupDynMap, this.groupFieldList);
    }

    private List<String> getNotDbField(String bizEntity, List<String> intFieldList) {
        ArrayList<String> notDbFieldList = new ArrayList<String>(10);
        MainEntityType mainEntityType = MetadataUtils.getMainEntityType((String)bizEntity);
        mainEntityType.getAllFields().forEach((field, property) -> {
            if (StringUtils.isEmpty((String)property.getAlias()) && intFieldList.contains(field)) {
                notDbFieldList.add((String)field);
            }
        });
        return notDbFieldList;
    }

    private void fillAdminOrgInfoField(Map<Object, DynamicObject> adminOrgInfoDynMap, List<String> selectFieldList) {
        adminOrgInfoDynMap.forEach((pkId, dyn) -> {
            Long adminOrgId = dyn.getLong("adminorg.id");
            DynamicObject adminOrg = this.adminOrgDataMap.get(adminOrgId);
            if (adminOrg == null) {
                return;
            }
            selectFieldList.forEach(field -> adminOrg.set(field, dyn.get(field)));
        });
    }

    private Map<Object, DynamicObject> queryAdminOrgInfo(String bizEntity, List<Long> adminOrgIdList, List<String> selectFieldList) {
        QFilter filter = new QFilter("adminorg", "in", adminOrgIdList);
        String selectFields = String.join((CharSequence)",", selectFieldList) + "," + "adminorg";
        return this.iBaseCommonDomainService.queryByFilters(bizEntity, selectFields, new QFilter[]{filter, QFilterConstants.Q_CURRENTVERSION});
    }

    private Map<Long, DynamicObject> queryAdminOrgData(String bizEntity, List<Long> pkIdList, List<String> selectFieldList) {
        String selectFields = String.join((CharSequence)",", selectFieldList);
        String type = HisModelController.getInstance().entityInhRelation(bizEntity);
        if ("1".equals(type)) {
            selectFields = selectFields + "," + "boid";
        }
        return this.iBaseCommonDomainService.queryByIdList(bizEntity, selectFields, pkIdList);
    }
}

