/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.adaptor.inbound.biz.handle;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdi.adaptor.inbound.biz.bizdataquery.BizDataQueryHandleFactory;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.adaptor.bo.BizDataSyncDataMappingBo;
import kd.hdtc.hrdi.business.domain.adaptor.context.IntBizSyncContext;
import kd.hdtc.hrdi.business.domain.adaptor.context.IntRowResult;
import kd.hdtc.hrdi.business.domain.middle.IMidTableConfigDomainService;
import kd.hdtc.hrdi.common.util.DynamicObjectCompareUtils;
import kd.hr.hbp.business.log.EntityModifyInfo;

public class DataCompareHandle {
    private static final Log LOG = LogFactory.getLog(DataCompareHandle.class);
    IMidTableConfigDomainService iMidTableConfigDomainService = (IMidTableConfigDomainService)ServiceFactory.getService(IMidTableConfigDomainService.class);
    private List<IntRowResult> intRowResultList;

    public DataCompareHandle() {
        IntBizSyncContext context = IntBizSyncContext.get();
        this.intRowResultList = context.getIntRowResultList();
    }

    public void compare() {
        String bizEntityNumber = IntBizSyncContext.get().getBizEntityNumber();
        String midTableNumber = IntBizSyncContext.get().getMidTableNumber();
        ArrayList bizIdList = Lists.newArrayListWithExpectedSize((int)this.intRowResultList.size());
        this.intRowResultList.forEach(dy -> bizIdList.add(dy.getBizDataSyncDataMappingBo().getDataMapping().getBizDataKey()));
        List fieldNumberList = this.iMidTableConfigDomainService.getMidTableIntFieldListByMidTable(midTableNumber);
        Map<Long, DynamicObject> bizIdDyMap = BizDataQueryHandleFactory.getBizDataQueryService(bizEntityNumber).queryBizData(bizEntityNumber, bizIdList, fieldNumberList);
        IntBizSyncContext.get().setFieldNumberList(fieldNumberList);
        Map compareMap = IntBizSyncContext.get().getCompareMap();
        this.intRowResultList.forEach(intRowResult -> {
            BizDataSyncDataMappingBo bizDataSyncDataMappingBo = intRowResult.getBizDataSyncDataMappingBo();
            DynamicObject bizDynamicObject = bizDataSyncDataMappingBo.getBizDynamicObject();
            DynamicObject bizObject = (DynamicObject)bizIdDyMap.get(bizDataSyncDataMappingBo.getDataMapping().getBizDataKey());
            if (bizObject != null) {
                EntityModifyInfo entityModifyInfo = DynamicObjectCompareUtils.getEntityModifyInfo((DynamicObject)bizDynamicObject, (DynamicObject)bizObject, (List)fieldNumberList);
                compareMap.put(intRowResult, entityModifyInfo);
                this.printLog(entityModifyInfo);
                intRowResult.getBizDataSyncDataMappingBo().setCurrentBizDynamicObject(bizObject);
            } else {
                EntityModifyInfo entityModifyInfo = new EntityModifyInfo();
                entityModifyInfo.setFlag("+");
                compareMap.put(intRowResult, entityModifyInfo);
            }
        });
    }

    private void printLog(EntityModifyInfo entityModifyInfo) {
        StringBuilder msg = new StringBuilder();
        entityModifyInfo.getFields().forEach(field -> msg.append("field:").append(field.getFieldName()).append(" ,oldValue:").append(field.getOldValue()).append(" ,newValue:").append(field.getNewValue()).append(";"));
        LOG.info("EntityModifyInfo : {}", (Object)msg.toString());
    }
}

