/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.adaptor.inbound.biz.handle;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import com.google.common.graph.SuccessorsFunction;
import com.google.common.graph.Traverser;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdi.business.domain.adaptor.context.IntBizSyncContext;
import kd.hdtc.hrdi.business.domain.adaptor.context.IntRowResult;

public class DataSortHandle {
    private static final Log LOG = LogFactory.getLog(DataSortHandle.class);
    private static final Node ROOT_NODE = new Node(null, null, null);
    private String parentField;

    public DataSortHandle(String parentField) {
        this.parentField = parentField;
    }

    public void sort() {
        Map<String, Node> nodeMap = this.prepareMap();
        MutableGraph graph = GraphBuilder.directed().build();
        this.buildGraph(nodeMap, (MutableGraph<Node>)graph);
        Iterable nodeIterable = Traverser.forGraph((SuccessorsFunction)graph).depthFirstPostOrder((Iterable)graph.nodes());
        List rowResultList = Lists.newArrayList((Iterable)nodeIterable).stream().filter(it -> it != ROOT_NODE).map(it -> it.getIntRowResult()).collect(Collectors.toList());
        IntBizSyncContext.get().addSortedIntRowResultList(rowResultList);
    }

    private void buildGraph(Map<String, Node> nodeMap, MutableGraph<Node> graph) {
        for (Map.Entry<String, Node> entry : nodeMap.entrySet()) {
            Node node = entry.getValue();
            graph.putEdge((Object)node, (Object)nodeMap.getOrDefault(node.getPid(), ROOT_NODE));
        }
    }

    private Map<String, Node> prepareMap() {
        List intRowResultList = IntBizSyncContext.get().getIntRowResultList();
        LinkedHashMap map = Maps.newLinkedHashMapWithExpectedSize((int)intRowResultList.size());
        for (IntRowResult intRowResult : intRowResultList) {
            DynamicObject dy = intRowResult.getBizDataSyncDataMappingBo().getBizDynamicObject();
            map.put(dy.getString("number"), new Node(dy.getString("number"), dy.getDynamicObject(this.parentField) != null ? dy.getDynamicObject(this.parentField).getString("number") : "", intRowResult));
        }
        return map;
    }

    private static class Node {
        private String id;
        private String pid;
        private IntRowResult intRowResult;

        public Node(String id, String pid, IntRowResult intRowResult) {
            this.id = id;
            this.pid = pid;
            this.intRowResult = intRowResult;
        }

        public String getId() {
            return this.id;
        }

        public String getPid() {
            return this.pid;
        }

        public IntRowResult getIntRowResult() {
            return this.intRowResult;
        }
    }
}

