/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.adaptor.inbound.biz.person;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdi.business.application.external.entity.IPersonEntityService;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.adaptor.context.IntBizSyncContext;
import kd.hdtc.hrdi.business.domain.adaptor.context.IntRowResult;
import kd.hdtc.hrdi.common.pojo.DataMapping;
import kd.sdk.hdtc.hrdi.adaptor.api.IBizSyncSceneAdaptor;

public abstract class AbstractPersonBizSyncSceneBaseAdaptor
implements IBizSyncSceneAdaptor {
    private static final Log LOG = LogFactory.getLog(AbstractPersonBizSyncSceneBaseAdaptor.class);
    protected final IPersonEntityService iPersonEntityService = (IPersonEntityService)ServiceFactory.getService(IPersonEntityService.class);
    protected DynamicObject[] dys;
    protected Map<String, String> sourceKeyOldNumberMap;
    protected Map<String, Object> credentialsInfoMap;
    protected Map<String, Long> credentialsPersonMap;

    public AbstractPersonBizSyncSceneBaseAdaptor() {
        List intRowResultList = IntBizSyncContext.get().getIntRowResultList();
        this.sourceKeyOldNumberMap = new HashMap<String, String>(16);
        this.credentialsInfoMap = new HashMap<String, Object>(16);
        intRowResultList.forEach(rowResult -> {
            DynamicObject person = rowResult.getBizDataSyncDataMappingBo().getBizDynamicObject();
            String oldNumber = person.getString("hrpi_empentrel_integ.oldempnumber");
            if (StringUtils.isNotEmpty((String)oldNumber)) {
                DataMapping dataMapping = ((IntRowResult)IntBizSyncContext.get().getRowMap().get(person.getLong("id"))).getBizDataSyncDataMappingBo().getDataMapping();
                this.sourceKeyOldNumberMap.put(dataMapping.getSourceDataKey(), oldNumber);
                this.initCredentialsInfoMap(person);
            }
        });
        this.initOldPerson();
    }

    private void initOldPerson() {
        if (CollectionUtils.isEmpty(this.credentialsInfoMap)) {
            return;
        }
        this.credentialsPersonMap = this.iPersonEntityService.getPersonInfoByCert(this.credentialsInfoMap);
    }

    private void initCredentialsInfoMap(DynamicObject person) {
        this.credentialsInfoMap.put("credentialsType", person.getLong("credentialstype.id"));
        ArrayList<String> numberList = (ArrayList<String>)this.credentialsInfoMap.get("numbers");
        if (CollectionUtils.isEmpty((Collection)numberList)) {
            numberList = new ArrayList<String>(10);
        }
        numberList.add(person.getString("credentialsnumber"));
        this.credentialsInfoMap.put("numbers", numberList);
    }

    public Map<String, String> sync(DynamicObject[] dys) {
        Map<String, String> errorMap;
        this.dys = dys;
        long start = System.currentTimeMillis();
        try {
            errorMap = this.doSync();
        }
        catch (Exception ex) {
            LOG.error((Throwable)ex);
            throw ex;
        }
        LOG.info("person sync cost: {}ms", (Object)(System.currentTimeMillis() - start));
        return errorMap;
    }

    protected abstract Map<String, String> doSync();
}

