/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.adaptor.inbound.biz.person;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hdtc.hrdi.adaptor.inbound.biz.person.AbstractPersonBizSyncSceneBaseAdaptor;
import kd.hdtc.hrdi.adaptor.inbound.biz.person.PersonReEmploymentExtendDefault;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.adaptor.context.IntBizSyncContext;
import kd.hdtc.hrdi.business.domain.adaptor.context.IntRowResult;
import kd.hdtc.hrdi.business.domain.middle.IMidTableConfigDomainService;
import kd.hdtc.hrdi.common.pojo.DataMapping;
import kd.hdtc.hrdi.common.pojo.MidTableConfigField;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.hdtc.hrdi.adaptor.extend.IPersonReEmploymentExtend;
import kd.sdk.hdtc.hrdi.adaptor.model.PersonReEmploymentArgs;

public abstract class PersonBaseMServiceAdaptor
extends AbstractPersonBizSyncSceneBaseAdaptor {
    private static final Log LOG = LogFactory.getLog(PersonBaseMServiceAdaptor.class);
    protected final IMidTableConfigDomainService iMidTableConfigDomainService = (IMidTableConfigDomainService)ServiceFactory.getService(IMidTableConfigDomainService.class);

    protected Map<String, String> getPersonErrorMap(Map<String, Object> resultMap) {
        HashMap errorMap = Maps.newHashMap();
        if (!((Boolean)resultMap.get("success")).booleanValue()) {
            List errorInfoMsgList = (List)resultMap.get("errorInfoMsg");
            List dataInfoList = (List)resultMap.get("data");
            List errorInfoList = (List)resultMap.get("errInfos");
            if (CollectionUtils.isNotEmpty((Collection)errorInfoMsgList)) {
                errorInfoMsgList.forEach(errInfo -> errorMap.put(errInfo.get("id") + "", errInfo.get("errMsg").toString()));
            } else if (CollectionUtils.isNotEmpty((Collection)errorInfoList)) {
                errorInfoList.forEach(errorInfo -> {
                    List errorDataList = (List)errorInfo.get("errorDatas");
                    errorDataList.forEach(errorData -> errorMap.put(errorData.get("id") + "", errorData.get("errMsg").toString()));
                });
            } else if (CollectionUtils.isNotEmpty((Collection)dataInfoList)) {
                Object hisErrorMsgObj = ((Map)dataInfoList.get(0)).get("errorMessage");
                String hisErrorMsg = hisErrorMsgObj == null ? "" : hisErrorMsgObj.toString();
                errorMap.put("allFailed", hisErrorMsg);
            } else {
                Object errorMsg = resultMap.get("errorMessage");
                Object object = errorMsg = errorMsg == null ? resultMap.get("message") : errorMsg;
                if (StringUtils.isNotEmpty((String)(errorMsg + ""))) {
                    errorMap.put("allFailed", errorMsg + "");
                }
            }
        }
        return errorMap;
    }

    public List<Map<String, Object>> toPersonParamList(DynamicObject[] persons) {
        ArrayList personParamList = Lists.newArrayListWithExpectedSize((int)persons.length);
        String entityNumber = persons[0].getDataEntityType().getName();
        Map entityNumberAndEntityFieldListMap = this.iMidTableConfigDomainService.getEntityFieldByBizNumber(entityNumber, true);
        for (DynamicObject person : persons) {
            Map<String, Object> personParam = this.toPersonParam(person, entityNumberAndEntityFieldListMap);
            personParamList.add(personParam);
        }
        return personParamList;
    }

    protected abstract Map<String, Object> toPersonParam(DynamicObject var1, Map<String, List<MidTableConfigField>> var2);

    protected Map<String, Object> getEmpPosOrgRelMap(DynamicObject person, Map<String, List<MidTableConfigField>> entityNumberAndEntityFieldListMap) {
        HashMap<String, Object> empPosOrgRel = new HashMap<String, Object>(16);
        List<MidTableConfigField> midTableConfigFieldList = entityNumberAndEntityFieldListMap.get("hrpi_onboardempexp_integ");
        List fieldNumberList = MetadataUtils.getFieldNumberList((String)"hrpi_onboardempexp_integ");
        this.setValueToMap(empPosOrgRel, person, midTableConfigFieldList, "hrpi_onboardempexp_integ", fieldNumberList);
        String isPrimary = person.getString("hrpi_onboardempexp_integ.isprimary");
        empPosOrgRel.put("isprimary", "1".equals(isPrimary));
        if (!StringUtils.equals((String)"1", (String)((String)empPosOrgRel.get("apositiontype")))) {
            empPosOrgRel.remove("position");
        }
        return empPosOrgRel;
    }

    protected Map<String, Object> getPerRegionMap(DynamicObject person, Map<String, List<MidTableConfigField>> entityNumberAndEntityFieldListMap) {
        HashMap<String, Object> perRegion = new HashMap<String, Object>(16);
        List<MidTableConfigField> midTableConfigFieldList = entityNumberAndEntityFieldListMap.get("hrpi_pernontsprop_integ");
        List fieldNumberList = MetadataUtils.getFieldNumberList((String)"hrpi_perregion");
        this.setValueToMap(perRegion, person, midTableConfigFieldList, "hrpi_pernontsprop_integ", fieldNumberList);
        return perRegion;
    }

    protected Map<String, Object> getPerTspropMap(DynamicObject person, Map<String, List<MidTableConfigField>> entityNumberAndEntityFieldListMap) {
        HashMap<String, Object> perTsprop = new HashMap<String, Object>(16);
        List<MidTableConfigField> midTableConfigFieldList = entityNumberAndEntityFieldListMap.get("hrpi_pernontsprop_integ");
        List fieldNumberList = MetadataUtils.getFieldNumberList((String)"hrpi_pertsprop");
        this.setValueToMap(perTsprop, person, midTableConfigFieldList, "hrpi_pernontsprop_integ", fieldNumberList);
        return perTsprop;
    }

    protected Map<String, Object> getPerContactMap(DynamicObject person, Map<String, List<MidTableConfigField>> entityNumberAndEntityFieldListMap) {
        HashMap<String, Object> perContact = new HashMap<String, Object>(16);
        List<MidTableConfigField> midTableConfigFieldList = entityNumberAndEntityFieldListMap.get("hrpi_pernontsprop_integ");
        List fieldNumberList = MetadataUtils.getFieldNumberList((String)"hrpi_percontact");
        this.setValueToMap(perContact, person, midTableConfigFieldList, "hrpi_pernontsprop_integ", fieldNumberList);
        return perContact;
    }

    protected Map<String, Object> getPersonBaseMap(DynamicObject person, Map<String, List<MidTableConfigField>> entityNumberAndEntityFieldListMap) {
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        DataMapping dataMapping = ((IntRowResult)IntBizSyncContext.get().getRowMap().get(person.getLong("id"))).getBizDataSyncDataMappingBo().getDataMapping();
        List<MidTableConfigField> midTableConfigFieldList = entityNumberAndEntityFieldListMap.get("hrpi_pernontsprop_integ");
        List fieldNumberList = MetadataUtils.getFieldNumberList((String)"hrpi_person");
        this.setValueToMap(param, person, midTableConfigFieldList, "hrpi_pernontsprop_integ", fieldNumberList);
        param.put("person", dataMapping.getPersonId());
        param.put("name", person.get("name"));
        param.put("number", dataMapping.getNumber());
        param.put("phone", person.get("phone"));
        if (this.sourceKeyOldNumberMap.containsKey(dataMapping.getSourceDataKey())) {
            PersonReEmploymentArgs args = new PersonReEmploymentArgs();
            args.setCredentialsTypeId(Long.valueOf(person.getLong("credentialstype.id")));
            args.setCredentialsNumber(person.getString("credentialsnumber"));
            args.setOldNumber((String)this.sourceKeyOldNumberMap.get(dataMapping.getSourceDataKey()));
            args.setSourceSysKey(dataMapping.getSourceDataKey());
            args.setNumber(dataMapping.getNumber());
            Long personId = this.getOldPersonIdExtHandle(args);
            LOG.info("getPersonBaseMap , credentialstype:{},credentialsnumber:{},person:{}", new Object[]{person.getLong("credentialstype.id"), person.getString("credentialsnumber"), personId});
            if (personId != null && 0L != personId) {
                param.put("oldperson", personId);
            }
        }
        return param;
    }

    private Long getOldPersonIdExtHandle(PersonReEmploymentArgs args) {
        PersonReEmploymentExtendDefault reEmploymentExtend = new PersonReEmploymentExtendDefault();
        reEmploymentExtend.setCredentialsPersonMap(this.credentialsPersonMap);
        HRPluginProxy pluginProxy = HRPlugInProxyFactory.create((Object)reEmploymentExtend, IPersonReEmploymentExtend.class, (String)"kd.sdk.hdtc.hrdi.adaptor.extend.IPersonReEmploymentExtend", null);
        List oldPersonList = pluginProxy.callReplaceIfPresent(ext -> ext.getOldPersonId(args));
        return CollectionUtils.isEmpty((Collection)oldPersonList) ? Long.valueOf(0L) : (Long)oldPersonList.get(0);
    }

    protected Map<String, Object> getPerNontspropMap(DynamicObject person, Map<String, List<MidTableConfigField>> entityNumberAndEntityFieldListMap) {
        HashMap<String, Object> perNontsprop = new HashMap<String, Object>(16);
        List<MidTableConfigField> midTableConfigFieldList = entityNumberAndEntityFieldListMap.get("hrpi_pernontsprop_integ");
        List fieldNumberList = MetadataUtils.getFieldNumberList((String)"hrpi_pernontsprop_integ");
        this.setValueToMap(perNontsprop, person, midTableConfigFieldList, "hrpi_pernontsprop_integ", fieldNumberList);
        return perNontsprop;
    }

    protected Map<String, Object> getBaseInfoMap(DynamicObject person, Map<String, List<MidTableConfigField>> entityNumberAndEntityFieldListMap) {
        DataMapping dataMapping = ((IntRowResult)IntBizSyncContext.get().getRowMap().get(person.getLong("id"))).getBizDataSyncDataMappingBo().getDataMapping();
        HashMap<String, Object> baseInfo = new HashMap<String, Object>(16);
        List<MidTableConfigField> midTableConfigFieldList = entityNumberAndEntityFieldListMap.get("hrpi_empentrel_integ");
        List fieldNumberList = MetadataUtils.getFieldNumberList((String)"hrpi_empentrel_integ");
        this.setValueToMap(baseInfo, person, midTableConfigFieldList, "hrpi_empentrel_integ", fieldNumberList);
        baseInfo.put("employee", dataMapping.getEmployeeId());
        baseInfo.put("depemp", dataMapping.getDepempId());
        baseInfo.put("cmpemp", dataMapping.getCmpempId());
        baseInfo.put("cepmp", dataMapping.getCmpempId());
        return baseInfo;
    }

    protected void setValueToMap(Map<String, Object> paramMap, DynamicObject person, List<MidTableConfigField> midTableConfigFieldList, String entityNumber, List<String> fieldNumberList) {
        midTableConfigFieldList.forEach(field -> {
            if (fieldNumberList.contains(field.getEntityNumber())) {
                String prefix;
                String string = prefix = "hrpi_pernontsprop_integ".equals(entityNumber) ? "" : entityNumber + ".";
                if (field.isBaseData()) {
                    paramMap.put(field.getEntityNumber(), this.getDataBaseId(person, prefix + field.getEntityNumber()));
                } else {
                    paramMap.put(field.getEntityNumber(), person.get(prefix + field.getEntityNumber()));
                }
            }
        });
    }

    protected Object getDataBaseId(DynamicObject dy, String fieldName) {
        DynamicObject dataBase = dy.getDynamicObject(fieldName);
        if (dataBase != null) {
            return dataBase.get("id");
        }
        return null;
    }
}

