/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.adaptor.inbound.biz.person;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hdtc.hrdi.adaptor.inbound.biz.person.PersonBaseMServiceAdaptor;
import kd.hdtc.hrdi.adaptor.inbound.biz.person.bo.FourPersonMappingBo;
import kd.hdtc.hrdi.common.pojo.MidTableConfigField;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public class PersonCreateMServiceAdaptor
extends PersonBaseMServiceAdaptor {
    private static final Log LOG = LogFactory.getLog(PersonCreateMServiceAdaptor.class);

    @Override
    public Map<String, String> doSync() {
        List<Map<String, Object>> personParamList = this.toPersonParamList(this.dys);
        LOG.info("PersonCreateMServiceAdaptor callMService, data count{}.", (Object)personParamList.size());
        LOG.info("PersonCreateMServiceAdaptor callMService,personParamList: {}.", personParamList);
        Map resultMap = this.iPersonEntityService.addNewPerson(personParamList);
        LOG.info("PersonCreateMServiceAdaptor callMService, resultMap:{}.", (Object)resultMap);
        this.personDataMappingHandle(resultMap);
        return this.getPersonErrorMap(resultMap);
    }

    private void personDataMappingHandle(Map<String, Object> resultMap) {
        List resultDataMappingList = (List)resultMap.get("resultFourPerson");
        if (CollectionUtils.isEmpty((Collection)resultDataMappingList)) {
            return;
        }
        FourPersonMappingBo personMappingBo = new FourPersonMappingBo(resultDataMappingList);
        personMappingBo.updatePersonDataMapping();
    }

    @Override
    public Map<String, Object> toPersonParam(DynamicObject person, Map<String, List<MidTableConfigField>> entityNumberAndEntityFieldListMap) {
        Map<String, Object> param = this.getPersonBaseMap(person, entityNumberAndEntityFieldListMap);
        Map<String, Object> baseInfo = this.getBaseInfoMap(person, entityNumberAndEntityFieldListMap);
        this.fillManagingScopeField(baseInfo, person, entityNumberAndEntityFieldListMap);
        Object oldNumber = baseInfo.get("oldempnumber");
        if (oldNumber == null || StringUtils.isEmpty((String)oldNumber.toString())) {
            baseInfo.remove("oldempnumber");
        }
        ArrayList<Map<String, Object>> empList = new ArrayList<Map<String, Object>>();
        Map<String, Object> empPosOrgRel = this.getEmpPosOrgRelMap(person, entityNumberAndEntityFieldListMap);
        empList.add(empPosOrgRel);
        baseInfo.put("empposorgrels", empList);
        param.put("baseinfo", baseInfo);
        param.put("pernontsprop", this.getPerNontspropMap(person, entityNumberAndEntityFieldListMap));
        param.put("percontact", this.getPerContactMap(person, entityNumberAndEntityFieldListMap));
        param.put("perregion", this.getPerRegionMap(person, entityNumberAndEntityFieldListMap));
        param.put("pertsprop", this.getPerTspropMap(person, entityNumberAndEntityFieldListMap));
        return param;
    }

    private void fillManagingScopeField(Map<String, Object> baseInfo, DynamicObject person, Map<String, List<MidTableConfigField>> entityNumberAndEntityFieldListMap) {
        List<MidTableConfigField> midTableConfigFieldList = entityNumberAndEntityFieldListMap.get("hrpi_managingscope_integ");
        List fieldNumberList = MetadataUtils.getFieldNumberList((String)"hrpi_managingscope_integ");
        baseInfo.put("startdate", person.get("hrpi_onboardempexp_integ.startdate"));
        baseInfo.put("enddate", HRDateTimeUtils.getSysMaxDate());
        baseInfo.put("isprimaryscope", "1");
        baseInfo.put("variationtype", this.getDataBaseId(person, "hrpi_onboardempexp_integ.variationtype"));
        this.setValueToMap(baseInfo, person, midTableConfigFieldList, "hrpi_managingscope_integ", fieldNumberList);
    }
}

