/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.adaptor.inbound.biz.person.bo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdi.adaptor.inbound.biz.person.bo.PersonDataMapping;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.datamapping.IDataMappingDomainService;
import kd.hdtc.hrdi.business.domain.datamapping.entity.DataMappingFactory;
import kd.hdtc.hrdi.business.domain.datamapping.entity.IDataMappingEntityService;
import kd.hdtc.hrdi.common.pojo.DataMapping;

public class FourPersonMappingBo {
    private static final Log logger = LogFactory.getLog(FourPersonMappingBo.class);
    private final List<Map<String, Long>> fourPersonMappingList;
    private final IDataMappingDomainService iDataMappingDomainService = (IDataMappingDomainService)ServiceFactory.getService(IDataMappingDomainService.class);

    public FourPersonMappingBo(List<Map<String, Long>> fourPersonMappingList) {
        this.fourPersonMappingList = fourPersonMappingList;
    }

    public void updatePersonDataMapping() {
        logger.info("updatePersonDataMapping params:{}", this.fourPersonMappingList);
        List<PersonDataMapping> personDataMappingList = this.buildPersonDataMapping(this.fourPersonMappingList);
        if (CollectionUtils.isEmpty(personDataMappingList)) {
            return;
        }
        Map<String, DynamicObject> dataMappingDynMap = this.queryHrDataMapping(personDataMappingList);
        List<DataMapping> dataMappingList = this.toDataMapping(dataMappingDynMap, personDataMappingList);
        this.iDataMappingDomainService.save(dataMappingList);
    }

    private Map<String, DynamicObject> queryHrDataMapping(List<PersonDataMapping> personDataMappingList) {
        IDataMappingEntityService entityService = new DataMappingFactory().getDataMappingEntityService("hrpi_emp_integrate");
        QFilter[] qFilters = this.buildFilter(personDataMappingList);
        DynamicObject[] dbDataMappings = entityService.query("entityobjid,hrdisourcesys,hrdisourcesyskey,bizdatakey,personid,employeeid,depempid,cmpempid,number,effectivestatus", qFilters);
        return Arrays.stream(dbDataMappings).collect(Collectors.toMap(dyn -> String.valueOf(dyn.getLong("personid")) + dyn.get("employeeid") + dyn.get("depempid") + dyn.get("cmpempid"), dyn -> dyn, (key1, key2) -> key1));
    }

    private QFilter[] buildFilter(List<PersonDataMapping> personDataMappingList) {
        HashSet personIdSet = new HashSet(16);
        HashSet cmpempIdSet = new HashSet(16);
        HashSet depempIdSet = new HashSet(16);
        HashSet employeeIdSet = new HashSet(16);
        personDataMappingList.forEach(personDataMapping -> {
            personIdSet.add(personDataMapping.getOldPersonId());
            cmpempIdSet.add(personDataMapping.getOldCmpempId());
            depempIdSet.add(personDataMapping.getOldDepempId());
            employeeIdSet.add(personDataMapping.getOldEmployeeId());
        });
        QFilter[] filters = new QFilter[]{new QFilter("personid", "in", personIdSet), new QFilter("cmpempid", "in", cmpempIdSet), new QFilter("depempid", "in", depempIdSet), new QFilter("employeeid", "in", employeeIdSet)};
        return filters;
    }

    private List<PersonDataMapping> buildPersonDataMapping(List<Map<String, Long>> resultDataMappingList) {
        ArrayList<PersonDataMapping> personDataMappingList = new ArrayList<PersonDataMapping>(10);
        for (Map<String, Long> personIdMap : resultDataMappingList) {
            if (personIdMap.get("newCmpEmpId").equals(personIdMap.get("oldCmpEmpId")) && personIdMap.get("newDepEmpId").equals(personIdMap.get("oldDepEmpId")) && personIdMap.get("newEmpId").equals(personIdMap.get("oldEmpId")) && personIdMap.get("newPersonId").equals(personIdMap.get("oldPersonId"))) continue;
            PersonDataMapping dataMapping = new PersonDataMapping();
            dataMapping.setCmpempId(personIdMap.get("newCmpEmpId"));
            dataMapping.setDepempId(personIdMap.get("newDepEmpId"));
            dataMapping.setEmployeeId(personIdMap.get("newEmpId"));
            dataMapping.setPersonId(personIdMap.get("newPersonId"));
            dataMapping.setOldCmpempId(personIdMap.get("oldCmpEmpId"));
            dataMapping.setOldDepempId(personIdMap.get("oldDepEmpId"));
            dataMapping.setOldEmployeeId(personIdMap.get("oldEmpId"));
            dataMapping.setOldPersonId(personIdMap.get("oldPersonId"));
            personDataMappingList.add(dataMapping);
        }
        return personDataMappingList;
    }

    private List<DataMapping> toDataMapping(Map<String, DynamicObject> dataMappingDynMap, List<PersonDataMapping> personDataMappingList) {
        Map<String, PersonDataMapping> personDataMappingMap = personDataMappingList.stream().collect(Collectors.toMap(PersonDataMapping::getOldPersonKey, personDataMapping -> personDataMapping, (key1, key2) -> key1));
        ArrayList<DataMapping> dataMappingList = new ArrayList<DataMapping>(10);
        personDataMappingMap.forEach((key, personDataMapping) -> {
            DynamicObject dbDataMapping = (DynamicObject)dataMappingDynMap.get(key);
            DataMapping dataMapping = new DataMapping();
            dataMapping.setEntityObjId("hrpi_emp_integrate");
            dataMapping.setSourceSys(dbDataMapping.getDynamicObject("hrdisourcesys"));
            dataMapping.setSourceDataKey(dbDataMapping.getString("hrdisourcesyskey"));
            dataMapping.setNumber(dbDataMapping.getString("number"));
            dataMapping.setEffectiveStatus(dbDataMapping.getString("effectivestatus"));
            dataMapping.setPersonId(personDataMapping.getPersonId());
            dataMapping.setEmployeeId(personDataMapping.getEmployeeId());
            dataMapping.setDepempId(personDataMapping.getDepempId());
            dataMapping.setCmpempId(personDataMapping.getCmpempId());
            dataMapping.setBizDataKey(personDataMapping.getDepempId());
            dataMappingList.add(dataMapping);
        });
        return dataMappingList;
    }
}

