/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.adaptor.inbound.biz.personattached;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.sdk.hdtc.hrdi.adaptor.api.IBizSyncSceneAdaptor;

public abstract class AbstractPersonAttachedBizSyncSceneBaseAdaptor
implements IBizSyncSceneAdaptor {
    private static final Log LOG = LogFactory.getLog(AbstractPersonAttachedBizSyncSceneBaseAdaptor.class);
    protected DynamicObject[] dys;

    public Map<String, String> sync(DynamicObject[] dys) {
        Map<String, String> errorMap;
        this.dys = dys;
        long start = System.currentTimeMillis();
        try {
            errorMap = this.doSync();
        }
        catch (Exception ex) {
            LOG.error((Throwable)ex);
            throw ex;
        }
        LOG.info("person sync cost: {}ms", (Object)(System.currentTimeMillis() - start));
        return errorMap;
    }

    protected Map<String, String> getPersonAttachedErrorMap(Map<String, Object> resultMap) {
        HashMap errorMap = Maps.newHashMap();
        if (!((Boolean)resultMap.get("success")).booleanValue()) {
            List errorInfoMsgList = (List)resultMap.get("errInfos");
            List dataInfoList = (List)resultMap.get("data");
            if (CollectionUtils.isNotEmpty((Collection)errorInfoMsgList)) {
                errorInfoMsgList.forEach(errInfo -> {
                    List errorDatas = (List)errInfo.get("errorDatas");
                    errorDatas.forEach(errorData -> errorMap.put(errorData.get("id") + "", errorData.get("errMsg") + ""));
                });
            } else if (CollectionUtils.isNotEmpty((Collection)dataInfoList)) {
                Object hisErrorMsgObj = ((Map)dataInfoList.get(0)).get("errorMessage");
                String hisErrorMsg = hisErrorMsgObj == null ? "" : hisErrorMsgObj.toString();
                errorMap.put("allFailed", hisErrorMsg);
            } else {
                Object errorMsg = resultMap.get("errorMessage");
                Object object = errorMsg = errorMsg == null ? resultMap.get("message") : errorMsg;
                if (StringUtils.isNotEmpty((String)(errorMsg + ""))) {
                    errorMap.put("allFailed", errorMsg + "");
                }
            }
        }
        return errorMap;
    }

    protected abstract Map<String, String> doSync();
}

