/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.adaptor.inbound.biz.sceneadaptor.common;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdi.adaptor.inbound.biz.AbstractBizSceneAdapter;
import kd.hdtc.hrdi.adaptor.inbound.biz.sceneadaptor.common.handle.DisableSceneHandle;
import kd.hdtc.hrdi.adaptor.inbound.biz.sceneadaptor.common.handle.EnableSceneHandle;
import kd.hdtc.hrdi.adaptor.inbound.biz.sceneadaptor.handle.ChangeSceneHandle;
import kd.hdtc.hrdi.adaptor.inbound.biz.sceneadaptor.handle.DeleteSceneHandle;
import kd.hdtc.hrdi.adaptor.inbound.biz.sceneadaptor.handle.NewSceneHandle;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.adaptor.context.IntBizSyncContext;
import kd.hdtc.hrdi.business.domain.adaptor.context.IntRowResult;
import kd.hdtc.hrdi.business.domain.common.IBaseCommonDomainService;
import kd.hdtc.hrdi.common.adaptor.enums.IntSceneEnum;
import kd.hdtc.hrdi.common.exception.HRDIBizException;

public abstract class AbstractCommonOpAndMServiceAdaptor
extends AbstractBizSceneAdapter {
    protected final Log logger = LogFactory.getLog(AbstractCommonOpAndMServiceAdaptor.class);
    private final IBaseCommonDomainService iBaseCommonDomainService = (IBaseCommonDomainService)ServiceFactory.getService(IBaseCommonDomainService.class);

    public AbstractCommonOpAndMServiceAdaptor() {
        if (this.sceneRule == null) {
            String intSceneError = ResManager.loadKDString((String)"\u8bf7\u5148\u914d\u7f6e\u5b9e\u4f53\u5bf9\u8c61\u201c%s\u201d\u7684\u96c6\u6210\u573a\u666f\u89c4\u5219\u3002", (String)"CommonOpAdaptor_0", (String)"hdtc-hrdi-adaptor", (Object[])new Object[0]);
            throw new HRDIBizException(String.format(Locale.ROOT, intSceneError, IntBizSyncContext.get().getBizEntityNumber()));
        }
    }

    @Override
    protected void initSceneHandle() {
        this.SCENE_HANDLE_MAP = ImmutableMap.builder().put((Object)IntSceneEnum.DELETE, (Object)new DeleteSceneHandle()).put((Object)IntSceneEnum.NEW, (Object)new NewSceneHandle()).put((Object)IntSceneEnum.ENABLE, (Object)new EnableSceneHandle()).put((Object)IntSceneEnum.DISABLE, (Object)new DisableSceneHandle()).put((Object)IntSceneEnum.CHANGE, (Object)new ChangeSceneHandle()).build();
    }

    @Override
    protected void bizServiceInvoke(Map<IntSceneEnum, List<IntRowResult>> sceneTypeIntRowResultListMap) {
        this.doBeforeServiceInvoke();
        IntSceneEnum[] intSceneEnums = IntSceneEnum.values();
        Arrays.stream(intSceneEnums).forEach(intSceneEnum -> {
            List rowResultList = (List)sceneTypeIntRowResultListMap.get(intSceneEnum);
            if (CollectionUtils.isNotEmpty((Collection)rowResultList)) {
                DynamicObject[] dyns = (DynamicObject[])rowResultList.stream().map(dy -> dy.getBizDataSyncDataMappingBo().getBizDynamicObject()).toArray(DynamicObject[]::new);
                Map<String, String> result = this.doInvoke((IntSceneEnum)intSceneEnum, dyns);
                this.parseResult(result, rowResultList);
            }
        });
    }

    private void doBeforeServiceInvoke() {
        this.fieldValueHandle();
    }

    private void fieldValueHandle() {
        List billHeadFieldList = IntBizSyncContext.get().getBillHeadFieldList();
        Map entryFieldMap = IntBizSyncContext.get().getEntryFieldMap();
        Map<Long, DynamicObject> dbBizDataIdDynMap = this.queryBizData(billHeadFieldList, entryFieldMap);
        this.fillField(billHeadFieldList, entryFieldMap, dbBizDataIdDynMap);
    }

    private void fillField(List<String> billHeadFieldList, Map<String, String> entryFieldMap, Map<Long, DynamicObject> dbBizDataIdDynMap) {
        List fieldConfigList = IntBizSyncContext.get().getMidTableConfig().getFieldConfigList();
        HashSet<String> intFieldSet = new HashSet<String>(16);
        fieldConfigList.forEach(fieldConfig -> {
            if (fieldConfig.isIntField()) {
                intFieldSet.add(fieldConfig.getEntityNumber());
            }
        });
        List intRowResultList = IntBizSyncContext.get().getIntRowResultList();
        for (IntRowResult intRowResult : intRowResultList) {
            DynamicObject bizDyn = intRowResult.getBizDataSyncDataMappingBo().getBizDynamicObject();
            DynamicObject dbBizDyn = dbBizDataIdDynMap.get(bizDyn.getLong("id"));
            if (dbBizDyn == null) continue;
            this.fillSysField(bizDyn, dbBizDyn, billHeadFieldList, intFieldSet);
            this.fillEntryField(bizDyn, dbBizDyn, entryFieldMap, intFieldSet);
        }
    }

    private void fillSysField(DynamicObject bizDyn, DynamicObject dbBizDyn, List<String> billHeadFieldList, Set<String> intFieldSet) {
        billHeadFieldList.forEach(field -> {
            if (!intFieldSet.contains(field)) {
                bizDyn.set(field, dbBizDyn.get(field));
            }
        });
    }

    private void fillEntryField(DynamicObject bizDyn, DynamicObject dbBizDyn, Map<String, String> entryFieldMap, Set<String> intFieldSet) {
        if (CollectionUtils.isEmpty(entryFieldMap)) {
            return;
        }
    }

    private Map<Long, DynamicObject> queryBizData(List<String> billHeadFieldList, Map<String, String> entryFieldMap) {
        List pkIdList = IntBizSyncContext.get().getIntRowResultList().stream().map(intRowResult -> intRowResult.getBizDataSyncDataMappingBo().getBizDynamicObject().getLong("id")).collect(Collectors.toList());
        String bizEntityNumber = IntBizSyncContext.get().getBizEntityNumber();
        String billHeadFields = String.join((CharSequence)",", billHeadFieldList);
        StringBuilder entryField = new StringBuilder();
        entryFieldMap.forEach((field, entry) -> entryField.append((String)entry).append(".").append((String)field).append(","));
        if (StringUtils.isNotEmpty((String)billHeadFields)) {
            entryField.append(billHeadFields);
        } else if (entryField.length() >= 1) {
            entryField.delete(entryField.length() - 1, entryField.length());
        }
        return this.iBaseCommonDomainService.queryByIdList(bizEntityNumber, entryField.toString(), pkIdList);
    }

    protected abstract Map<String, String> doInvoke(IntSceneEnum var1, DynamicObject[] var2);
}

