/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.adaptor.inbound.biz.sceneadaptor.common.mservice;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.hdtc.hrdbs.business.servicehelper.MSServiceHelper;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdi.adaptor.inbound.biz.sceneadaptor.common.AbstractCommonOpAndMServiceAdaptor;
import kd.hdtc.hrdi.business.domain.adaptor.context.IntBizSyncContext;
import kd.hdtc.hrdi.common.adaptor.enums.IntSceneEnum;
import kd.hr.hbp.common.mservice.HRMServiceResult;

public class CommonMServiceAdaptor
extends AbstractCommonOpAndMServiceAdaptor {
    private final String cloudId;
    private final String appId;
    private final String serviceName;
    private final String method;
    private static final String ISV_KINGDEE = "kingdee";
    private final Map<IntSceneEnum, String> sceneTypeMap = ImmutableMap.of((Object)IntSceneEnum.NEW, (Object)"1", (Object)IntSceneEnum.ENABLE, (Object)"2", (Object)IntSceneEnum.DISABLE, (Object)"3", (Object)IntSceneEnum.CHANGE, (Object)"4", (Object)IntSceneEnum.DELETE, (Object)"5");

    public CommonMServiceAdaptor() {
        this.cloudId = this.sceneRule.getString("cloudid");
        this.appId = this.sceneRule.getString("appid");
        this.serviceName = this.sceneRule.getString("servicename");
        this.method = this.sceneRule.getString("method");
    }

    @Override
    protected Map<String, String> doInvoke(IntSceneEnum sceneEnum, DynamicObject[] dyns) {
        List<DynamicObject> dataList = Arrays.asList(dyns);
        String opType = this.sceneTypeMap.get(sceneEnum);
        HashMap<String, Object> extParamMap = new HashMap<String, Object>(16);
        HRMServiceResult result = this.isKingdeeApp() ? this.invokeBizService(opType, dataList, extParamMap) : this.invokeService(opType, dataList, extParamMap);
        return this.parseResult(result, dyns);
    }

    private Map<String, String> parseResult(HRMServiceResult result, DynamicObject[] dyns) {
        this.logger.info("common service invoke result:{}", this.toMap(result));
        HashMap<String, String> resultMap = new HashMap<String, String>(16);
        if (StringUtils.isNotEmpty((String)result.getMessage())) {
            resultMap.put("allFailed", result.getMessage());
            return resultMap;
        }
        if ("success".equals(result.getReturnCode())) {
            return resultMap;
        }
        Map msResult = (Map)result.getReturnData();
        String bizEntityKey = this.getBizEntityKey(dyns[0]);
        for (DynamicObject dyn : dyns) {
            String msg = (String)msResult.get(dyn.get("id"));
            String string = msg = StringUtils.isEmpty((String)msg) ? (String)msResult.get(dyn.getString("id")) : msg;
            if (!StringUtils.isNotEmpty((String)msg)) continue;
            resultMap.put(dyn.getString(bizEntityKey), msg);
        }
        return resultMap;
    }

    private Map<String, Object> toMap(HRMServiceResult result) {
        HashMap ret = Maps.newHashMapWithExpectedSize((int)4);
        ret.put("success", result.isSuccess());
        ret.put("message", result.getMessage());
        ret.put("returnData", result.getReturnData());
        ret.put("returnCode", result.getReturnCode());
        return ret;
    }

    private HRMServiceResult invokeBizService(String opType, List<DynamicObject> dataList, Map<String, Object> extParamMap) {
        this.logger.info("common BizService invoke, cloudId:{}, appId:{}, serviceName:{}, method:{}, dataSize:{}, opTpe:{}, , entityNumber:{}, extParamMap:{}", new Object[]{this.cloudId, this.appId, this.serviceName, this.method, dataList.size(), opType, IntBizSyncContext.get().getBizEntityNumber(), extParamMap});
        return (HRMServiceResult)MSServiceHelper.invokeBizService((String)this.cloudId, (String)this.appId, (String)this.serviceName, (String)this.method, (Object[])new Object[]{dataList, opType, extParamMap});
    }

    private HRMServiceResult invokeService(String opType, List<DynamicObject> dataList, Map<String, Object> extParamMap) {
        this.logger.info("common ExtService invoke, cloudId:{}, appId:{}, serviceName:{}, method:{}, dataSize:{}, opTpe:{}, , entityNumber:{}, extParamMap:{}", new Object[]{this.cloudId, this.appId, this.serviceName, this.method, dataList.size(), opType, IntBizSyncContext.get().getBizEntityNumber(), extParamMap});
        return (HRMServiceResult)MSServiceHelper.invokeService((String)this.cloudId, (String)this.appId, (String)this.serviceName, (String)this.method, (Object[])new Object[]{dataList, opType, extParamMap});
    }

    private boolean isKingdeeApp() {
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)this.appId);
        return ISV_KINGDEE.equals(appInfo.getIsv());
    }
}

