/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.adaptor.inbound.biz.sceneadaptor.common.op;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdi.adaptor.inbound.biz.sceneadaptor.common.AbstractCommonOpAndMServiceAdaptor;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.adaptor.context.IntBizSyncContext;
import kd.hdtc.hrdi.business.domain.common.IBaseCommonDomainService;
import kd.hdtc.hrdi.common.adaptor.enums.IntSceneEnum;

public class CommonOpAdaptor
extends AbstractCommonOpAndMServiceAdaptor {
    private final IBaseCommonDomainService baseCommonDomainService = (IBaseCommonDomainService)ServiceFactory.getService(IBaseCommonDomainService.class);
    private final Map<String, String> sceneOpMap;

    public CommonOpAdaptor() {
        DynamicObjectCollection ruleEntry = this.sceneRule.getDynamicObjectCollection("ruleentry");
        this.sceneOpMap = Maps.newHashMapWithExpectedSize((int)ruleEntry.size());
        for (DynamicObject rule : ruleEntry) {
            this.sceneOpMap.put(rule.getString("scenetype"), rule.getString("operate"));
        }
    }

    @Override
    protected Map<String, String> doInvoke(IntSceneEnum sceneEnum, DynamicObject[] dyns) {
        String opType = this.sceneOpMap.get(sceneEnum.getSceneType());
        String entityNumber = IntBizSyncContext.get().getBizEntityNumber();
        this.logger.info("common op invoke, opTpe:{}, entityNumber:{}, dataSize:{}", new Object[]{opType, entityNumber, dyns.length});
        Map opResultMap = this.baseCommonDomainService.commonCallOp(opType, entityNumber, Arrays.asList(dyns));
        this.logger.info("common op invoke, result:{}", (Object)opResultMap);
        return this.parseResult((Map<String, String>)opResultMap, dyns);
    }

    private Map<String, String> parseResult(Map<String, String> opResultMap, DynamicObject[] dyns) {
        String bizEntityKey = this.getBizEntityKey(dyns[0]);
        HashMap<String, String> resultMap = new HashMap<String, String>(16);
        boolean allFailed = opResultMap.containsKey("allFailed");
        for (DynamicObject dyn : dyns) {
            String pkValue = String.valueOf(dyn.getLong("id"));
            String msg = opResultMap.get(pkValue);
            String number = dyn.getString("number");
            String string = msg = StringUtils.isEmpty((String)msg) ? opResultMap.get(number) : msg;
            if (allFailed) {
                msg = opResultMap.get("allFailed");
            }
            if (!StringUtils.isNotEmpty((String)msg)) continue;
            resultMap.put(dyn.getString(bizEntityKey), msg);
        }
        return resultMap;
    }
}

