/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.adaptor.inbound.biz.sceneadaptor.person;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdi.adaptor.inbound.biz.AbstractBizSceneAdapter;
import kd.hdtc.hrdi.adaptor.inbound.biz.sceneadaptor.person.PersonChangeSceneHandle;
import kd.hdtc.hrdi.adaptor.inbound.biz.sceneadaptor.person.PersonNewSceneHandle;
import kd.hdtc.hrdi.business.application.external.entity.IPersonEntityService;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.adaptor.context.IntBizSyncContext;
import kd.hdtc.hrdi.business.domain.adaptor.context.IntRowResult;
import kd.hdtc.hrdi.common.adaptor.enums.IntSceneEnum;
import kd.hr.hbp.business.log.EntityModifyInfo;

public class PersonAdaptor
extends AbstractBizSceneAdapter {
    private final IPersonEntityService iPersonEntityService = (IPersonEntityService)ServiceFactory.getService(IPersonEntityService.class);

    @Override
    protected void buildModifyFieldMap(EntityModifyInfo entityModifyInfo, IntRowResult rowResult) {
        boolean flag;
        this.modifyFieldMap.clear();
        DynamicObject currentPerson = rowResult.getBizDataSyncDataMappingBo().getCurrentBizDynamicObject();
        String oldEmpNumber = rowResult.getBizDataSyncDataMappingBo().getBizDynamicObject().getString("hrpi_empentrel_integ.oldempnumber");
        boolean bl = flag = currentPerson == null || StringUtils.isNotEmpty((String)oldEmpNumber) || StringUtils.isEmpty((String)oldEmpNumber) && Boolean.FALSE.equals(rowResult.getBizDataSyncDataMappingBo().getOtherInfo());
        if (flag) {
            entityModifyInfo.setFlag("+");
            this.modifyFieldMap.put("createField", entityModifyInfo);
        } else {
            this.modifyFieldMap.put("entityModifyInfo", entityModifyInfo);
        }
    }

    @Override
    protected Map<IntSceneEnum, List<IntRowResult>> intSceneGroup() {
        Map<IntSceneEnum, List<IntRowResult>> sceneTypeIntRowResultListMap = super.intSceneGroup();
        List<IntRowResult> addIntRowResultList = sceneTypeIntRowResultListMap.get(IntSceneEnum.NEW);
        List changeIntRowResultList = sceneTypeIntRowResultListMap.getOrDefault(IntSceneEnum.CHANGE, new ArrayList());
        if (CollectionUtils.isNotEmpty(addIntRowResultList)) {
            ArrayList newAddIntRowResultList = Lists.newArrayListWithExpectedSize((int)16);
            Map<String, List<IntRowResult>> numberIntRowResultListMap = addIntRowResultList.stream().collect(Collectors.groupingBy(dy -> dy.getBizDataSyncDataMappingBo().getDataMapping().getNumber()));
            numberIntRowResultListMap.forEach((number, intRowResultList) -> {
                if (intRowResultList.size() > 1) {
                    IntRowResult primary = this.findPrimary((List<IntRowResult>)intRowResultList);
                    newAddIntRowResultList.add(primary);
                    intRowResultList.remove(primary);
                    changeIntRowResultList.addAll(intRowResultList);
                } else {
                    newAddIntRowResultList.addAll(intRowResultList);
                }
            });
            sceneTypeIntRowResultListMap.put(IntSceneEnum.NEW, newAddIntRowResultList);
            sceneTypeIntRowResultListMap.put(IntSceneEnum.CHANGE, changeIntRowResultList);
        }
        return sceneTypeIntRowResultListMap;
    }

    private IntRowResult findPrimary(List<IntRowResult> intRowResultList) {
        IntRowResult primaryRowResult = intRowResultList.get(0);
        for (IntRowResult intRowResult : intRowResultList) {
            String isPrimary = intRowResult.getBizDataSyncDataMappingBo().getBizDynamicObject().getString("hrpi_onboardempexp_integ.isprimary");
            if (!"1".equals(isPrimary)) continue;
            primaryRowResult = intRowResult;
            break;
        }
        return primaryRowResult;
    }

    @Override
    protected void initSceneHandle() {
        this.SCENE_HANDLE_MAP = ImmutableMap.builder().put((Object)IntSceneEnum.NEW, (Object)new PersonNewSceneHandle()).put((Object)IntSceneEnum.CHANGE, (Object)new PersonChangeSceneHandle()).build();
    }

    @Override
    protected void beforeDoSceneAdaptor() {
        List intRowResultList = IntBizSyncContext.get().getIntRowResultList();
        HashSet personIdSet = Sets.newHashSetWithExpectedSize((int)intRowResultList.size());
        intRowResultList.forEach(intRowResult -> {
            Long personId = intRowResult.getBizDataSyncDataMappingBo().getDataMapping().getPersonId();
            personIdSet.add(personId);
        });
        Map numberAndDyMap = this.iPersonEntityService.queryListByPersonId((Set)personIdSet);
        intRowResultList.forEach(intRowResult -> {
            Long personId = intRowResult.getBizDataSyncDataMappingBo().getDataMapping().getPersonId();
            DynamicObject person = (DynamicObject)numberAndDyMap.get(personId);
            if (person != null) {
                intRowResult.getBizDataSyncDataMappingBo().setCurrentBizDynamicObject(person);
            }
        });
    }

    @Override
    protected void parseResult(Map<String, String> errorMap, List<IntRowResult> rowResultList) {
        boolean allFailed = errorMap.containsKey("allFailed");
        if (allFailed) {
            rowResultList.forEach(rowResult -> {
                rowResult.setErrorMsg((String)errorMap.get("allFailed"));
                rowResult.setSuccess(Boolean.FALSE);
            });
        } else {
            rowResultList.forEach(rowResult -> {
                String errorInfo = (String)errorMap.get(rowResult.getBizDataSyncDataMappingBo().getDataMapping().getNumber() + "");
                if (StringUtils.isNotEmpty((String)errorInfo)) {
                    rowResult.setErrorMsg(errorInfo);
                    rowResult.setSuccess(Boolean.FALSE);
                } else {
                    rowResult.setErrorMsg("");
                    rowResult.setSuccess(Boolean.TRUE);
                }
            });
        }
    }
}

