/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.adaptor.outbound;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.common.factory.ExecutorFactory;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdi.adaptor.common.IBizCommonSync;
import kd.hdtc.hrdi.adaptor.outbound.task.MsgOutIntAsyncTask;
import kd.hdtc.hrdi.business.application.external.ICommonIntDomainService;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.monitor.IMsgRecordLogDomainService;
import kd.hdtc.hrdi.business.domain.monitor.entity.IMsgRecordLogEntityService;

public abstract class AbstractBizCommonSync
implements IBizCommonSync {
    private static final Log LOG = LogFactory.getLog(AbstractBizCommonSync.class);
    private final ICommonIntDomainService iCommonIntDomainService = (ICommonIntDomainService)ServiceFactory.getService(ICommonIntDomainService.class);
    private final IMsgRecordLogDomainService msgRecordLogDomainService = (IMsgRecordLogDomainService)ServiceFactory.getService(IMsgRecordLogDomainService.class);
    private final IMsgRecordLogEntityService msgRecordLogEntityService = (IMsgRecordLogEntityService)ServiceFactory.getService(IMsgRecordLogEntityService.class);
    protected DynamicObject tplDy;

    @Override
    public void doSync(DynamicObject tplDy, String bizEntityNumber) {
        LOG.info("Begin consumer biz message. EntityNumber:{}", (Object)bizEntityNumber);
        this.tplDy = tplDy;
        Map msgContentMap = (Map)this.parseMsgContent();
        LOG.info("AbstractBizCommonSync message content:{}", (Object)bizEntityNumber);
        Set<Long> changeBoIdSet = this.getChangeBoIdList(msgContentMap);
        if (CollectionUtils.isEmpty(changeBoIdSet)) {
            LOG.error("No change BOID.");
            return;
        }
        ArrayList<Long> boIdList = new ArrayList<Long>(changeBoIdSet);
        String msgSubNo = tplDy.getString("msgsubno");
        List msgRecordLogIdList = this.iCommonIntDomainService.handleCommonInt(boIdList, bizEntityNumber, msgSubNo, tplDy.getString("number"));
        MsgOutIntAsyncTask msgOutIntAsyncTask = new MsgOutIntAsyncTask(this.msgRecordLogEntityService, this.msgRecordLogDomainService, msgRecordLogIdList);
        ExecutorFactory.getSingleThreadPool().submit((Callable)msgOutIntAsyncTask);
    }

    protected <T> T parseMsgContent() {
        String msgContent = this.tplDy.getString("msgcontent");
        Map resultMap = (Map)SerializationUtils.deSerializeFromBase64((String)msgContent);
        return (T)resultMap;
    }

    protected abstract Set<Long> getChangeBoIdList(Map<String, Object> var1);
}

