/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.adaptor.outbound;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdi.adaptor.outbound.AbstractBizCommonSync;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.common.IBaseCommonDomainService;
import kd.hdtc.hrdi.common.adaptor.constants.AdminOrgConstants;

public class OrgCommonSync
extends AbstractBizCommonSync {
    private static final Log LOG = LogFactory.getLog(OrgCommonSync.class);
    private final IBaseCommonDomainService iBaseCommonDomainService = (IBaseCommonDomainService)ServiceFactory.getService(IBaseCommonDomainService.class);

    @Override
    protected Set<Long> getChangeBoIdList(Map<String, Object> msgContentMap) {
        Long changeScene = (Long)msgContentMap.get("changescene");
        HashSet orgBoIdSet = Sets.newHashSetWithExpectedSize((int)16);
        Long boId = Long.parseLong(msgContentMap.get("boid") + "");
        if (AdminOrgConstants.MERGE_SCENE.equals(changeScene)) {
            Long afterBoId = 0L;
            Object afterMergeOrg = msgContentMap.get("aftermergeorg");
            if (afterMergeOrg != null) {
                JSONObject mergeSplitMsgInfo = JSONObject.parseObject((String)JSONObject.toJSONString((Object)afterMergeOrg));
                afterBoId = mergeSplitMsgInfo.getLong("adminOrgId");
                orgBoIdSet.add(afterBoId);
            }
            if (boId.longValue() != afterBoId.longValue()) {
                LOG.error("ignore this adminorgmsg\uff0cboId:{},aferBoId:{}", (Object)boId, (Object)afterBoId);
                return null;
            }
            List beforeMergeOrgList = (List)msgContentMap.get("beforemergeorg");
            if (!CollectionUtils.isEmpty((Collection)beforeMergeOrgList)) {
                beforeMergeOrgList.forEach(beforeMergeOrg -> {
                    JSONObject mergeSplitMsgInfo = JSONObject.parseObject((String)JSONObject.toJSONString((Object)beforeMergeOrg));
                    orgBoIdSet.add(mergeSplitMsgInfo.getLong("adminOrgId"));
                });
            }
        } else if (AdminOrgConstants.SPLIT_SCENE.equals(changeScene)) {
            Long beforeBoId = 0L;
            Object beforeSplitOrg = msgContentMap.get("beforesplitorg");
            if (beforeSplitOrg != null) {
                JSONObject mergeSplitMsgInfo = JSONObject.parseObject((String)JSONObject.toJSONString((Object)beforeSplitOrg));
                beforeBoId = mergeSplitMsgInfo.getLong("adminOrgId");
                orgBoIdSet.add(beforeBoId);
            }
            if (boId.longValue() != beforeBoId.longValue()) {
                LOG.error("ignore this adminorgmsg\uff0cboId:{},beforeBoId:{}", (Object)boId, (Object)beforeBoId);
                return null;
            }
            List afterSplitOrgList = (List)msgContentMap.get("aftersplitorg");
            afterSplitOrgList.forEach(beforeMergeOrg -> {
                JSONObject mergeSplitMsgInfo = JSONObject.parseObject((String)JSONObject.toJSONString((Object)beforeMergeOrg));
                orgBoIdSet.add(mergeSplitMsgInfo.getLong("adminOrgId"));
            });
        } else if (AdminOrgConstants.MODIFY_SCENE.equals(changeScene)) {
            List changedList = (List)msgContentMap.get("changed");
            ArrayList afterVidList = Lists.newArrayListWithExpectedSize((int)changedList.size());
            changedList.forEach(map -> afterVidList.add(Long.parseLong(map.get("aftervid") + "")));
            Map idDyMap = this.iBaseCommonDomainService.queryByIdList("haos_adminorgdetail", "datastatus,boid", (List)afterVidList);
            if (CollectionUtils.isNotEmpty((Map)idDyMap)) {
                afterVidList.forEach(afterVid -> {
                    DynamicObject dy = (DynamicObject)idDyMap.get(afterVid);
                    if (dy != null && "1".equals(dy.getString("datastatus"))) {
                        orgBoIdSet.add(dy.getLong("boid"));
                    }
                });
            }
        } else {
            String boidStr = (String)msgContentMap.getOrDefault("boid", "0");
            orgBoIdSet.add(Long.parseLong(boidStr));
        }
        return orgBoIdSet;
    }
}

