/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.adaptor.outbound;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.common.factory.ExecutorFactory;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdi.adaptor.common.IBizCommonSync;
import kd.hdtc.hrdi.adaptor.outbound.extend.DefaultPersonMainExtEntity;
import kd.hdtc.hrdi.adaptor.outbound.task.MsgOutIntAsyncTask;
import kd.hdtc.hrdi.business.application.external.IPersonDomainService;
import kd.hdtc.hrdi.business.application.external.entity.IMsgSubscriberEntityService;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.monitor.IMsgRecordLogDomainService;
import kd.hdtc.hrdi.business.domain.monitor.entity.IMsgRecordLogEntityService;
import kd.hdtc.hrdi.common.pojo.FourFloorPersonIdEntry;
import kd.sdk.hdtc.hrdi.adaptor.extend.IPersonMainEntityExtend;

public class PersonCommonSync
implements IBizCommonSync {
    private static final Log LOG = LogFactory.getLog(PersonCommonSync.class);
    private DynamicObject tplDy;
    private final IPersonDomainService iPersonDomainService = (IPersonDomainService)ServiceFactory.getService(IPersonDomainService.class);
    private final IMsgSubscriberEntityService iMsgSubscriberEntityService = (IMsgSubscriberEntityService)ServiceFactory.getService(IMsgSubscriberEntityService.class);
    private final IMsgRecordLogDomainService msgRecordLogDomainService = (IMsgRecordLogDomainService)ServiceFactory.getService(IMsgRecordLogDomainService.class);
    private final IMsgRecordLogEntityService msgRecordLogEntityService = (IMsgRecordLogEntityService)ServiceFactory.getService(IMsgRecordLogEntityService.class);

    @Override
    public void doSync(DynamicObject tplDy, String bizEntityNumber) {
        this.tplDy = tplDy;
        Map msgContentMap = (Map)this.parseMsgContent();
        LOG.info("PersonCommonSync message content:{}", (Object)msgContentMap);
        String caller = (String)msgContentMap.get("caller");
        String variationType = (String)msgContentMap.get("variationtype");
        Map entityNumberAndIdListMap = (Map)msgContentMap.get("data");
        String msgSubNo = tplDy.getString("msgsubno");
        String publishNumber = this.iMsgSubscriberEntityService.queryPublisherNumberByMsgSubNo(msgSubNo, "1");
        boolean delete = "MP20230816001100".endsWith(publishNumber);
        this.executeIscFlowService(entityNumberAndIdListMap, delete, caller, variationType, msgSubNo, tplDy.getString("number"));
    }

    private void executeIscFlowService(Map<String, List<Long>> entityNumberAndIdListMap, boolean delete, String caller, String variationType, String msgSubNo, String number) {
        ArrayList fourFloorPersonModelList = new ArrayList(16);
        HashSet fourFloorKeySet = new HashSet(16);
        Map personMainEntity = this.iPersonDomainService.getPersonMainEntity((IPersonMainEntityExtend)new DefaultPersonMainExtEntity());
        ArrayList mainPersonEntityList = new ArrayList(16);
        personMainEntity.forEach((entity, field) -> {
            List longList = (List)entityNumberAndIdListMap.get(entity);
            LOG.info("PersonCommonSync executeIscFlowService, entity:{}, field:{}", entity, field);
            if (CollectionUtils.isNotEmpty((Collection)longList)) {
                List fourFloorPersonDbList = this.iPersonDomainService.getFourFloorPersonIdEntryList(entity, longList, (IPersonMainEntityExtend)new DefaultPersonMainExtEntity());
                this.mergFourFloorPerson(fourFloorPersonModelList, fourFloorPersonDbList, fourFloorKeySet);
                mainPersonEntityList.add(entity);
                entityNumberAndIdListMap.remove(entity);
            }
        });
        ArrayList msgRecordLogIdList = Lists.newArrayListWithExpectedSize((int)16);
        if (CollectionUtils.isNotEmpty(fourFloorPersonModelList)) {
            fourFloorPersonModelList.forEach(fourFloorPersonModel -> {
                List PersonMainMsgRecordLogIdList = this.iPersonDomainService.handlePersonMainInt(fourFloorPersonModel, delete, caller, variationType, mainPersonEntityList, msgSubNo, number);
                msgRecordLogIdList.addAll(PersonMainMsgRecordLogIdList);
            });
        }
        entityNumberAndIdListMap.forEach((entityNumber, idList) -> {
            List PersonAttachMsgRecordLogIdList = this.iPersonDomainService.handlePersonAttachInt(idList, delete, caller, entityNumber, msgSubNo, number);
            msgRecordLogIdList.addAll(PersonAttachMsgRecordLogIdList);
        });
        MsgOutIntAsyncTask msgOutIntAsyncTask = new MsgOutIntAsyncTask(this.msgRecordLogEntityService, this.msgRecordLogDomainService, msgRecordLogIdList);
        ExecutorFactory.getCommonExecutor().submit(msgOutIntAsyncTask);
    }

    private void mergFourFloorPerson(List<FourFloorPersonIdEntry> allList, List<FourFloorPersonIdEntry> dbList, Set<String> fourFloorKeySet) {
        dbList.forEach(entry -> {
            String key = entry.getPersonId() + "_" + entry.getEmployeeId() + "_" + entry.getDepempId() + "_" + entry.getCmpempId();
            if (fourFloorKeySet.add(key)) {
                allList.add((FourFloorPersonIdEntry)entry);
            }
        });
    }

    protected <T> T parseMsgContent() {
        String msgContent = this.tplDy.getString("msgcontent");
        Map resultMap = (Map)SerializationUtils.deSerializeFromBase64((String)msgContent);
        return (T)resultMap;
    }
}

