/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.adaptor.outbound.event;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.common.util.ThrowableUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.adaptor.IBasicCommonIntDomainService;
import kd.hdtc.hrdi.business.domain.common.IBaseCommonDomainService;
import kd.hdtc.hrdi.business.domain.intgovern.IIntRelationDomainService;
import kd.hdtc.hrdi.business.domain.monitor.bean.EventMsgRecordContentBean;
import kd.hdtc.hrdi.business.domain.monitor.entity.IMsgRecordLogEntityService;

public class IntCommonEventServicePlugin
implements IEventServicePlugin {
    private static final Log logger = LogFactory.getLog(IntCommonEventServicePlugin.class);
    private final IIntRelationDomainService iIntRelationDomainService = (IIntRelationDomainService)ServiceFactory.getService(IIntRelationDomainService.class);
    private final IBaseCommonDomainService iBaseCommonDomainService = (IBaseCommonDomainService)ServiceFactory.getService(IBaseCommonDomainService.class);
    private final IBasicCommonIntDomainService outCommonIntDomainService = (IBasicCommonIntDomainService)ServiceFactory.getService(IBasicCommonIntDomainService.class);
    private final IMsgRecordLogEntityService msgRecordLogEntityService = (IMsgRecordLogEntityService)ServiceFactory.getService(IMsgRecordLogEntityService.class);

    public Object handleEvent(KDBizEvent evt) {
        EntityEvent entityEvent = (EntityEvent)evt;
        String entityNumber = entityEvent.getEntityNumber();
        String operation = entityEvent.getOperation();
        List businessKeys = entityEvent.getBusinesskeys();
        logger.info("handleEvent entityNumber={} , operation={} ,businessKeys={}", new Object[]{entityNumber, operation, businessKeys});
        this.handle(entityNumber, businessKeys, operation, evt.getEventId());
        return evt.getEventId();
    }

    private void handle(String entityNumber, List<String> businessKeys, String operation, Long eventId) {
        Map entityNumberIntRelationListMap = this.iIntRelationDomainService.queryEnableDataByMsgSubNo(Collections.singleton(entityNumber), "2", null, null);
        EventMsgRecordContentBean eventMsgRecordContentBean = this.getEventMsgRecordContent(entityNumber, businessKeys, operation, eventId);
        entityNumberIntRelationListMap.values().forEach(intRelations -> intRelations.forEach(intRelation -> {
            String errorInfo;
            Long eventMsgRecordLogId = this.msgRecordLogEntityService.saveEventMsgRecordLog(eventMsgRecordContentBean, intRelation);
            boolean exception = false;
            try {
                errorInfo = this.outCommonIntDomainService.basicOutIntHandle(intRelation, entityNumber, businessKeys, operation);
                logger.info("handle errorInfo{}", (Object)errorInfo);
            }
            catch (Exception e) {
                errorInfo = ThrowableUtils.toString((Throwable)e);
                logger.error("handle error:{} ", (Object)e.getMessage());
                exception = true;
            }
            this.msgRecordLogEntityService.updateEventMsgRecordLogStatus(eventMsgRecordLogId, errorInfo, exception);
        }));
    }

    private EventMsgRecordContentBean getEventMsgRecordContent(String entityNumber, List<String> businessKeys, String operation, Long eventId) {
        EventMsgRecordContentBean eventMsgRecordContentBean = new EventMsgRecordContentBean();
        eventMsgRecordContentBean.setEventId(eventId.toString());
        eventMsgRecordContentBean.setBusinessKeys(businessKeys);
        eventMsgRecordContentBean.setEntityNumber(entityNumber);
        eventMsgRecordContentBean.setOperation(operation);
        ArrayList numberList = Lists.newArrayListWithExpectedSize((int)businessKeys.size());
        ArrayList nameList = Lists.newArrayListWithExpectedSize((int)businessKeys.size());
        if (!"delete".equals(operation)) {
            Map idAndDyMap;
            boolean hisEntity = MetadataUtils.hisEntity((String)entityNumber);
            List idList = MetadataUtils.getPrimaryKeys(businessKeys, (String)entityNumber);
            if (hisEntity) {
                Set boIdSet = this.iBaseCommonDomainService.queryHisDataBoIdByIdList(entityNumber, idList);
                idAndDyMap = this.iBaseCommonDomainService.queryCurrentVersionDataByIdList(entityNumber, "name,number,boid", (Collection)boIdSet);
            } else {
                idAndDyMap = this.iBaseCommonDomainService.queryDataByIdList(entityNumber, "name,number", (Collection)idList);
            }
            idAndDyMap.forEach((id, dy) -> {
                numberList.add(dy.getString("number"));
                nameList.add(dy.getString("name"));
            });
        }
        eventMsgRecordContentBean.setNameList((List)nameList);
        eventMsgRecordContentBean.setNumberList((List)numberList);
        return eventMsgRecordContentBean;
    }
}

