/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.opplugin.web.common.validate;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.opplugin.validator.HDTCDataBaseValidator;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.common.IBaseCommonDomainService;

public class NameUniqueValidator
extends HDTCDataBaseValidator {
    private final IBaseCommonDomainService iBaseCommonDomainService = (IBaseCommonDomainService)ServiceFactory.getService(IBaseCommonDomainService.class);
    protected String nameErrorMsg;

    public void validate() {
        this.initErrorMsg();
        this.validateNameUnique();
    }

    protected void initErrorMsg() {
        this.nameErrorMsg = ResManager.loadKDString((String)"\u201c%s\u201d\u5df2\u5b58\u5728\u3002", (String)"NameUniqueValidator_0", (String)"hdtc-hrdi-opplugin", (Object[])new Object[0]);
    }

    protected void validateNameUnique() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        ArrayList newNameList = Lists.newArrayListWithExpectedSize((int)dataEntities.length);
        ArrayList idList = Lists.newArrayListWithExpectedSize((int)dataEntities.length);
        Arrays.stream(dataEntities).forEach(dy -> {
            DynamicObject dyn = dy.getDataEntity();
            if (newNameList.contains(dyn.getString("name"))) {
                String nameErrorInfo = String.format(Locale.ROOT, this.nameErrorMsg, dyn.getString("name"));
                this.addErrorMessage((ExtendedDataEntity)dy, nameErrorInfo);
            } else {
                newNameList.add(dyn.getString("name"));
            }
            if (dyn.getLong("id") > 0L) {
                idList.add(dyn.getLong("id"));
            }
        });
        String entityNumber = dataEntities[0].getDataEntity().getDataEntityType().getName();
        DynamicObjectCollection dynamicObjectCollection = this.iBaseCommonDomainService.queryOriginalEnableDataByName(entityNumber, (List)newNameList, (List)idList);
        if (CollectionUtils.isNotEmpty((Collection)dynamicObjectCollection)) {
            HashSet nameSet = Sets.newHashSetWithExpectedSize((int)dynamicObjectCollection.size());
            dynamicObjectCollection.forEach(dy -> nameSet.add(dy.getString("name")));
            for (ExtendedDataEntity dy2 : dataEntities) {
                DynamicObject dyx = dy2.getDataEntity();
                if (!nameSet.contains(dyx.getString("name"))) continue;
                String nameErrorInfo = String.format(Locale.ROOT, this.nameErrorMsg, dyx.getString("name"));
                this.addErrorMessage(dy2, nameErrorInfo);
            }
        }
    }
}

