/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.opplugin.web.common.validate;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.opplugin.validator.HDTCDataBaseValidator;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.common.IBaseCommonDomainService;

public class NumberUniqueValidator
extends HDTCDataBaseValidator {
    private final IBaseCommonDomainService iBaseCommonDomainService = (IBaseCommonDomainService)ServiceFactory.getService(IBaseCommonDomainService.class);
    private String numberErrorMsg;

    public void validate() {
        this.initErrorMsg();
        this.validateNumberUnique();
    }

    protected void initErrorMsg() {
        this.numberErrorMsg = ResManager.loadKDString((String)"\u8f93\u5165\u7684\u7f16\u7801\u503c\u201c%s\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"NameUniqueValidator_1", (String)"hdtc-hrdi-opplugin", (Object[])new Object[0]);
    }

    protected void validateNumberUnique() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        ArrayList newNumberList = Lists.newArrayListWithExpectedSize((int)dataEntities.length);
        ArrayList idList = Lists.newArrayListWithExpectedSize((int)dataEntities.length);
        Arrays.stream(dataEntities).forEach(dy -> {
            DynamicObject dyn = dy.getDataEntity();
            if (newNumberList.contains(dyn.getString("number"))) {
                String numberErrorInfo = String.format(Locale.ROOT, this.numberErrorMsg, dyn.getString("number"));
                this.addErrorMessage((ExtendedDataEntity)dy, numberErrorInfo);
            } else {
                newNumberList.add(dyn.getString("number"));
            }
            if (dyn.getLong("id") > 0L) {
                idList.add(dyn.getLong("id"));
            }
        });
        String entityNumber = dataEntities[0].getDataEntity().getDataEntityType().getName();
        DynamicObjectCollection dynamicObjectCollection = this.iBaseCommonDomainService.queryOriginalEnableDataByNumber(entityNumber, (List)newNumberList, (List)idList);
        if (CollectionUtils.isNotEmpty((Collection)dynamicObjectCollection)) {
            HashSet numberSet = Sets.newHashSetWithExpectedSize((int)dynamicObjectCollection.size());
            dynamicObjectCollection.forEach(dy -> numberSet.add(dy.getString("number")));
            for (ExtendedDataEntity dy2 : dataEntities) {
                DynamicObject dyx = dy2.getDataEntity();
                if (!numberSet.contains(dyx.getString("number"))) continue;
                String nameErrorInfo = String.format(Locale.ROOT, this.numberErrorMsg, dyx.getString("number"));
                this.addErrorMessage(dy2, nameErrorInfo);
            }
        }
    }
}

