/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.opplugin.web.datamapping.op;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.opplugin.web.HDTCDataBaseOp;
import kd.hdtc.hrdi.business.application.external.entity.IHricMidtableTplEntityService;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.adaptor.covert.hricmidtable.IHRICMidTableCovert;
import kd.hdtc.hrdi.business.domain.datamapping.bo.EntityObjDataMappingBo;
import kd.hdtc.hrdi.business.domain.datamapping.entity.DataMappingFactory;
import kd.hdtc.hrdi.business.domain.datamapping.entity.IDataMappingLogEntityService;
import kd.hdtc.hrdi.business.domain.intgovern.IIntSourceDomainService;

public class DataMappingRetryOp
extends HDTCDataBaseOp {
    private static final Log LOG = LogFactory.getLog(DataMappingRetryOp.class);
    private final IDataMappingLogEntityService dataMappingLogEntityService = (IDataMappingLogEntityService)ServiceFactory.getService(IDataMappingLogEntityService.class);
    private final IHricMidtableTplEntityService midTableTplEntityService = (IHricMidtableTplEntityService)ServiceFactory.getService(IHricMidtableTplEntityService.class);
    private final IIntSourceDomainService intSourceDomainService = (IIntSourceDomainService)ServiceFactory.getService(IIntSourceDomainService.class);

    public void onPreparePropertys(PreparePropertysEventArgs eventArgs) {
        List fieldKeys = eventArgs.getFieldKeys();
        fieldKeys.add("datamaprecord");
        fieldKeys.add("datamaprecord.intsource.id");
        fieldKeys.add("startoffset");
        fieldKeys.add("endoffset");
        fieldKeys.add("retrycount");
        fieldKeys.add("handlecount");
        fieldKeys.add("errorinfo");
        fieldKeys.add("errorinfo_tag");
        fieldKeys.add("handlestatus");
    }

    public void onAddValidators(AddValidatorsEventArgs eventArgs) {
        Object[] dataEntities = eventArgs.getDataEntities();
        if (ArrayUtils.isEmpty((Object[])dataEntities)) {
            return;
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        Object[] dataEntities = args.getDataEntities();
        if (ArrayUtils.isEmpty((Object[])dataEntities)) {
            return;
        }
        List intSourceIdList = Arrays.stream(dataEntities).map(dynamicObject -> dynamicObject.getLong("datamaprecord.intsource.id")).collect(Collectors.toList());
        Map initSourceMap = this.intSourceDomainService.queryByIds(intSourceIdList);
        for (Object dataEntity : dataEntities) {
            int retryCount = dataEntity.getInt("retrycount");
            try {
                long initSourceId = dataEntity.getLong("datamaprecord.intsource.id");
                LOG.info("the DataMappingRetryOp retry initSourceId is {} ", (Object)initSourceId);
                DynamicObject initSource = (DynamicObject)initSourceMap.get(initSourceId);
                String entityObjId = initSource.getString("entityobj.id");
                LOG.info("the DataMappingRetryOp retry entityObjId is {} ", (Object)entityObjId);
                DynamicObject dataMappingRecord = dataEntity.getDynamicObject("datamaprecord");
                String midTableNumber = dataMappingRecord.getString("midtablenumber");
                IHRICMidTableCovert midTableCovert = this.getHRICMidTableCovert(entityObjId);
                Long startOffset = dataEntity.getLong("startoffset");
                Long endOffset = dataEntity.getLong("endoffset");
                DynamicObject[] midTableDataList = this.midTableTplEntityService.getMidTableDataList(midTableNumber, midTableCovert.queryFields(), startOffset, endOffset);
                LOG.info("the DataMappingRetryOp retry midTableCovert covert start ");
                List dataMappings = midTableCovert.covert(entityObjId, Arrays.asList(midTableDataList), dataMappingRecord.getString("relationinfo"));
                LOG.info("the DataMappingRetryOp retry EntityObjDataMappingBo save start ");
                new EntityObjDataMappingBo(dataMappings).save();
                LOG.info("the DataMappingRetryOp retry EntityObjDataMappingBo save end ");
                dataEntity.set("errorinfo", null);
                dataEntity.set("handlestatus", (Object)"1");
                dataEntity.set("retrycount", (Object)(retryCount + 1));
                dataEntity.set("handlecount", (Object)dataMappings.size());
                this.dataMappingLogEntityService.save((DynamicObject)dataEntity);
                LOG.info("the DataMappingRetryOp retry success ");
            }
            catch (Exception ex) {
                String errorMessage = ex.getMessage();
                if (StringUtils.isNotEmpty((String)errorMessage)) {
                    if (errorMessage.length() > 255) {
                        dataEntity.set("errorinfo", (Object)errorMessage.substring(0, 255));
                    } else {
                        dataEntity.set("errorinfo", (Object)errorMessage);
                    }
                    dataEntity.set("errorinfo_tag", (Object)errorMessage);
                }
                dataEntity.set("handlestatus", (Object)"2");
                dataEntity.set("retrycount", (Object)(retryCount + 1));
                this.dataMappingLogEntityService.save((DynamicObject)dataEntity);
                LOG.info("the DataMappingRetryOp retry error: {}", (Object)errorMessage);
                LOG.error((Throwable)ex);
            }
        }
    }

    private IHRICMidTableCovert getHRICMidTableCovert(String entityObjId) {
        return new DataMappingFactory().getHRICMidTableCovert(entityObjId);
    }
}

